<?php

/**
 * Template part for displaying the header navigation menu
 *
 * @package streamit
 */

namespace Streamit\Utility;

use Streamit\Utility\Dynamic_Style\Styles\Header;

global $streamit_options;

$header_response = $site_classes = '';

$is_header = $is_default_header = true;
if (class_exists('ReduxFramework')) {
    $site_classes   = 'streamit';
    $header         = new Header();
    $is_header      = $header->is_streamit_header();
}

if (!function_exists('is_plugin_active')) include_once(ABSPATH . 'wp-admin/includes/plugin.php');

if ($is_header && is_plugin_active('advanced-custom-fields/acf.php') && class_exists('ReduxFramework') && is_plugin_active('iqonic-layouts/iqonic-layout-extension.php')) {

    $id             = (get_queried_object_id()) ? get_queried_object_id() : '';
    $meta           = get_post_meta($id);
    $header_display = $header_layout = $header_name = $h_layout_position = '';

    // ------------HEADER START ------------------
    if (!empty($id)) {
        $header_display     = $meta['name_header_display'][0] ?? '';
        $header_layout      = $meta['header_layout_type'][0]  ?? '';
        $header_name        = $meta['header_layout_name'][0]  ?? '';
        $h_layout_position  = $meta['header_postion'][0]      ?? '';
    }

    if ($header_display === 'yes' && $header_layout === 'custom' && !empty($header_name)) {
        $header             = $header_name;
        $my_layout          = get_page_by_path($header, '', 'iqonic_hf_layout');
        $header_response    =  streamit()->streamit_get_layout_content($my_layout->ID);
    } else if (isset($streamit_options['header_layout']) && $streamit_options['header_layout'] == 'custom' && !empty($streamit_options['menu_style'])) {
        $header             = $streamit_options['menu_style'];
        $my_layout          = get_page_by_path($header, '', 'iqonic_hf_layout');
        $header_response    =  streamit()->streamit_get_layout_content($my_layout->ID);
    }

    // ------------HEADER END ------------------

    $is_default_header = empty($header_response);

    if ($h_layout_position === 'over' || (isset($streamit_options['header_postion']) && $streamit_options['header_postion'] == 'over')) {
        $site_classes .= ' header-over';
    }
} ?>

<div id="page" class="site <?php echo esc_attr(trim($site_classes)); ?>">
    <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'streamit'); ?></a>
    <?php if ($is_header && !$is_default_header && !empty($header_response)) { ?>
        <header class="header-default iq-layout-header" id="default-header">
            <?php echo $header_response; ?>
        </header> <!-- #masthead -->
    <?php } elseif ($is_header) {
        get_template_part('template-parts/header/default-header/header', 'default');
    } ?>

    <div class="site-content-contain">
        <div id="content" class="site-content">
            <?php get_template_part('template-parts/breadcrumb/breadcrumb'); ?>