<?php

/**
 * Template part for displaying the header navigation menu
 *
 * @package streamit
 */

namespace Streamit\Utility;

global $streamit_options;

if (streamit()->is_amp()) {
	$class = "[class]= siteNavigationMenu.expanded ? 'main-navigation nav--toggle-sub nav--toggle-small nav--toggled-on' : 'main-navigation nav--toggle-sub nav--toggle-small'";
} else {
	$class = '';
} ?>

<nav id="site-navigation" class="navbar navbar-expand-lg navbar-light p-0" aria-label="<?php esc_attr_e('Main menu', 'streamit'); ?>" <?php esc_attr($class); ?>>
	<a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
		<?php get_template_part('template-parts/header/default-header/header', 'logo'); ?>
	</a>

	<div id="navbarSupportedContent" class="collapse navbar-collapse new-collapse">
		<?php
		if (streamit()->is_primary_nav_menu_active()) {
			streamit()->display_primary_nav_menu(array(
				'theme_location' => 'top',
				'menu_class'     => 'navbar-nav ml-auto',
				'menu_id'        => 'top-menu',
				'container'       => 'div',
				'container_id'   => 'iq-menu-container',
			));
		} ?>
	</div>

	<div class="sub-main">
		<nav aria-label="breadcrumb">
			<?php get_template_part('template-parts/header/default-header/header', 'user'); ?>
		</nav>

		<button class="navbar-toggler custom-toggler ham-toggle streamit-menu-box" type="button" data-toggle="collapse" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
			<span class="navbar-toggler-icon">
				<span class="menu-btn d-inline-block" id="menu-btn">
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
						<rect width="4" height="4" fill="white"></rect>
						<rect x="6" width="4" height="4" fill="white"></rect>
						<rect x="12" width="4" height="4" fill="white"></rect>
						<rect y="6" width="4" height="4" fill="white"></rect>
						<rect x="6" y="6" width="4" height="4" fill="white"></rect>
						<rect x="12" y="6" width="4" height="4" fill="white"></rect>
						<rect y="12" width="4" height="4" fill="white"></rect>
						<rect x="6" y="12" width="4" height="4" fill="white"></rect>
						<rect x="12" y="12" width="4" height="4" fill="white"></rect>
					</svg>
				</span>
			</span>
		</button>
	</div>
</nav><!-- #site-navigation -->
<div class="nav-overlay"></div>