<?php

/**
 * Template part for displaying the header navigation menu
 *
 * @package streamit
 */

namespace Streamit\Utility;

global $streamit_options;
$is_img = true; ?>

<nav class="streamit-menu-wrapper mobile-menu">
    <div class="navbar">
        <a class="navbar-brand " href="<?php echo esc_url(home_url('/')); ?>">
            <?php get_template_part('template-parts/header/default-header/header', 'logo'); ?>
        </a>

        <?php if (streamit()->is_primary_nav_menu_active()) : ?>
            <button class="navbar-toggler custom-toggler ham-toggle streamit-menu-box" type="button">
                <span class="menu-btn d-inline-block">
                    <span class="line one"></span>
                    <span class="line two"></span>
                    <span class="line three"></span>
                </span>
            </button>
        <?php endif; ?>
    </div>

    <?php if (streamit()->is_primary_nav_menu_active()) : ?>
        <div class="c-collapse">
            <div class="menu-new-wrapper row align-items-center">
                <div class="menu-scrollbar verticle-mn yScroller col-lg-12">
                    <div id="streamit-menu-main" class="streamit-full-menu">
                        <?php streamit()->display_primary_nav_menu(array('menu_id' => 'top-menu', 'menu_class' => 'navbar-nav',)); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</nav><!-- #site-navigation -->