<?php

/**
 * Template part for displaying the header navigation menu
 *
 * @package streamit
 */

namespace Streamit\Utility;

if (!class_exists('ReduxFramework')) return;

global $streamit_options;

$get_avatar = get_template_directory_uri() . '/assets/images/redux/user.png';
if (is_user_logged_in()) {
	$current_user = wp_get_current_user();
	$get_avatar = get_the_author_meta('streamit_profile_image', $current_user->ID);
	if (empty($get_avatar)) {
		$get_avatar = get_avatar_url($current_user->ID);
	}
} ?>

<div class="iq-usermenu-dropdown">
	<ul class="d-flex align-items-center">
		<?php if (isset($streamit_options['display_search_icon_header']) && $streamit_options['display_search_icon_header'] == 'yes') {
			if ($streamit_options['search_style'] == 'style-1') { ?>
				<li class="nav-item nav-icon header-search-right iq-ajax-search iq-ajax-search-2">
					<a href="javascript:void(0);" class="search-toggle device-search active" id="btn-search">
						<i class="fas fa-search"></i>
					</a>

					<div class="search-box iq-search-bar d-search">
						<?php get_search_form(["is_header_ajax" => true]); ?>
					</div>
				</li>
			<?php } else { ?>
				<li class="nav-item nav-icon header-search-right iq-ajax-search iq-ajax-search-2">
					<a href="javascript:void(0);" class="search-toggle device-search active" id="btn-search">
						<i aria-hidden="true" class="fa fa-search"></i>
					</a>

					<div class="search-box iq-search-bar default-search d-search">
						<?php get_search_form(["is_header_ajax" => true]); ?>
					</div>
				</li>
			<?php
			}
		}

		if (isset($streamit_options['enable_notification_module']) && $streamit_options['enable_notification_module'] == 'yes') { ?>
			<li class="streamit-notification">
				<a href="javascript:void(0);" class="notification-wrapper">
					<i class="fas fa-bell"></i>
					<span class="notification-count"></span>
				</a>
			</li>
		<?php
		}

		if (isset($streamit_options['display_user_icon_header']) && $streamit_options['display_user_icon_header'] == 'yes') {
			get_template_part('template-parts/header/default-header/header-user_dropdown');
		} ?>
	</ul>
</div>