<?php

/**
 * Template part for displaying the header navigation menu
 *
 * @package streamit
 */

namespace Streamit\Utility;

global $streamit_options;

if (isset($args['custom_logo']) && !empty($args['custom_logo'])) { ?>
    <img src="<?php echo esc_url($args['custom_logo']) ?>" alt="streamit" class="img-fluid logo">
<?php
    return;
}

if (is_plugin_active('advanced-custom-fields/acf.php') || class_exists('ReduxFramework')) {
    $is_yes = get_post_meta(get_the_ID(), 'name_header_display', true);
    $acf_logo = get_post_meta(get_the_ID(), 'header_logo', true);

    if ($is_yes === 'yes' && !empty($acf_logo)) {
        $options = wp_get_attachment_url($acf_logo);
    } else if (isset($streamit_options['header_radio'])) {
        if ($streamit_options['header_radio'] == 1) {
            $logo_text = $streamit_options['header_text'];
            $is_img = false;
            echo esc_html($logo_text);
        }
        if ($streamit_options['header_radio'] == 2) {
            $options = $streamit_options['streamit_logo']['url'];
        }
    }

    if (isset($options) && !empty($options)) {
        echo streamit()->streamit_get_svg($options, "img-fluid logo");
    }
} elseif (has_header_image()) {
    $image = wp_get_attachment_image_src(get_theme_mod('custom_logo'), 'full');
    if (has_custom_logo()) {
        echo streamit()->streamit_get_svg($image, "img-fluid logo");
    } else {
        bloginfo('name');
    }
} else {
    $logo_url = get_template_directory_uri() . '/assets/images/logo.png';
    echo streamit()->streamit_get_svg($logo_url, "img-fluid logo");
}
