<?php

/**
 * Template part for displaying the default header
 *
 * @package streamit
 */

namespace Streamit\Utility;

global $streamit_options;

$has_sticky = $default_header_container = '';

if (class_exists('ReduxFramework')) {

    //sticky header
    if (isset($streamit_options['sticky_header_display']) && $streamit_options['sticky_header_display'] == 'yes') {
        $has_sticky = 'has-sticky';
    }

    // container
    if (isset($streamit_options['header_container'])) {
        $default_header_container = ($streamit_options['header_container'] == 'container') ? 'container' : 'container-fluid';
    }
} else {
    $has_sticky = 'has-sticky';
    $default_header_container = 'container-fluid';
} ?>

<header class="iq-ltr-direction style-one <?php echo esc_attr($has_sticky); ?>" id="main-header">
    <?php if (isset($streamit_options['email_and_button']) && $streamit_options['email_and_button'] == "yes") { ?>
        <div class="<?php echo esc_attr($default_header_container); ?> sub-header">
            <div class="row align-items-center">
                <div class="col-auto">
                    <?php if (!empty($streamit_options['header_display_contact']) && $streamit_options['header_display_contact'] == "yes") { ?>
                        <div class="number-info">
                            <ul class="list-inline">
                                <?php if (!empty($streamit_options['header_email'])) { ?>
                                    <li class="list-inline-item">
                                        <a href="mailto:<?php echo esc_html($streamit_options['header_email']); ?>">
                                            <i class="fas fa-envelope"></i>
                                            <?php echo esc_html($streamit_options['header_email']); ?>
                                        </a>
                                    </li>
                                <?php }

                                if (!empty($streamit_options['header_phone'])) { ?>
                                    <li class="list-inline-item">
                                        <a href="tel:<?php echo str_replace(str_split('(),-" '), '', $streamit_options['header_phone']); ?>">
                                            <i class="fas fa-phone"></i>
                                            <?php echo esc_html($streamit_options['header_phone']); ?>
                                        </a>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php } ?>
                </div>

                <div class="col-auto col-auto ml-auto sub-main">
                    <?php if (isset($streamit_options['streamit_header_social_media']) && $streamit_options['streamit_header_social_media'] == "yes") { ?>
                        <div class="social-icone">
                            <?php $data = $streamit_options['social-media-iq']; ?>
                            <ul class="list-inline">
                                <?php foreach ($data as $key => $options) {
                                    if ($options) {
                                        echo '<li class="d-inline"><a href="' . $options . '"><i class="fab fa-' . $key . '"></i></a></li>';
                                    }
                                } ?>
                            </ul>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    <?php } ?>

    <div class="<?php echo esc_attr($default_header_container); ?>">
        <div class="row align-items-center">
            <div class="col-md-12">
                <?php get_template_part('template-parts/header/default-header/navigation'); ?>
            </div>
        </div>
    </div>
</header><!-- #masthead -->

<div class="streamit-mobile-menu menu-style-one default-menu">
    <?php get_template_part('template-parts/header/default-header/navigation', 'mobile'); ?>
</div>