<?php

/**
 * Template part for displaying the Cast 
 *
 * @package streamit
 */

namespace Streamit\Utility;

global $streamit_options;

$trailer_img    = '';
$align          =  'trailer-play-btn';
$trailer_link   = get_post_meta(get_the_ID(), 'name_trailer_link', true);

$should_display_trailer                 = isset($streamit_options['streamit_display_trailer_link']) && $streamit_options['streamit_display_trailer_link'] === 'yes';
$should_display_trailer_for_post_type   = in_array(get_post_type(), $streamit_options['streamit_opt_multi_select']);

if ($should_display_trailer && $should_display_trailer_for_post_type) {
    if ($streamit_options['streamit_display_trailer_link_btn'] == 'no') {
        $trailer_img = get_post_meta(get_the_ID(), 'name_trailer_img', true);
        $align =  empty($trailer_img) && !has_post_thumbnail() ? ' trailer-play-btn ' : '';
    } ?>

    <div class="trailor-video  text-sm-right p-3 <?php echo esc_attr($align); ?> col-md-3 col-12">
        <?php streamit()->streamit_video_playbtn($streamit_options, $trailer_link, $trailer_img); ?>
    </div>
<?php
}
