<?php

$post_id        = $args['id'] ??  get_the_ID();
$episode_number = $episode_run_time = $episode_release_date = '';
$episode_number =  get_post_meta($post_id, '_episode_number', true);

if (apply_filters('streamit_show_episode_number_in_format', !preg_match("/[a-z]/i", $episode_number))) {
    $season = isset($args['season'])  && $args['season'] != true ? $args['season'] : "1";
    $episode_number = sprintf("S%sE%s", strlen($season) == 1 ? "0" . $season : $season,  strlen($episode_number) == 1 ? "0" . $episode_number : $episode_number);
}

if (!empty(($episode_lable = get_post_meta($post_id, '_episode_label', true)))) {
    $episode_number = $episode_lable;
}

$_thumbnail_id          = get_post_meta($post_id, '_thumbnail_id', true);
$episode_run_time       = get_post_meta($post_id, '_episode_run_time', true);
$_episode_season_no     = get_post_meta($post_id, '_tv_show_season_id', true);
$episode_release_date   = date_i18n(get_option('date_format'),  get_post_meta($post_id, '_episode_release_date', true));

$url                    = !empty($_thumbnail_id) ? wp_get_attachment_url($_thumbnail_id) : ''; ?>

<div class="col-lg-3 col-md-6 col-sm-6 iq-mb-30 single-season-data animated fadeIn active show" data-display="<?php echo esc_attr($_episode_season_no); ?>">
    <div class="epi-box">
        <div class="epi-img position-relative">
            <img src="<?php echo esc_url($url ?? "#"); ?>" class="img-fluid img-zoom" alt="<?php echo get_the_title($post_id) ?>">
            <div class="episode-number"><?php echo esc_html($episode_number); ?></div>
            <div class="episode-play-info">
                <div class="episode-play">
                    <a href="<?php the_permalink($post_id); ?>">
                        <i class="fas fa-play"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="epi-desc p-3">
            <div class="d-flex align-items-center justify-content-between mb-3">
                <span class="rel-date"><?php echo esc_html($episode_release_date); ?></span>
                <span class="text-primary run-time"><?php echo esc_html($episode_run_time); ?></span>
            </div>
            <a href="<?php the_permalink($post_id); ?>">
                <h6 class="epi-name mb-0">
                    <?php echo esc_html(get_the_title($post_id)); ?>
                </h6>
            </a>
        </div>
    </div>
</div>