<?php

/**
 * Template part for displaying the footer info
 *
 * @package streamit
 */

namespace Streamit\Utility;

$year = date('Y');
if (class_exists('ReduxFramework')) {
	global $streamit_options;

	if (isset($streamit_options['display_copyright']) &&  $streamit_options['display_copyright'] == 'yes') {
		$copyright_align = $streamit_options['footer_copyright_align'];
		if ($copyright_align == '1') {
			$align = 'left';
		} else if ($copyright_align == '2') {
			$align = 'right';
		} else {
			$align = 'center';
		} ?>

		<div class="copyright-footer">
			<div class="pt-3 pb-3">
				<div class="row flex-row-reverse justify-content-between">
					<div class="col-lg-12 col-md-12 text-lg-<?php echo esc_attr($align); ?> text-md-center text-center">
						<?php if (isset($streamit_options['footer_copyright'])) {  ?>
							<span class="copyright">
								<?php
								$copyright = str_replace("{{year}}", $year, $streamit_options['footer_copyright']);
								echo html_entity_decode($copyright);
								?>
							</span>
						<?php } else {	?>
							<span class="copyright">
								<a target="_blank" rel="nofollow" href="<?php echo esc_url('https://themeforest.net/user/iqonicthemes/portfolio/'); ?>">
									<?php esc_html_e("© $year", 'streamit'); ?>
									<strong><?php esc_html_e(' Streamit ', 'streamit'); ?></strong>
									<?php esc_html_e('. All Rights Reserved.', 'streamit'); ?>
								</a>
							</span>
						<?php } ?>
					</div>
				</div>
			</div>
		</div><!-- .site-info -->
	<?php } ?>
<?php } else { ?>
	<div class="copyright-footer">
		<div class="pt-3 pb-3">
			<div class="row flex-row-reverse justify-content-between">
				<div class="col-lg-12 col-md-12 text-center">
					<span class="copyright">
						<a target="_blank" rel="nofollow" href="<?php echo esc_url(esc_html__('https://themeforest.net/user/iqonicthemes/portfolio/', 'streamit')); ?>">
							<?php esc_html_e("© $year", 'streamit'); ?>
							<strong><?php esc_html_e(' streamit ', 'streamit'); ?></strong>
							<?php esc_html_e('. All Rights Reserved.', 'streamit'); ?>
						</a>
					</span>
				</div>
			</div>
		</div>
	</div><!-- .site-info -->
<?php } ?>