<?php

global $streamit_options;

$content    = isset($args['contentID']) ? $args['contentID']  : '';
$Watchmeta  = isset($args['Watchmeta']) ? (array) $args['Watchmeta']  : false;
$style      = isset($args['style']) ? $args['style']  : false;
$post_type  = get_post_type($content);
$lazy_load  = isset($args['lazy_load']) && !empty($args['lazy_load']) ? true  : false;

if (!$content || !get_post_status($content)) return;

$run_time           = get_post_meta($content, '_' . $post_type . '_run_time', true);
$movie_url_link     = get_post_meta($content, '_' . $post_type . '_url_link', true);
$movie_choice       = get_post_meta($content, '_' . $post_type . '_choice', true);
$url_link           = $movie_choice == $post_type . '_url' ? $movie_url_link : get_the_permalink($content);
$image_alt          = get_the_title($content);

$img_class = $srcset = '';

if (has_post_thumbnail($content)) {
    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($content), "full");
    $full_image = $full_image[0];

    if ($lazy_load) {
        $img_class  = ' iqonic-lazy';
        $lazy_image = get_lazy_load_image();

        $original_image = $full_image;
        $full_image     = $lazy_image;
        $srcset         = "data-srcset=" . $original_image . "";
    }
} else {
    $full_image = get_lazy_load_image();
}

$diffTime = (int)$Watchmeta['watchedTotalTime'] - (int)$Watchmeta['watchedTime'];
$diffTimeFormated =  gmdate("i:s", $diffTime);
$rightOffset =  $Watchmeta['watchedTimePercentage'] > 84 ? '14%' : '0px';

if ($Watchmeta['watchedTimePercentage'] < 16) {
    $rightOffset = '-' . abs($Watchmeta['watchedTimePercentage'] - 16) . '%';
}

if ($style == 1) { ?>
    <li class="slide-item">
        <div class="block-images position-relative">
            <div class="img-box">
                <img src="<?php echo esc_url($full_image) ?>" class="img-fluid <?php echo esc_attr($img_class); ?>" alt="<?php echo esc_attr($image_alt); ?>" <?php echo esc_attr($srcset); ?>>
            </div>

            <div class="block-description">
                <h6 class="iq-title">
                    <a href="<?php echo get_the_permalink($content); ?>">
                        <?php echo esc_html(get_the_title($content)); ?>
                    </a>
                </h6>
                <div class="movie-time d-flex align-items-center my-2 ">
                    <span class="movie-time-text font-normal"><?php echo esc_html($run_time); ?></span>
                </div>
                <div class="hover-buttons">
                    <a href="<?php echo get_the_permalink($content); ?>" class="btn btn-hover iq-button">
                        <i class="fa fa-play mr-1" aria-hidden="true"></i>
                        <?php echo _x('Play Now', 'continue-watch', 'streamit'); ?>
                    </a>
                </div>
            </div>

            <div class="block-social-info">
                <ul class="list-inline p-0 m-0 music-play-lists">
                    <?php if (isset($streamit_options['streamit_display_social_icons']) && $streamit_options['streamit_display_social_icons'] == 'yes') { ?>
                        <li class="share">
                            <span><i class="fas fa-share-alt"></i></span>
                            <div class="share-wrapper">
                                <div class="share-box">
                                    <svg width="15" height="40" class="share-shape" viewBox="0 0 15 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.8842 40C6.82983 37.2868 1 29.3582 1 20C1 10.6418 6.82983 2.71323 14.8842 0H0V40H14.8842Z" fill="#191919" />
                                    </svg>
                                    <div class="d-flex align-items-center justify-content-center overflow-hidden">
                                        <a href="https://www.facebook.com/sharer?u=<?php echo get_the_permalink($content); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="fab fa-facebook-f"></i></a>
                                        <a href="http://twitter.com/intent/tweet?text=<?php the_title(); ?>&url=<?php echo get_the_permalink($content); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="fab fa-twitter"></i></a>
                                        <a href="#" data-link='<?php the_permalink($content); ?>' class="share-ico iq-copy-link"><i class="fas fa-link"></i></a>
                                    </div>
                                </div>
                            </div>
                        </li>
                    <?php } ?>

                    <?php if (class_exists('WpUlikeInit') && isset($streamit_options['streamit_display_like']) && $streamit_options['streamit_display_like'] == 'yes') { ?>
                        <li>
                            <div class="iq-like-btn"><?php echo do_shortcode('[wp_ulike for="movie" id="' . $content . '" style="wpulike-heart"]'); ?></div>
                        </li>
                    <?php }

                    if (isset($streamit_options['streamit_display_watchlist']) && $streamit_options['streamit_display_watchlist'] == 'yes') { ?>
                        <li>
                            <?php if (!is_user_logged_in()) {
                                if (isset($streamit_options['streamit_signin_link'])) {
                                    $iqonic_signin_link = get_page_link($streamit_options['streamit_signin_link']); ?>
                                    <a class="watch-list-not" href="<?php echo esc_url($iqonic_signin_link) ?>">
                                        <span><i class="fas fa-plus"></i></span>
                                    </a>
                                <?php }
                            } else { ?>
                                <a class="watch-list" rel="<?php echo esc_attr($content); ?>">
                                    <?php echo add_to_watchlist($content); ?>
                                </a>
                            <?php } ?>
                        </li>
                    <?php } ?>
                </ul>
            </div>

            <span class="streamit-preogress" style="--progress-percentage:<?php echo esc_attr($Watchmeta['watchedTimePercentage'] . '%'); ?>; --right-offset : <?php echo esc_attr($rightOffset); ?>" data-left-time="<?php printf('%s %s', $diffTimeFormated, __('Left', 'streamit')) ?>"></span>
        </div>
    </li>
<?php
}

if ($style == 2) { ?>
    <li class="slide-item">
        <div class="block-images position-relative">
            <a class="overly-images" href="<?php echo get_the_permalink($content); ?>"> </a>
            <div class="img-box">
                <a href="<?php echo get_the_permalink($content); ?>">
                    <img src="<?php echo esc_url($full_image) ?>" class="img-fluid <?php echo esc_attr($img_class); ?>" alt="<?php echo esc_attr($image_alt); ?>" <?php echo esc_attr($srcset); ?>>
                </a>
            </div>

            <span class="streamit-preogress" style="--progress-percentage:<?php echo esc_attr($Watchmeta['watchedTimePercentage'] . '%'); ?>; --right-offset : <?php echo esc_attr($rightOffset); ?>" data-left-time="<?php printf('%.2f of %.2f m', $Watchmeta['watchedTime'] / 60, (int)$Watchmeta['watchedTotalTime'] / 60, __('Left', 'streamit')) ?>"></span>
        </div>
    </li>
<?php
}
