<?php

/**
 * Template part for displaying a post's featured image
 *
 * @package streamit
 */

namespace Streamit\Utility;

// Audio or video attachments can have featured images, so they need to be specifically checked.
$support_slug = get_post_type();
if ('attachment' === $support_slug) {
	if (wp_attachment_is('audio')) {
		$support_slug .= ':audio';
	} elseif (wp_attachment_is('video')) {
		$support_slug .= ':video';
	}
}

if (post_password_required() || !post_type_supports($support_slug, 'thumbnail')) {
	return;
}


streamit()->streamit_go_back_button();

if (has_post_thumbnail()) : ?>
	<div class="iq-blog-box-image">
		<?php the_post_thumbnail('', array('class' => 'skip-lazy')); ?>
	</div>
<?php endif; ?>