<?php

/**
 * Template part for displaying a post's featured image
 *
 * @package streamit
 */

namespace Streamit\Utility;

$postcat = get_the_category();

if ($postcat) {
	$post_category_list = '<ul class="iq-blog-category-2">';
	foreach ($postcat as $cat) {
		$post_category_list .= '<li><a href="' . get_category_link($cat->cat_ID) . '">' . esc_html($cat->name) . '</a></li>';
	}
	$post_category_list .= '</ul>';
} else {
	$post_category_list = '';
}

//post published date
$archive_year  = get_the_time('Y');
$archive_month = get_the_time('m');
$archive_day   = get_the_time('d');
$time_string = get_day_link($archive_year, $archive_month, $archive_day);

//author details
$author_id = get_the_author_meta('ID');
$author_url = get_author_posts_url($author_id);
$author_name = get_the_author_meta('display_name', $author_id);

$author_image = get_the_author_meta('streamit_profile_image', $author_id);
if (empty($author_image)) {
	$author_image = get_avatar_url($author_id);
} ?>

<div class="iq-blog-meta-details">
	<?php echo wp_kses($post_category_list, $args['allowed_html']); ?>

	<div class="iq-extra-details">
		<div class="iq-reading-time">
			<?php echo get_post_meta(get_the_ID(), '_streamit_post_read_time', true); ?>
		</div>

		<div class="iq-comments-count">
			<?php $comments_number = get_comments_number();
			echo '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M12.2428 12.2419C10.4091 14.0758 7.69386 14.472 5.47185 13.4444C5.14382 13.3123 4.87489 13.2056 4.61922 13.2056C3.90709 13.2098 3.0207 13.9003 2.56002 13.4402C2.09933 12.9795 2.79036 12.0924 2.79036 11.3759C2.79036 11.1202 2.68785 10.8561 2.55579 10.5274C1.5277 8.30577 1.92447 5.58961 3.75816 3.75632C6.09896 1.41466 9.90201 1.41466 12.2428 3.75572C14.5878 6.101 14.5836 9.90086 12.2428 12.2419Z" stroke="#E50914" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/><path d="M10.3637 8.24775H10.3691" stroke="#E50914" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M7.95843 8.24775H7.96383" stroke="#E50914" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M5.55316 8.24775H5.55856" stroke="#E50914" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>';
			echo esc_html($comments_number);
			echo '<span>';
			echo _n(" Comment", " Comments", $comments_number, 'streamit');
			echo '</span>'; ?>
		</div>
	</div>
</div>

<h3 class="iq-title">
	<?php echo get_the_title() ?>
</h3>

<div class="iq-author-details">
	<div class="iq-author-avatar">
		<img src="<?php echo esc_url($author_image) ?>" class="avatar img-fluid avatar-40 rounded-circle" alt="user">

		<div class="iq-author-name">
			<?php echo esc_html__('By ', 'streamit');
			echo '<span><a href="' . esc_url($author_url) . '">' . esc_html($author_name) . '</a></span>'; ?>
		</div>
	</div>

	<div class="iq-published-date">
		<?php echo '<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2.19336 5.59936H11.8109" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"/><path d="M9.39685 7.70678H9.40185" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"/><path d="M7.00232 7.70678H7.00732" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"/><path d="M4.60291 7.70678H4.6079" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"/><path d="M9.39685 9.80371H9.40185" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"/><path d="M7.00232 9.80371H7.00732" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"/><path d="M4.60291 9.80371H4.6079" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"/><path d="M9.18255 1.60425V3.37991" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"/><path d="M4.82318 1.60425V3.37991" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"/><path fill-rule="evenodd" clip-rule="evenodd" d="M11.8571 2.4563H2.14453V12.3959H11.8571V2.4563Z" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"/></svg>';
		echo '<span><a href="' . esc_url($time_string) . '">' . get_the_date('d M Y') . '</a></span>'; ?>
	</div>
</div>