<?php

/**
 * Template part for displaying a post's featured image
 *
 * @package streamit
 */

namespace Streamit\Utility;

//author details
$author_id = get_the_author_meta('ID');
$author_image = get_the_author_meta('streamit_profile_image', $author_id);
if (empty($author_image)) {
	$author_image = get_avatar_url($author_id);
}

$author_name = get_the_author_meta('display_name', $author_id);
$author_url = get_author_posts_url($author_id);
$author_bio = get_the_author_meta('description', $author_id);

//post tags
$post_tags = get_the_tags();
if ($post_tags) {
	$post_tag_list = '<ul class="iq-blog-tag">';
	$post_tag_list .= '<i class="fas fa-tags" aria-hidden="true"></i><span>' . esc_html__("TAGS:", "streamit") . '</span>';
	foreach ($post_tags as $post_tag) {
		$post_tag_list .= '<li><a href="' . get_tag_link($post_tag) . '">' . esc_html($post_tag->name) . '</a></li>';
	}
	$post_tag_list .= '</ul>';
} else {
	$post_tag_list =  '';
}

echo wp_kses($post_tag_list, $args['allowed_html']); ?>

<div class="iq-author-meta-details">
	<div class="iq-author-image">
		<img src="<?php echo esc_url($author_image) ?>" class="img-fluid avatar" alt="user">
	</div>

	<div class="iq-author-details">
		<div class="iq-author-name">
			<?php echo '<span><a href="' . esc_url($author_url) . '">' . esc_html($author_name) . '</a></span>'; ?>
		</div>

		<div class="iq-author-bio">
			<?php echo esc_html($author_bio); ?>
		</div>

		<?php get_template_part('template-parts/content_new/entry_author_social', get_post_type()); ?>
	</div>
</div>