<?php

/**
 * Template part for displaying a post's featured image
 *
 * @package streamit
 */

namespace Streamit\Utility;

if (class_exists('ReduxFramework')) {
	global $streamit_options;
	if (isset($streamit_options['streamit_display_comment']) && $streamit_options['streamit_display_comment'] == 'yes') {
		// Show comments only when the post type supports it and when comments are open or at least one comment exists.
		if (post_type_supports(get_post_type(), 'comments') && (comments_open() || get_comments_number())) {
			comments_template();
		}
	}
} else {
	// Show comments only when the post type supports it and when comments are open or at least one comment exists.
	if (post_type_supports(get_post_type(), 'comments') && (comments_open() || get_comments_number())) {
		comments_template();
	}
}
