<?php

/**
 * Template part for displaying a post's featured image
 *
 * @package streamit
 */

namespace Streamit\Utility;

// author social media links
$author_id = get_the_author_meta('ID');
$author_facebook_link = get_user_meta($author_id, 'facebook_url', true);
$author_instagram_link = get_user_meta($author_id, 'instagram_url', true);
$author_twitter_link = get_user_meta($author_id, 'twitter_url', true);
$author_dribble_link = get_user_meta($author_id, 'dribble_url', true);

$author_social_links = array(
	'facebook' => [
		'url' => $author_facebook_link,
		'class' => 'fab fa-facebook'
	],
	'instagram' => [
		'url' => $author_instagram_link,
		'class' => 'fab fa-instagram'
	],
	'twitter' => [
		'url' => $author_twitter_link,
		'class' => 'fab fa-twitter'
	],
	'dribble' => [
		'url' => $author_dribble_link,
		'class' => 'fab fa-dribbble'
	],
);

if ($author_social_links) : ?>
	<div class="iq-author-social-info">
		<ul class="info-share">
			<?php foreach ($author_social_links as $links) : ?>
				<li>
					<a target="_blank" href="<?php echo esc_url($links['url']); ?>">
						<i class="<?php echo esc_attr($links['class']); ?>"> </i>
					</a>
				</li>
			<?php endforeach; ?>
		</ul>
	</div>
<?php endif; ?>