<?php

/**
 * Template part for displaying a post's page
 *
 * @package streamit
 */

namespace Streamit\Utility;

global $streamit_options;

$post_id                    = get_the_ID();

$is_grid                    = true;
$is_badges_enable           = true;
$is_ajax_enable             = true;
$thumbnail_size             = "full";
$settings['image_style']    = "portrait";
$col                        = 'list-inline';
$post_type                  = get_post_type($post_id);
$settings['play_now_text']  = esc_html__("Play Now", "streamit");
$lazy_load                  = $is_ajax_enable ? " iqonic-lazy-load-images" : '';
$archive_cards_style        = isset($streamit_options['streamit_archive_cards_style']) && !empty($streamit_options['streamit_archive_cards_style']) ? $streamit_options['streamit_archive_cards_style'] : '1';
$grid_col                        = ($archive_cards_style == 2)  ? "col-lg-2 col-md-4 col-sm-6 wl-child" : "col-lg-3 col-md-4 col-sm-6 wl-child";

echo '<article id="post-' . esc_attr($post_id) . '" class="' . esc_attr($grid_col) . '">';

if ($archive_cards_style == 2) {
    if ($post_type == "movie")
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Cards/template.php';
    elseif ($post_type == "tv_show")
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Cards/template.php';
    elseif ($post_type == "video")
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Cards/template.php';
    else
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/General/Cards_General.php';
} else {
    if ($post_type == "movie")
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Slider/template.php';
    elseif ($post_type == "tv_show")
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Slider/template.php';
    elseif ($post_type == "video")
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Slider/template.php';
    else
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/General/Slider_General.php';
}

echo '</article>';
