<?php

/**
 * Template part for displaying a post's page
 *
 * @package streamit
 */

namespace Streamit\Utility;

global $streamit_options;

$is_ajax_enable      = true;
$post_id             = get_the_ID();
$post_type           = get_post_type($post_id);
$lazy_load           = $is_ajax_enable ? " iqonic-lazy-load-images" : '';
$isArticle           = isset($args['isArticle']) ? $args['isArticle'] : true;
$archive_cards_style = isset($streamit_options['streamit_archive_cards_style']) && !empty($streamit_options['streamit_archive_cards_style']) ? $streamit_options['streamit_archive_cards_style'] : '1';
$is_badges_enable    = isset($streamit_options['streamit_archive_enable_premium_badges']) && $streamit_options['streamit_archive_enable_premium_badges'] == "yes" ? true : false;
$show_title          = isset($streamit_options['streamit_archive_enable_title']) && $streamit_options['streamit_archive_enable_title'] == "yes" ? true : false;

$temp_col = ($archive_cards_style == "2") ? "col-xl-2 col-lg-4 col-md-4 col-sm-6 col-6 wl-child archive-media" : "col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6 wl-child archive-media";

if ($isArticle) {
    echo '<article id="post-' . esc_attr($post_id) . '" class="' . esc_attr($temp_col) . '">';
} else {
    echo '<li class="slide-item">';
}

$is_grid                    = true;
$thumbnail_size             = "full";
$settings['image_style']    = "portrait";
$col                        = 'list-inline';
$settings['play_now_text']  = esc_html__("Play Now", "streamit");

if ($archive_cards_style == 2) {
    if ($post_type == "movie")
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Cards/template.php';
    elseif ($post_type == "tv_show")
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Cards/template.php';
    elseif ($post_type == "video")
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Cards/template.php';
} else {
    if ($post_type == "movie")
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Slider/template.php';
    elseif ($post_type == "tv_show")
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Slider/template.php';
    elseif ($post_type == "video")
        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Slider/template.php';
}

if ($isArticle) {
    echo '</article>';
} else {
    echo '</li>';
}
