<?php

/**
 * Template part for displaying a post
 *
 * @package streamit
 */

namespace Streamit\Utility; ?>

<div class="blog-navigation">
	<?php
	$next_post = get_adjacent_post(false, '', false);
	$prev_post = get_adjacent_post(false, '', true);

	if (!empty($prev_post)) { ?>
		<div class="previous-post">
			<a href="<?php echo esc_url(get_permalink($prev_post->ID)); ?>" title="<?php echo esc_attr($prev_post->post_title); ?>">
				<div class="blog-arrow">
					<span class="arrow-wrapper">
						<i class="fas fa-arrow-left"></i>
						<span class="previous"> <?php echo esc_html_e('Previous Post', 'streamit') ?></span>
					</span>
				</div>
				<span class="blog-title"><?php echo esc_html($prev_post->post_title); ?> </span>
			</a>
		</div>
	<?php
	}
	
	if (!empty($next_post)) { ?>
		<div class="next-post">
			<a href="<?php echo esc_url(get_permalink($next_post->ID)); ?>" title="<?php echo esc_attr($next_post->post_title); ?>">
				<div class="blog-arrow">
					<span class="arrow-wrapper">
						<span class="next"><?php echo esc_html_e('Next Post', 'streamit') ?></span>
						<i class="fas fa-arrow-right"></i>
					</span>
				</div>
				<span class="blog-title"><?php echo esc_html($next_post->post_title); ?></span>
			</a>
		</div>
	<?php } ?>
</div>