<?php

/**
 * Template part for displaying the Breadcrumb 
 *
 * @package streamit
 */

namespace Streamit\Utility;

use Streamit\Utility\Dynamic_Style\Styles\Breadcrumb;

$is_breadcrumb = true;

if (is_front_page() && is_home()) { ?>
    <div class="iq-breadcrumb-one">
        <div class="container-fluid">
            <div class="row align-items-center justify-content-center text-center">
                <div class="col-sm-12">
                    <h1 class="title"><?php esc_html_e('Home', 'streamit'); ?></h1>
                </div>
            </div>
        </div>
    </div>
<?php } else {
    if (class_exists("ReduxFramework")) {
        $breadcrumb     = new Breadcrumb();
        $is_breadcrumb  = $breadcrumb->is_streamit_breadcrumb();
    }

    if ($is_breadcrumb) streamit()->streamit_breadcrumb();
}
