<?php

namespace Streamit\Utility;

defined('ABSPATH') || exit;

global $streamit_options;

get_header();

if (function_exists('set_post_view')) set_post_view();

$post_id             = get_the_ID();
$run_time            = get_post_meta($post_id, '_video_run_time', true);
$video_screenshot_id = get_post_meta($post_id, '_video_image_gallery', true);
$play_btn_text       = isset($streamit_options['streamit_play_btn_text']) && !empty($streamit_options['streamit_play_btn_text']) ? $streamit_options['streamit_play_btn_text'] : 'Play Now';
$dislay_rating       = isset($streamit_options['streamit_video_display_rating']) && $streamit_options['streamit_video_display_rating'] == 'yes' ? true : false;

?>

<div id="primary" class="content-area">
   <main id="main" class="site-main">
      <div class="main-content movi pt-0">

         <?php if (!is_page_template('streamit-full-width.php')) echo '<div class="container-fluid">'; ?>

         <div class="row">
            <div class="col-lg-12">
               <div class="video-container iq-main-slider">
                  <?php while (have_posts()) : the_post();
                     if (isset($streamit_options['streamit_restriction_priority']) && $streamit_options['streamit_restriction_priority'] == "pms") {
                        remove_filter('the_content', 'pmpro_membership_content_filter', 15);
                        if (function_exists('pms_is_post_restricted') && pms_is_post_restricted($post_id))
                           echo the_content();
                     }

                     streamit()->get_masvideo_content('content', 'single-' . get_post_type());
                  endwhile; ?>
               </div>

               <div class="trending-info mt-4 pt-0 pb-4 mt-0">
                  <div class="row">
                     <div class="col-md-9 col-12 mb-auto">
                        <h3 class="trending-text big-title text-uppercase mt-0"><?php the_title(); ?></h3>

                        <?php streamit()->streamit_display_genre($post_id, 'video_cat'); ?>

                        <div class="d-flex flex-wrap align-items-center text-detail flex-wrap mb-4 mt-3">

                           <?php streamit()->streamit_show_counter('badge badge-secondary p-1 mr-2 single-view-count'); ?>

                           <span class="span"><?php echo esc_html($run_time); ?></span>
                           <span class="trending-year"><?php echo get_the_date('M Y'); ?></span>
                        </div>

                        <?php
                        streamit()->streamit_get_icons_list($post_id);

                        streamit()->streamit_display_tags($post_id, 'video_tag'); ?>
                     </div>

                     <?php get_template_part('template-parts/global/trailer', 'button'); ?>
                  </div>
               </div>

               <div class="streamit-content-details trending-info g-border">
                  <?php $tab_uniqid = 'tab-' . uniqid(); ?>

                  <ul class="trending-pills-header d-flex nav nav-pills align-items-center text-center s-margin mb-3 mb-md-5" role="tablist">
                     <?php if (!empty(get_the_content())) { ?>
                        <li class="nav-item">
                           <a class="nav-link active show" data-toggle="pill" href="#<?php echo esc_attr($tab_uniqid); ?>description" role="tab" aria-selected="true"><?php echo esc_html__('Description', 'streamit'); ?></a>
                        </li>
                     <?php
                     }

                     if ($dislay_rating) { ?>
                        <li class="nav-item">
                           <a class="nav-link" data-toggle="pill" href="#<?php echo esc_attr($tab_uniqid); ?>comment" role="tab" aria-selected="false"><?php echo esc_html__('Comments', 'streamit'); ?></a>
                        </li>
                     <?php } ?>
                  </ul>

                  <div class="tab-content">
                     <?php if (!empty(get_the_content())) { ?>
                        <div id="<?php echo esc_attr($tab_uniqid); ?>description" class="tab-pane animated fadeIn active show" role="tabpanel">
                           <div class="description-content hideContent">
                              <?php streamit()->streamit_content_description(); ?>
                           </div>

                           <div class="show-more">
                              <a href="javascript:void(0);" data-showmore="<?php echo esc_attr__('More...', 'streamit'); ?>" data-showless="<?php echo esc_attr__('Less...', 'streamit'); ?>"><?php echo esc_html__('More...', 'streamit'); ?></a>
                           </div>
                        </div>
                     <?php }

                     if ($dislay_rating) { ?>
                        <div id="<?php echo esc_attr($tab_uniqid); ?>comment" class="tab-pane animated fadeIn" role="tabpanel">
                           <?php if (comments_open() || get_comments_number()) :
                              comments_template();
                           endif; ?>
                        </div>
                     <?php } ?>
                  </div>
               </div>
            </div>
         </div>
         <?php if (!is_page_template('streamit-full-width.php')) echo '</div>'; ?>
      </div>

      <?php
      // ====================================SCREEN SHOT=========================

      if (!empty($video_screenshot_id)) :
         echo streamit()->streamit_gallery($video_screenshot_id);
      endif;

      //==========================UPCOMING VIDEOS=====================
      streamit()->streamit_display_upcoming('video'); ?>

      <div class="container-fluid">
         <?php
         //==========================RELEATED PRODUCTS=====================
         streamit()->streamit_related_product(
            get_queried_object_id(),
            $streamit_options['streamit_display_related_product'],
            $streamit_options['streamit_display_related_product_title'],
            $streamit_options['streamit_show_related']
         ); // Function Call To Get Select Related Product 
         ?>
      </div>
   </main>
</div>

<?php
streamit()->streamit_more_content_js();
get_footer();
