<?php

/**
 * The Template for displaying all single tv shows
 *
 * This template can be overridden by copying it to yourtheme/masvideos/single-tv-show.php.
 *
 * HOWEVER, on occasion MasVideos will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @package MasVideos/Templates
 * @version 1.0.0
 */

namespace Streamit\Utility;

defined('ABSPATH') || exit;

get_header();

global $streamit_options;

if (function_exists('set_post_view')) set_post_view();

$get_latest_ep                   = '#';
$post_id                         = get_the_ID();
$recommended_tv_show_person_ids  = get_post_meta($post_id, '_cast');
$season_data                     = get_post_meta($post_id, '_seasons');
$recommended_person_cast_ids     = !empty($recommended_tv_show_person_ids) ? $recommended_tv_show_person_ids[0] : null;

if (isset($season_data[0]) && !empty($season_data[0])) {
   $season_count = count($season_data[0]) - 1;

   $tv_show_episode_order = apply_filters('streamit_tv_show_episode_order', 'ASC');

   if (empty($season_data[0][$season_count]['episodes']))
      $season_count--;

   $season_count = $tv_show_episode_order == 'ASC' ? $season_count : 0;

   $args = array(
      'post_type'       => 'episode',
      'post_status'     => 'publish',
      'post__in'        => $season_data[0][$season_count]['episodes'],
      'meta_key'        => '_episode_number',
      'orderby'         => 'meta_value_num',
      'order'           => 'DESC',
      'posts_per_page'  => 1,
   );

   $latest_post   = get_posts($args);
   $get_latest_ep = get_permalink($latest_post[0] ?? false);
} ?>

<div id="primary" class="content-area">
   <main id="main" class="site-main">

      <?php if (!is_page_template('streamit-full-width.php')) echo '<div class="container-fluid">'; ?>

      <div class="banner-wrapper overlay-wrapper iq-main-slider streamit-go-back" style="background:url('<?php echo get_the_post_thumbnail_url(); ?>')">
         <?php streamit()->streamit_go_back_button(); ?>
         <div class="banner-caption">
            <div class="movie-detail">
               <div class="row">
                  <div class="col-lg-12">
                     <div class="trending-info">
                        <h1 class="trending-text big-title text-uppercase mt-0"><?php the_title(); ?></h1>

                        <?php
                        streamit()->streamit_display_imdb_rating($post_id);

                        streamit()->streamit_display_genre($post_id, 'tv_show_genre'); ?>

                        <div class="d-flex flex-wrap align-items-center text-detail">
                           <span class="seasons-count">
                              <?php if (isset($season_data[0]) && !empty($season_data[0])) {
                                 echo esc_html(count($season_data[0]));
                                 if (count($season_data[0]) <= 1)
                                    echo esc_html__(' Season', 'streamit');
                                 else
                                    echo esc_html__(' Seasons', 'streamit');
                              } else {
                                 echo '<span class="no-season">';
                                 echo esc_html__('No seasons released yet', 'streamit');
                                 echo '</span>';
                              } ?>
                           </span>
                           <span class="trending-year"><?php echo get_the_date('M Y') ?></span>
                        </div>

                        <div class="trending-dec">
                           <?php the_excerpt(); ?>
                        </div>
                     </div>
                  </div>
               </div>
            </div>

            <div class="position-relative">
               <?php if ($get_latest_ep != '#') { ?>
                  <a href="<?php echo esc_url($get_latest_ep) ?>" class="d-flex align-items-center">
                     <div class="play-button">
                        <i class="fas fa-play"></i>
                     </div>
                     <h4 class="w-name font-weight-700"><?php echo esc_html__('Watch latest Episode', 'streamit') ?></h4>
                  </a>
               <?php } ?>
            </div>

            <div class="row">
               <div class="col-12 mt-auto mb-auto">
                  <?php
                  streamit()->streamit_get_icons_list($post_id);

                  streamit()->streamit_display_tags($post_id, 'tv_show_tag'); ?>
               </div>
            </div>
         </div>

         <?php get_template_part('template-parts/global/trailer', 'button'); ?>
      </div>

      <div class="main-content bottom-space height-100">
         <div class="seasons">
            <?php if (isset($season_data[0]) && !empty($season_data[0])) { ?>
               <div class="iq-custom-select d-inline-block sea-epi s-margin">
                  <select name="cars" class="form-control season-select iq-single">
                     <?php
                     foreach ($season_data[0] as $index => $val) {
                        if (empty($val['episodes'])) continue; ?>
                        <option value="episode-season-<?php echo esc_attr($index); ?>" <?php echo  isset($_GET['season']) && $index == $_GET['season'] - 1 ? esc_attr('selected') : ''   ?>><?php echo esc_html($val['name'], 'streamit'); ?></option>
                     <?php } ?>
                  </select>
               </div>
            <?php } ?>

            <ul class="trending-pills d-flex nav nav-pills align-items-center text-center s-margin" role="tablist">
               <?php if (isset($season_data[0]) && !empty($season_data[0])) { ?>
                  <li class="nav-item">
                     <a class="nav-link" data-toggle="pill" href="#episodes" role="tab" aria-selected="true">
                        <?php echo esc_html__('Episodes', 'streamit'); ?>
                     </a>
                  </li>

                  <?php foreach ($season_data[0] as $index => $val) {
                     foreach ($val['episodes'] as $epdata) {
                        $_featured = get_post_meta($epdata, '__featured', true);
                        if ($_featured == 'yes') {
                           $episode_featured = $_featured;
                        }
                     }
                  }

                  if (isset($episode_featured) && $episode_featured) { ?>
                     <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#featured" role="tab" aria-selected="false">
                           <?php echo esc_html__('Featured Clips', 'streamit'); ?>
                        </a>
                     </li>
                  <?php }
               }

               if (!empty(get_the_content())) { ?>
                  <li class="nav-item">
                     <a class="nav-link" data-toggle="pill" href="#desc" role="tab" aria-selected="false">
                        <?php echo esc_html__('Description', 'streamit'); ?>
                     </a>
                  </li>
               <?php }

               if (isset($streamit_options['streamit_tvshow_display_rating']) && $streamit_options['streamit_tvshow_display_rating'] == 'yes') { ?>
                  <li class="nav-item">
                     <a class="nav-link" data-toggle="pill" href="#review" role="tab" aria-selected="false">
                        <?php echo esc_html__('Rate & Review', 'streamit'); ?>
                     </a>
                  </li>
               <?php } ?>
            </ul>

            <div class="tab-content tv-show-bottom-space">
               <?php if (isset($season_data[0]) && !empty($season_data[0])) { ?>
                  <div id="episodes" class="tab-pane fade active show" role="tabpanel">
                     <div class="block-space">
                        <div class="row">
                           <div class="tab-content tv-show-bottom-space">
                              <?php
                              foreach ($season_data[0] as $index => $val) {
                                 if (isset($_GET['season'])) {
                                    $season_current_page = $_GET['season'] == $index + 1;
                                 } else {
                                    $season_current_page = $index == 0;
                                 }
                                 $args = array(
                                    'post_type'       => 'episode',
                                    'post_status'     => 'publish',
                                    'posts_per_page'  => $streamit_options['streamit_episode_per_page'] ?? 12,
                                    'post__in'        => $val['episodes'],
                                    'paged'           => ($season_current_page && get_query_var('paged')) ? get_query_var('paged') : 1,
                                    'order'           => 'ASC',
                                    'orderby'         => 'post__in'
                                 );

                                 $episode_query = new \WP_Query($args); ?>

                                 <div data-season="episode-season-<?php echo esc_attr($index) ?>" class="tab-pane fade streamit_seasons_episode_tab animated fadeIn <?php echo $season_current_page ? ' active show' : '' ?>" role="tabpanel">
                                    <div class="row m-0">
                                       <?php
                                       while ($episode_query->have_posts()) {
                                          $episode_query->the_post();
                                          get_template_part('template-parts/global/episode', '', array('season' => $season_current_page));
                                       } ?>
                                    </div>

                                    <?php
                                    if (isset($streamit_options['streamit_display_pagination'])) {
                                       $options = $streamit_options['streamit_display_pagination'];
                                       if ($options == "load_more") {
                                          if ($episode_query->max_num_pages > 1)
                                             echo '<a class="ml-3 streamit_loadmore_btn_episode btn btn-hover iq-button" data-loadmore-page-no="1" data-max-number-page="' . $page . '" data-episode-query-args=\'' . json_encode($args) . '\' tabindex="0" data-loading-text="' . $streamit_options['streamit_display_blog_loadmore_text_2'] . '"><span>' . $streamit_options['streamit_display_blog_loadmore_text'] . '</span></a>';
                                       } else {
                                          get_template_part('template-parts/content/pagination', '', array('wp_query' => $episode_query, 'add_args' => array('season' => $index + 1)));
                                       }
                                    } else {
                                       get_template_part('template-parts/content/pagination', '', array('wp_query' => $episode_query, 'add_args' => array('season' => $index + 1)));
                                    } ?>
                                 </div>
                              <?php
                                 wp_reset_postdata();
                              } ?>
                           </div>
                        </div>
                     </div>
                  </div>

                  <?php if (isset($episode_featured) && $episode_featured) { ?>
                     <div id="featured" class="tab-pane fade" role="tabpanel">
                        <div class="block-space">
                           <div class="row">
                              <div class="tab-content tv-show-bottom-space">
                                 <?php foreach ($season_data[0] as $key => $val) {
                                    if (empty($val)) continue;

                                    if (isset($_GET['season'])) {
                                       $season_current_page = $_GET['season'] == $key + 1;
                                    } else {
                                       $season_current_page = $key == 0;
                                    }

                                    $args = array(
                                       'post_type'    => 'episode',
                                       'post_status'  => 'publish',
                                       'post__in'     => $val['episodes'],
                                       'meta_key'     => '__featured',
                                       'meta_value'   => 'yes',
                                       'orderby'      => 'meta_value_num',
                                       'order'        => 'ASC'
                                    );
                                    $episode_query = new \WP_Query($args); ?>

                                    <div data-season="episode-season-<?php echo esc_attr($key) ?>" class="tab-pane fade streamit_seasons_episode_tab animated fadeIn <?php echo $season_current_page ? ' active show' : '' ?>" role="tabpanel">
                                       <div class="row m-0">
                                          <?php
                                          while ($episode_query->have_posts()) {
                                             $episode_query->the_post();
                                             get_template_part('template-parts/global/episode', '', array('season' => $season_current_page));
                                          } ?>
                                       </div>

                                       <?php
                                       wp_reset_postdata(); ?>
                                    </div>
                                 <?php } ?>
                              </div>
                           </div>
                        </div>
                     </div>
                  <?php } ?>
               <?php } ?>

               <?php if (!empty(get_the_content())) { ?>
                  <div id="desc" class="tab-pane fade " role="tabpanel">
                     <div class="block-space">
                        <div class="row">
                           <div class="col-12 iq-mb-30 animated fadeIn">
                              <?php echo get_the_content(); ?>
                           </div>
                        </div>
                     </div>
                  </div>
               <?php } ?>

               <?php if (isset($streamit_options['streamit_tvshow_display_rating']) && $streamit_options['streamit_tvshow_display_rating'] == 'yes') { ?>
                  <div id="review" class="tab-pane animated fadeIn" role="tabpanel">
                     <div class="iq_comment_block streamit-content-details">
                        <div class="iq-main-header d-flex align-items-center justify-content-between iq-ltr-direction">
                           <h4 class="main-title"> <?php echo esc_html__('Rate & Review', 'streamit'); ?></h4>
                        </div>
                        <?php
                        if (comments_open() || get_comments_number()) :
                           comments_template();
                        endif; ?>
                     </div>
                  </div>
               <?php
               } ?>
            </div>
         </div>
      </div>

      <?php if (isset($streamit_options['streamit_display_cast']) && $streamit_options['streamit_display_cast'] == 'yes') {
         streamit()->streamit_cast_and_crew('');
      }

      streamit()->streamit_related_product(
         get_queried_object_id(),
         $streamit_options['streamit_display_related_product'],
         $streamit_options['streamit_display_related_product_title'],
         $streamit_options['streamit_show_related']
      ); // Function Call To Get Select Related Product
      if (!is_page_template('streamit-full-width.php')) echo '</div>'; ?>
   </main>
</div>

<?php get_footer();
