<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage streamit
 * @since 1.0
 * @version 1.0
 */

get_header();

global $streamit_options;

$recommended_person_cast_ids  = [];
$cast_id                      = get_the_ID();
$meta                         = get_post_meta($cast_id);

$recommended_movie_cast_ids   = get_post_meta($cast_id, '_movie_cast', true);
$recommended_tv_show_cast_ids = get_post_meta($cast_id, '_tv_show_cast', true);

$format                       =  get_option('date_format');

$birthday                     = !empty($meta['_birthday'][0]) ? $meta['_birthday'][0] : false;
$birthday                     = ($birthday) ? wp_date($format, $birthday) : false;

$deathday                     = !empty($meta['_deathday'][0]) ? $meta['_deathday'][0] : false;
$deathday                     = ($deathday) ? wp_date($format, $deathday) : false;

$birth_place                  = !empty($meta['_place_of_birth'][0]) ? $meta['_place_of_birth'][0] : false;

$genres                       = wp_get_post_terms($cast_id, 'person_cat');
$genres                       = streamit_get_tags($genres);

if (!empty($recommended_movie_cast_ids))
   $recommended_person_cast_ids = array_merge($recommended_person_cast_ids, $recommended_movie_cast_ids);

if (!empty($recommended_tv_show_cast_ids))
   $recommended_person_cast_ids = array_merge($recommended_person_cast_ids, $recommended_tv_show_cast_ids);

$streamit_display_social_icons = isset($streamit_options['streamit_display_social_icons']) && $streamit_options['streamit_display_social_icons'] == 'yes';
$show_most_view                = isset($streamit_options['streamit_show_cast_most_viewer']) && $streamit_options['streamit_show_cast_most_viewer'] == 'yes';
$is_infinite_scroll            = isset($streamit_options['streamit_cast_use_infinite_scroll']) && ($streamit_options['streamit_cast_use_infinite_scroll'] == "infinite_scroll") ? 'infinite_scroll' : 'no';

$awards                       = get_post_meta($cast_id, 'cast_awards', true);
$height                       = get_post_meta($cast_id, 'cast_height', true);
$relatives                    = get_post_meta($cast_id, 'cast_relatives', true);
$official_sites               = get_post_meta($cast_id, 'cast_official_site', true);

$paged = (get_query_var('paged')) ? get_query_var('paged') : 1; ?>

<div id="primary" class="content-area">
   <main id="main" class="site-main">
      <div class="main-content movi pt-md-0 pt-3">
         <div class="container-fluid">
            <div class="row">
               <div class="col-lg-12">
                  <div class="video-container iq-main-slider">
                     <?php while (have_posts()) : the_post();
                        masvideos_get_template_part('content', 'single-person');
                     endwhile; ?>
                  </div>

                  <div class="cast-detail-main-content">
                     <div class="row">
                        <div class="col-md-3 col-12">
                           <div class="streamit_person-featured-image position-relative">
                              <?php if (has_post_thumbnail()) the_post_thumbnail(); ?>

                              <?php if ($streamit_display_social_icons) { ?>
                                 <div class="iqonic-shape-circle">
                                    <div class="streamit-socials-share streamit-social-icons d-flex">
                                       <div class="streamit-social-item">
                                          <a href="https://www.facebook.com/sharer?u=<?php the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico mr-2 streamit-share"><i class="fab fa-facebook-f"></i></a>
                                       </div>
                                       <div class="streamit-social-item">
                                          <a href="http://twitter.com/intent/tweet?text=<?php the_title(); ?>&url=<?php echo get_the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico mr-2 streamit-share"><i class="fab fa-twitter"></i></a>
                                       </div>
                                       <div class="streamit-social-item">
                                          <a href="#" data-link='<?php the_permalink(); ?>' class="share-ico iq-copy-link mr-2 streamit-share"><i class="fas fa-link"></i></a>
                                       </div>
                                    </div>
                                 </div>
                              <?php } ?>
                           </div>

                           <div class="person-details">
                              <div class="align-items-center trending-list flex-wrap">
                                 <h5 class="trending-text text-capitalize mt-3 mb-3 fw-500">
                                    <?php echo esc_html__('Personal Details', STREAMIT_TEXT_DOMAIN); ?>
                                 </h5>
                              </div>

                              <?php if (!empty($official_sites)) : ?>
                                 <h5 class="font-size-18 fw-500 text-white p-title">
                                    <?php echo esc_html__("Official sites", STREAMIT_TEXT_DOMAIN); ?> :
                                 </h5>
                                 <p class="mt-0 mb-4">
                                    <?php echo '<a href="'.esc_url($official_sites).'" target="_blank">'.esc_html($official_sites).' </a>'; ?>
                                 </p>
                              <?php endif; ?>


                              <h6 class="font-size-18 fw-500 text-white p-title"> <?php echo esc_html__("Born", STREAMIT_TEXT_DOMAIN); ?> : </h6>
                              <div class="seperator d-flex align-items-center mb-4">
                                 <?php if ($birthday) { ?>
                                    <span class="d-inline-block">
                                       <?php echo esc_html($birthday); ?>
                                    </span>
                                 <?php } ?>
                                 <?php if ($birth_place) { ?>
                                    <span class="d-inline-block">
                                       <?php echo esc_html($birth_place); ?>
                                    </span>
                                 <?php } ?>
                              </div>

                              <?php if ($deathday) { ?>
                                 <div class="death-info">
                                    <h6 class="font-size-18 fw-500 text-white p-title"> <?php echo esc_html__("Death", STREAMIT_TEXT_DOMAIN); ?> : </h6>
                                    <span class="death mb-4">
                                       <?php echo esc_html($deathday); ?>
                                    </span>
                                 </div>
                              <?php } ?>

                              <?php if (!empty($height)) { ?>
                                 <h6 class="font-size-18 fw-500 text-white p-title">
                                    <?php echo esc_html__("Height", STREAMIT_TEXT_DOMAIN); ?> :
                                 </h6>
                                 <p class=" mt-0 mb-4">
                                    <?php echo esc_html($height); ?>
                                 </p>
                              <?php } ?>

                              <?php if (!empty($relatives)) { ?>
                                 <h6 class="font-size-18 fw-500 text-white p-title">
                                    <?php echo esc_html__("Parents & Relatives", STREAMIT_TEXT_DOMAIN); ?> :
                                 </h6>
                                 <span class="mb-4">
                                    <?php echo esc_html($relatives); ?>
                                 </span>
                              <?php } ?>
                           </div>
                        </div>

                        <div class="col-md-9 col-12 mb-auto">
                           <h4 class="trending-text text-capitalize fw-500"><?php the_title(); ?></h4>

                           <div class="genres-list">
                              <?php echo sprintf("%s", __($genres)); ?>
                           </div>
                           <div class="trending-dec w-100 movie-top-space trending-info g-border mt-0">
                              <?php if (!empty(get_the_content())) the_content(); ?>
                              <?php if (!empty($awards)) { ?>
                                 <h5 class="mt-4 pt-3 fw-500">
                                    <?php echo esc_html__("Awards", STREAMIT_TEXT_DOMAIN); ?>
                                 </h5>
                                 <p class="fw-500 text-uppercase mt-3">
                                    <?php echo esc_html($awards); ?>
                                 </p>
                              <?php } ?>
                           </div>

                           <?php
                           //===================MOST VIEWED MOVIES/TVSHOWS===========================
                           if ($show_most_view) { ?>
                              <div id="iq-episode-most-viewed" class="iq-favorites s-margin">
                                 <div class="row m-0">
                                    <div class="col-sm-12 overflow-hidden p-0">
                                       <div class="iq-main-header d-flex align-items-center justify-content-between iq-ltr-direction my-4">
                                          <h5 class="main-title fw-500">
                                             <?php echo (!empty($streamit_options['streamit_cast_most_viewer'])) ? esc_html($streamit_options['streamit_cast_most_viewer']) : esc_html__('Known For', STREAMIT_TEXT_DOMAIN); ?>
                                          </h5>
                                       </div>

                                       <div class="favorites-contens iq-smovie-slider iq-card-wrapper">
                                          <ul class="inner-slider list-inline row p-0 mb-0">
                                             <?php $args = array(
                                                'post_type'      => array('movie', 'tv_show'),
                                                'post_status'    => 'publish',
                                                'post__in'       => $recommended_person_cast_ids,
                                                'orderby'        => 'meta_value_num',
                                                'order'          => 'DESC',
                                                'posts_per_page' => 10,
                                                'meta_query'     => array(
                                                   'relation'    => 'AND',
                                                   array(
                                                      'relation' => 'OR',
                                                      array(
                                                         'key'   => 'post_views_count',
                                                      ),
                                                      array(
                                                         'key'   => 'tv_show_views_count',
                                                      )
                                                   ),
                                                )
                                             );

                                             $wp_query_ = new \WP_Query($args);
                                             if ($wp_query_->have_posts()) {
                                                $col = '';
                                                $is_badges_enable = true;
                                                $is_ajax_enable = false;
                                                $settings['image_style'] = 'portrait';

                                                wp_enqueue_style("cards-general", STREAMIT_EXTENSION_PLUGIN_URL . "includes/Elementor/assets/css/cards-general.css", [], STREAMIT_EXTENSION_VERSION, "all");

                                                while ($wp_query_->have_posts()) {
                                                   $wp_query_->the_post();

                                                   $post_id = get_the_ID();
                                                   $post_type = get_post_type($post_id);

                                                   if ("movie" == $post_type) {
                                                      require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Cards/template.php';
                                                      continue;
                                                   } else if ("tv_show" == $post_type) {
                                                      require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Cards/template.php';
                                                      continue;
                                                   }
                                                }
                                             }
                                             wp_reset_postdata(); ?>
                                          </ul>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                           <?php } ?>

                           <div class="cast-details">
                              <div class="iq-main-header d-flex align-items-center justify-content-between iq-ltr-direction">
                                 <h5 class="fw-500">
                                    <?php if (!empty($streamit_options['streamit_cast_related_post_title'])) {
                                       echo esc_html($streamit_options['streamit_cast_related_post_title']);
                                    } else {
                                       echo esc_html__('Known For', STREAMIT_TEXT_DOMAIN);
                                    } ?>
                                 </h5>
                              </div>

                              <ul class="trending-pills treading-heading-tab d-flex nav nav-pills align-items-center text-center s-margin mb-3" role="tablist">
                                 <?php if (!empty($recommended_person_cast_ids)) { ?>
                                    <li class="nav-item">
                                       <a class="nav-link active show" data-toggle="pill" href="#all" role="tab" aria-selected="true"><?php echo esc_html__('All', 'streamit'); ?></a>
                                    </li>
                                 <?php } ?>

                                 <?php
                                 if (isset($recommended_movie_cast_ids) && !empty($recommended_movie_cast_ids)) { ?>
                                    <li class="nav-item">
                                       <a class="nav-link" data-toggle="pill" href="#movie" role="tab" aria-selected="false"><?php echo esc_html__('Movies', 'streamit'); ?></a>
                                    </li>
                                 <?php }

                                 if (isset($recommended_tv_show_cast_ids) && !empty($recommended_tv_show_cast_ids)) { ?>
                                    <li class="nav-item">
                                       <a class="nav-link" data-toggle="pill" href="#tv_show" role="tab" aria-selected="false"><?php echo esc_html__('Tv Shows', 'streamit'); ?></a>
                                    </li>
                                 <?php } ?>
                              </ul>

                              <div class="tab-content cast-person-list" id="cast-person-list">
                                 <div id="all" class="tab-pane fade active show streamit_cast_list" role="tabpanel" data-current-page="1" data-attibute="all" data-options="<?php echo esc_attr($is_infinite_scroll); ?>">
                                    <table class="credit_group animated fadeIn">
                                       <tbody class="cast-related-list">
                                          <?php
                                          if (!empty($recommended_person_cast_ids)) {
                                             $counter = 1;
                                             $args_all = array(
                                                'post_type'         => array('movie', 'tv_show'),
                                                'post_status'       => 'publish',
                                                'post__in'          => $recommended_person_cast_ids,
                                                'order'             => 'ASC',
                                                'posts_per_page'    => 10,
                                                'paged'             => $paged,
                                                'suppress_filters'  => 0
                                             );

                                             $wp_query = new \WP_Query($args_all);

                                             if ($wp_query->have_posts()) {
                                                while ($wp_query->have_posts()) {
                                                   $wp_query->the_post();

                                                   $r_movie_obj = get_the_ID();
                                                   $meta = get_post_meta($r_movie_obj);
                                                   $movie_cast = get_post_meta($r_movie_obj, '_cast');
                                                   $m_cast = $movie_cast[0];

                                                   if (empty($m_cast) || !is_array($m_cast)) continue;

                                                   $found_key = array_search($cast_id, array_column($m_cast, 'id'));

                                                   if ('tv_show' == get_post_type()) {
                                                      $season_data = unserialize($meta['_seasons'][0]);
                                                      if (!empty($season_data)) {
                                                         $season_years = array_column($season_data, 'year');
                                                         $start = count($season_years) ? min($season_years) : '';
                                                         $end = count($season_years) ? max($season_years) : '';
                                                         $season_count = count($season_data);
                                                         if ($season_count == '1') {
                                                            $release_year = $start;
                                                         } else {
                                                            if (!empty($start) && !empty($end)) {
                                                               $release_year = $start . ' - ' . $end;
                                                            }
                                                         }
                                                         if (is_array($season_data)) {
                                                            $censor_rating = ' (' . count($season_data) . ' Seasons) ';
                                                         }
                                                      }
                                                   } else {
                                                      $_movie_release_date = get_post_meta($r_movie_obj, '_movie_release_date', true);
                                                      if (isset($_movie_release_date) && !empty($_movie_release_date)) {
                                                         $release_year = date('Y', $_movie_release_date);
                                                      } else {
                                                         $release_year = '';
                                                      }
                                                   }

                                                   $attachement_url = wp_get_attachment_image_src(get_post_thumbnail_id($r_movie_obj), 'thumbnail')[0];
                                                   if (isset($attachement_url) && !empty($attachement_url))
                                                      $attachement_url = $attachement_url;
                                                   else
                                                      $attachement_url = ''; ?>

                                                   <tr class="trending-pills">
                                                      <td class="image"><img src="<?php echo esc_url($attachement_url); ?>" class="img-fluid" alt="<?php esc_attr_e('streamit', 'streamit'); ?>"></td>
                                                      <td class="seperator"><?php echo esc_html($counter); ?></td>

                                                      <td class="content text-capitalize">
                                                         <a href="<?php the_permalink(); ?>">
                                                            <?php the_title(); ?>
                                                         </a>

                                                         <?php if (!empty($m_cast[$found_key]['character'])) { ?>
                                                            <span class="ml-1 group"> <?php esc_html_e('as', 'streamit'); ?>
                                                               <span class="character">
                                                                  <?php echo esc_html($m_cast[$found_key]['character']);
                                                                  if ('tv_show' == get_post_type()) {
                                                                     echo esc_html($censor_rating);
                                                                  } ?>
                                                               </span>
                                                            </span>
                                                         <?php } ?>
                                                      </td>

                                                      <td class="year">
                                                         <?php if (!empty($release_year)) {
                                                            echo esc_html($release_year);
                                                         } ?>
                                                      </td>
                                                   </tr>
                                          <?php
                                                   $counter++;
                                                }
                                             }
                                          }
                                          wp_reset_postdata(); ?>

                                       </tbody>
                                    </table>
                                 </div>

                                 <div id="movie" class="tab-pane fade streamit_cast_list" role="tabpanel" data-attibute="movie" data-current-page="1" data-options="<?php echo esc_attr($is_infinite_scroll); ?>">
                                    <table class="credit_group animated fadeIn">
                                       <?php
                                       $counter = 1;
                                       $args_all = array(
                                          'post_type' => 'movie',
                                          'post_status' => 'publish',
                                          'post__in' => $recommended_movie_cast_ids,
                                          'order'             => 'ASc',
                                          'posts_per_page'     => 10,
                                          'paged' => $paged,
                                          'suppress_filters'  => 0
                                       );
                                       $wp_query = new \WP_Query($args_all); ?>

                                       <tbody class="cast-related-list">
                                          <?php
                                          if ($wp_query->have_posts()) {
                                             while ($wp_query->have_posts()) {
                                                $wp_query->the_post();
                                                $r_movie_obj = get_the_ID();
                                                $movie_cast = get_post_meta($r_movie_obj, '_cast');
                                                $m_cast = $movie_cast[0];

                                                if (empty($m_cast) || !is_array($m_cast)) continue;

                                                $found_key = array_search($cast_id, array_column($m_cast, 'id'));
                                                $attachement_url = wp_get_attachment_image_src(get_post_thumbnail_id($r_movie_obj), 'thumbnail')[0];

                                                if (isset($attachement_url) && !empty($attachement_url))
                                                   $attachement_url = $attachement_url;
                                                else
                                                   $attachement_url = '';
                                                $url_link  = get_post_permalink($r_movie_obj);
                                                $year = get_post_meta($r_movie_obj, '_movie_release_date', true);
                                                if (!empty($year)) {
                                                   $year = date('Y', strtotime($year));
                                                } ?>
                                                <tr class="trending-pills">
                                                   <td class="image"><img src="<?php echo esc_url($attachement_url); ?>" class="img-fluid" alt="<?php esc_attr_e('streamit', 'streamit'); ?>"></td>
                                                   <td class="seperator"><?php echo esc_html($counter); ?></td>
                                                   <td class="content">
                                                      <a href="<?php the_permalink(); ?>">
                                                         <?php the_title(); ?>
                                                      </a>

                                                      <?php if (isset($m_cast[$found_key]['character'])) { ?>
                                                         <span class="ml-2 group"> <?php esc_html_e('as', 'streamit'); ?>
                                                            <span class="character">
                                                               <?php echo esc_html($m_cast[$found_key]['character']); ?></span>
                                                         </span>
                                                      <?php
                                                      }
                                                      ?>
                                                   </td>
                                                   <td class="year"><?php echo esc_html($year, 'streamit'); ?></td>
                                                </tr>
                                          <?php
                                                $counter++;
                                             }
                                          }
                                          wp_reset_postdata(); ?>
                                       </tbody>
                                    </table>

                                    <?php if ($is_infinite_scroll == 'infinite_scroll') {
                                       if ($wp_query->max_num_pages > 1) {
                                          echo '<div class="loader-wheel-container"></div>';
                                       }
                                    } ?>
                                 </div>

                                 <div id="tv_show" class="tab-pane fade streamit_cast_list" role="tabpanel" data-attibute="tv_show" data-current-page="1" data-options="<?php echo esc_attr($is_infinite_scroll); ?>">
                                    <table class="credit_group animated fadeIn">
                                       <tbody class="cast-related-list">
                                          <?php $counter = 1;

                                          $args_all = array(
                                             'post_type' => 'tv_show',
                                             'post_status' => 'publish',
                                             'post__in' => $recommended_tv_show_cast_ids,
                                             'order'             => 'ASc',
                                             'posts_per_page'     => 10,
                                             'paged' => $paged,
                                             'suppress_filters'  => 0
                                          );
                                          $wp_query = new \WP_Query($args_all);

                                          if ($wp_query->have_posts()) {
                                             while ($wp_query->have_posts()) {
                                                $wp_query->the_post();
                                                $r_movie_obj = get_the_ID();

                                                $meta = get_post_meta($r_movie_obj);
                                                $season_data = unserialize($meta['_seasons'][0]);
                                                $movie_cast = get_post_meta($r_movie_obj, '_cast');
                                                $m_cast = $movie_cast[0];

                                                if (empty($m_cast) || !is_array($m_cast)) continue;

                                                $found_key = array_search($cast_id, array_column($m_cast, 'id'));

                                                if (!empty($season_data)) {
                                                   $season_years = array_column($season_data, 'year');
                                                   $start = count($season_years) ? min($season_years) : '';
                                                   $end = count($season_years) ? max($season_years) : '';

                                                   $season_count = count($season_data);
                                                   if ($season_count == '1') {
                                                      $year = $start;
                                                   } else {
                                                      if (!empty($start) && !empty($end)) {
                                                         $year = $start . ' - ' . $end;
                                                      }
                                                   }

                                                   if (is_array($season_data)) {
                                                      $censor_rating = ' (' . count($season_data) . ' Seasons) ';
                                                   }
                                                }

                                                $attachement_url = wp_get_attachment_image_src(get_post_thumbnail_id($r_movie_obj), 'thumbnail')[0];
                                                if (isset($attachement_url) && !empty($attachement_url))
                                                   $attachement_url = $attachement_url;
                                                else
                                                   $attachement_url = ''; ?>

                                                <tr class="trending-pills">
                                                   <td class="image"><img src="<?php echo esc_url($attachement_url); ?>" class="img-fluid" alt="<?php esc_attr_e('streamit', 'streamit'); ?>"></td>
                                                   <td class="seperator"><?php echo esc_html($counter); ?></td>
                                                   <td class="content">
                                                      <a href="<?php the_permalink(); ?>">
                                                         <?php the_title(); ?>
                                                      </a>
                                                      <span class="ml-2 group"> <?php esc_html_e('as', 'streamit'); ?> <span class="character">
                                                            <?php echo esc_html($m_cast[$found_key]['character']);
                                                            echo esc_html($censor_rating); ?></span></span>
                                                   </td>
                                                   <td class="year"><?php echo esc_html($year); ?></td>
                                                </tr>
                                          <?php
                                                $counter++;
                                             }
                                          }
                                          wp_reset_postdata(); ?>
                                       </tbody>
                                    </table>

                                    <?php
                                    if ($is_infinite_scroll == 'infinite_scroll' && $wp_query->max_num_pages > 1) {
                                       echo '<div class="loader-wheel-container"></div>';
                                    } ?>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </main>
</div>

<?php get_footer();
