<?php

namespace Streamit\Utility;

/**
 * Template Name: Streamit Latest
 * Template Post Type: post
 *
 * This is the template that displays style 2 for blog detail pages.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress

 * @since 1.0
 * @version 1.0
 */

namespace Streamit\Utility;

get_header();

global $streamit_options;

$streamit_layout 	= '';
$is_sidebar 		= streamit()->is_primary_sidebar_active();
$post_section 		= streamit()->post_style();

if (isset($streamit_options['streamit_blog'])) $streamit_layout = $streamit_options['streamit_blog'];

if ($is_sidebar) {
	$class = "col-xl-8 col-sm-12 pr-lg-5";
} else if ($streamit_layout != '4' && $streamit_layout != '5') {
	$class = "col-lg-12 col-sm-12";
}

$allowed_html = array(
	'ul' => array(
		'class' => array(),
	),
	'span' => array(),
	'li' => array(),
	'i' => array(
		'class' => array(),
		'aria-hidden' => array(),
	),
	'a' => array(
		'href' => array()
	),
	'img' => array(
		'class' => array(),
		'src' => array(),
		'srcset' => array(),
		'width' => array(),
		'height' => array(),
		'loading' => array(),
		'decoding' => array(),
		'alt' => array(),
	),
); ?>

<div class="site-content-contain">
	<div id="content" class="site-content">
		<div id="primary" class="content-area">
			<main id="main" class="site-main">
				<div class="container">
					<div class="row streamit-blog-main-list <?php echo esc_attr($post_section['row_reverse']); ?>">
						<div class="<?php echo esc_attr($class); ?>">
							<?php if (have_posts()) {
								while (have_posts()) {
									the_post();

									if ($streamit_layout == '4' || $streamit_layout == '5') :
										echo '<div class="' . esc_attr($post_section['post']) . '">';
									endif; ?>

									<article id="post-<?php the_ID(); ?>" <?php post_class('entry'); ?>>
										<div class="iq-blog-box">
											<?php
											get_template_part('template-parts/content_new/entry_thumbnail', get_post_type());
											get_template_part('template-parts/content_new/entry_header', get_post_type(), ['allowed_html' => $allowed_html]); ?>
										</div>

										<?php
										echo '<div class="iq-entry-content">';
										get_template_part('template-parts/content/entry_content', get_post_type());
										echo '</div>';

										get_template_part('template-parts/content_new/entry_footer', get_post_type(), ['allowed_html' => $allowed_html]);

										get_template_part('template-parts/content/entry_adjacent');

										get_template_part('template-parts/content_new/entry_comment');
										?>
									</article>

							<?php
									if ($streamit_layout == '4' || $streamit_layout == '5') {
										echo '</div>';
									}
								}
							} else {
								get_template_part('template-parts/content/error');
							} ?>
						</div>
						<?php get_sidebar(); ?>
					</div>
				</div>
			</main><!-- #primary -->
		</div>
	</div>
</div>

<?php get_footer();
