<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage streamit
 * @since 1.0
 * @version 1.0
 */

namespace Streamit\Utility;

defined('ABSPATH') || exit;

get_header();

global $movie, $streamit_options;

if (function_exists('set_post_view')) {
   set_post_view();
}

$run_time = $url_link = $censor_rating = $award_img = $award_desc = $movie_year = '';

$current_post_id                 = get_the_ID();
$content                         = get_the_content();

$movie_run_time                  = get_post_meta($current_post_id, '_movie_run_time', true);
$movie_release_year              = get_post_meta($current_post_id, '_movie_release_date', true);
$movie_censor_rating             = get_post_meta($current_post_id, '_movie_censor_rating', true);
$movie_screenshot_id             = get_post_meta($current_post_id, '_movie_image_gallery', true);

$play_btn_text                   = isset($streamit_options['streamit_play_btn_text']) && !empty($streamit_options['streamit_play_btn_text']) ? $streamit_options['streamit_play_btn_text'] : 'Play Now';
$dislay_rating                   = isset($streamit_options['streamit_movie_display_rating']) && $streamit_options['streamit_movie_display_rating'] == 'yes' ? true : false;
$streamit_display_cast           = isset($streamit_options['streamit_display_cast']) && $streamit_options['streamit_display_cast'] == 'yes' ? true : false;

$recommended_movie_cards_style   = isset($streamit_options['streamit_recommended_movie_cards_style']) && !empty($streamit_options['streamit_recommended_movie_cards_style']) ? $streamit_options['streamit_recommended_movie_cards_style'] : '1';
$streamit_display_recommended    = isset($streamit_options['streamit_display_recommended']) && $streamit_options['streamit_display_recommended'] == 'yes' ? true : false;

$releated_movie_cards_style      = isset($streamit_options['streamit_releated_movie_cards_style']) && !empty($streamit_options['streamit_releated_movie_cards_style']) ? $streamit_options['streamit_releated_movie_cards_style'] : '1';
$streamit_display_related_movie  = isset($streamit_options['streamit_display_related_movie']) && $streamit_options['streamit_display_related_movie'] == 'yes' ? true : false;

$releated_video_cards_style      = isset($streamit_options['streamit_releated_video_cards_style']) && !empty($streamit_options['streamit_releated_video_cards_style']) ? $streamit_options['streamit_releated_video_cards_style'] : '1';
$streamit_display_related_video  = isset($streamit_options['streamit_display_related_video']) && $streamit_options['streamit_display_related_video'] == 'yes' ? true : false;

$is_restricted                   = streamit()->streamit_is_post_restricted($current_post_id);
$lazy_load                       = " iqonic-lazy-load-images";
$is_ajax_enable                  = true;

if (!empty($movie_release_year))
   $movie_year = date('M Y', $movie_release_year); ?>

<div id="primary" class="content-area">
   <main id="main" class="site-main">
      <div class="main-content movi pt-0">

         <?php if (!is_page_template('streamit-full-width.php')) echo '<div class="container-fluid">'; ?>

         <div class="row">
            <div class="col-lg-12">
               <div class="video-container iq-main-slider">
                  <?php while (have_posts()) : the_post();
                     streamit()->get_masvideo_content('content', 'single-movie');
                  endwhile; ?>
               </div>

               <div class="trending-info mt-4 pt-0 pb-4">
                  <div class="row">
                     <div class="col-md-9 col-12 mb-auto">
                        <div class="d-sm-flex single-details">
                           <h3 class="trending-text big-title text-uppercase mt-0"><?php the_title(); ?></h3>
                           <?php streamit()->streamit_display_imdb_rating($current_post_id); ?>
                        </div>

                        <?php streamit()->streamit_display_genre($current_post_id, 'movie_genre'); ?>

                        <div class="d-flex flex-wrap align-items-center text-detail mb-4">
                           <?php if (isset($movie_censor_rating) && !empty($movie_censor_rating)) : ?>
                              <span class="badge badge-secondary"><?php echo esc_html($movie_censor_rating); ?></span>
                           <?php endif;

                           if (isset($movie_run_time) && !empty($movie_run_time)) : ?>
                              <span><?php echo esc_html($movie_run_time); ?></span>
                           <?php endif;

                           if (isset($movie_year) && !empty($movie_year)) : ?>
                              <span class="trending-year"><?php echo esc_html($movie_year); ?></span>
                           <?php endif;

                           streamit()->streamit_show_counter(); ?>
                        </div>

                        <?php
                        streamit()->streamit_get_icons_list($current_post_id);

                        streamit()->streamit_display_tags($current_post_id, 'movie_tag'); ?>
                     </div>
                     <?php get_template_part('template-parts/global/trailer', 'button'); ?>
                  </div>
               </div>

               <div class="streamit-content-details trending-info g-border">
                  <?php $tab_uniqid = 'tab-' . uniqid(); ?>
                  <ul class="trending-pills-header d-flex nav nav-pills align-items-center text-center s-margin mb-3 mb-md-5 " role="tablist">

                     <?php if (!empty($content)) { ?>
                        <li class="nav-item">
                           <a class="nav-link active show" data-toggle="pill" href="#<?php echo esc_attr($tab_uniqid); ?>description" role="tab" aria-selected="true"><?php echo esc_html__('Description', 'streamit'); ?></a>
                        </li>
                     <?php }

                     if ($dislay_rating) { ?>
                        <li class="nav-item">
                           <a class="nav-link" data-toggle="pill" href="#<?php echo esc_attr($tab_uniqid); ?>review" role="tab" aria-selected="false"><?php echo esc_html__('Rate & Review', 'streamit'); ?></a>
                        </li>
                     <?php }

                     if (!$is_restricted && $movie->get_sources() || !$movie) { ?>
                        <li class="nav-item">
                           <a class="nav-link" data-toggle="pill" href="#<?php echo esc_attr($tab_uniqid); ?>sources" role="tab" aria-selected="false"><?php echo esc_html__('Sources', 'streamit'); ?></a>
                        </li>
                     <?php } ?>
                  </ul>

                  <div class="tab-content">
                     <?php if (!empty($content)) { ?>
                        <div id="<?php echo esc_attr($tab_uniqid); ?>description" class="tab-pane animated fadeIn active show" role="tabpanel">
                           <div class="description-content hideContent">
                              <?php streamit()->streamit_content_description(); ?>
                           </div>
                           <div class="show-more" style="display: none;">
                              <a href="javascript:void(0);" data-showmore="<?php echo esc_attr__('More...', 'streamit'); ?>" data-showless="<?php echo esc_attr__('Less...', 'streamit'); ?>"><?php echo esc_html__('More...', 'streamit'); ?></a>
                           </div>
                        </div>
                     <?php }

                     if ($dislay_rating) { ?>
                        <div id="<?php echo esc_attr($tab_uniqid); ?>review" class="tab-pane animated fadeIn" role="tabpanel">
                           <?php if (comments_open() || get_comments_number()) :
                              comments_template();
                           endif; ?>
                        </div>
                     <?php }

                     if (!$is_restricted && $movie->get_sources() || !$movie) { ?>
                        <div id="<?php echo esc_attr($tab_uniqid); ?>sources" class="tab-pane animated fadeIn" role="tabpanel">
                           <?php masvideos_get_template_part('single-movie-sources'); ?>
                        </div>
                     <?php } ?>
                  </div>
               </div>
            </div>
         </div>
         <?php if (!is_page_template('streamit-full-width.php')) echo '</div>'; ?>
      </div>

      <?php
      // ====================================SCREEN SHOT=========================
      if (!empty($movie_screenshot_id)) :
         echo streamit()->streamit_gallery($movie_screenshot_id);
      endif;

      //====================================CREW OR STARRING=========================
      if ($streamit_display_cast) {
         streamit()->streamit_cast_and_crew(!is_page_template('streamit-full-width.php') ? 'container-fluid' : '');
      }

      //==================================RECOMMENDED MOVIES======================================
      if ($streamit_display_recommended) {
         $recommended_movie_ids  = get_post_meta($current_post_id, '_recommended_movie_ids', true);
         $is_badges_enable       = isset($streamit_options['streamit_recommended_enable_premium_badges']) && $streamit_options['streamit_recommended_enable_premium_badges'] == "yes" ? true : false;
         $show_title             = isset($streamit_options['streamit_recommended_enable_title']) && $streamit_options['streamit_recommended_enable_title'] == "yes" ? true : false;

         if (!empty($recommended_movie_ids)) :
            $recommended_movies_args = array(
               'post_type'       => 'movie',
               'post__in'        => $recommended_movie_ids,
               'posts_per_page'  => -1,
               'orderby'         => 'post__in',
               'fields'          => 'ids'
            );

            $recommended_movies  = new \WP_Query($recommended_movies_args);
            $post_ids            = $recommended_movies->posts;

            if ($recommended_movies->have_posts()) {
               $direction_class = count($recommended_movie_ids) > 4 ? 'iq-rtl-direction' : '';

               if ($recommended_movie_cards_style == "2") {
                  wp_enqueue_style("cards-general", STREAMIT_EXTENSION_PLUGIN_URL . 'includes/Elementor/assets/css/cards-general.css');
                  $direction_class .= ' iq-card-wrapper';
               } ?>

               <div id="iq-recommended-movie" class="iq-favorites s-margin <?php echo esc_attr($lazy_load); ?>">

                  <?php if (!is_page_template('streamit-full-width.php')) echo '<div class="container-fluid">'; ?>

                  <div class="row m-0">
                     <div class="col-sm-12 overflow-hidden p-0">
                        <div class="iq-main-header d-flex align-items-center justify-content-between iq-ltr-direction">
                           <h4 class="main-title">
                              <?php if (!empty($streamit_options['streamit_recommended_title'])) {
                                 echo esc_attr($streamit_options['streamit_recommended_title'], 'streamit');
                              } else {
                                 echo esc_html__('Recommended', 'streamit');
                              } ?>
                           </h4>
                        </div>

                        <div class="favorites-contens iq-smovie-slider <?php echo esc_attr($direction_class) ?>">
                           <ul class="inner-slider list-inline row p-0 mb-0">
                              <?php $col                 = '';
                              $is_grid                   = false;
                              $settings['play_now_text'] = $play_btn_text;
                              $settings['image_style']   = "portrait";

                              foreach ($post_ids as $post_id) {
                                 if ($recommended_movie_cards_style == "2")
                                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Cards/template.php';
                                 else
                                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Slider/template.php';
                              }
                              wp_reset_postdata(); ?>
                           </ul>
                        </div>
                     </div>
                  </div>
                  <?php if (!is_page_template('streamit-full-width.php')) echo '</div>'; ?>
               </div>
            <?php }
         endif;
      }

      //===============================RELATED MOVIES================================
      if ($streamit_display_related_movie) {
         $terms_id         = wp_list_pluck(wp_get_post_terms($current_post_id, 'movie_genre'), 'term_id');
         $is_badges_enable = isset($streamit_options['streamit_releated_movie_enable_premium_badges']) && $streamit_options['streamit_releated_movie_enable_premium_badges'] == "yes" ? true : false;
         $show_title       = isset($streamit_options['streamit_releated_movie_enable_title']) && $streamit_options['streamit_releated_movie_enable_title'] == "yes" ? true : false;

         if (!empty($terms_id)) :

            $related_movies_args = array(
               'post_type'    => 'movie',
               'post_status'  => 'publish',
               'orderby'      => 'rand',
               'exclude'      => $current_post_id,
               'fields'       => 'ids'
            );

            if ($streamit_options['streamit_related_movies_all'] == 'selected') {
               $related_movies_args['post__in'] = $streamit_options['streamit_related_movies_selected'];
            } else {
               $related_movies_args['tax_query'] = array(
                  array(
                     'taxonomy'  => 'movie_genre',
                     'field'     => 'term_id',
                     'terms'     => $terms_id,
                  )
               );
            }

            $related_movies = new \WP_Query($related_movies_args);
            $post_ids       = $related_movies->posts;

            if ($related_movies->have_posts()) { ?>
               <div id="iq-related-movie" class="iq-favorites s-margin <?php echo esc_attr('iq-rtl-direction'); ?> <?php echo esc_attr($lazy_load); ?>">
                  <?php if (!is_page_template('streamit-full-width.php')) echo '<div class="container-fluid">'; ?>
                  <div class="row m-0">
                     <div class="col-sm-12 overflow-hidden p-0">
                        <div class="iq-main-header d-flex align-items-center justify-content-between iq-ltr-direction">
                           <h4 class="main-title">
                              <?php echo (!empty($streamit_options['streamit_display_related_movie_title'])) ? esc_html($streamit_options['streamit_display_related_movie_title']) :  esc_html__('Related Movies', 'streamit'); ?>
                           </h4>
                        </div>

                        <?php if ($releated_movie_cards_style == "2") {
                           $class = "iq-card-wrapper";
                           wp_enqueue_style("cards-general", STREAMIT_EXTENSION_PLUGIN_URL . 'includes/Elementor/assets/css/cards-general.css');
                        } else {
                           $class = "favorites-contens iq-smovie-slider iq-card-wrapper";
                        } ?>

                        <div class="iq-rtl-direction <?php echo esc_attr($class); ?>">
                           <ul class="inner-slider list-inline row p-0 mb-0">

                              <?php $col                 = '';
                              $is_grid                   = false;
                              $settings['play_now_text'] = $play_btn_text;
                              $settings['image_style']   = "portrait";

                              foreach ($post_ids as $post_id) {
                                 if ($releated_movie_cards_style == "2")
                                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Cards/template.php';
                                 else
                                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Slider/template.php';
                              }
                              wp_reset_postdata();
                              ?>
                           </ul>
                        </div>
                     </div>
                  </div>
                  <?php if (!is_page_template('streamit-full-width.php')) echo '</div>'; ?>
               </div>
            <?php }
            wp_reset_postdata();
         endif;
      }

      //=========================RELATED VIDEOS===============================
      if ($streamit_display_related_video) {
         $related_video_ids   = get_post_meta($current_post_id, '_related_video_ids', true);
         $is_badges_enable    = isset($streamit_options['streamit_releated_video_enable_premium_badges']) && $streamit_options['streamit_releated_video_enable_premium_badges'] == "yes" ? true : false;
         $show_title          = isset($streamit_options['streamit_releated_video_enable_title']) && $streamit_options['streamit_releated_video_enable_title'] == "yes" ? true : false;

         if (!empty($related_video_ids)) :

            $args = array(
               'post_type'       => 'video',
               'post_status'     => 'publish',
               'posts_per_page'  => -1,
               'post__in'        => $related_video_ids,
               'orderby'         => 'post__in',
               'fields'          => 'ids'
            );

            $related_videos = new \WP_Query($args);
            $post_ids       = $related_videos->posts;

            if ($related_videos->have_posts()) :
               $post_count       = count($post_ids);
               $direction_class  = $post_count > 4 ? 'iq-rtl-direction' : ''; ?>

               <div id="iq-related-videos" class="iq-favorites s-margin <?php echo esc_attr($direction_class); ?> <?php echo esc_attr($lazy_load); ?>">
                  <?php if (!is_page_template('streamit-full-width.php')) echo '<div class="container-fluid">'; ?>

                  <div class="row m-0">
                     <div class="col-sm-12 overflow-hidden p-0">
                        <div class="iq-main-header d-flex align-items-center justify-content-between iq-ltr-direction">
                           <h4 class="main-title">
                              <?php if (!empty($streamit_options['streamit_display_related_video_title'])) {
                                 echo esc_attr($streamit_options['streamit_display_related_video_title'], 'streamit');
                              } else {
                                 echo esc_html__('Related Videos', 'streamit');
                              } ?>
                           </h4>
                        </div>

                        <?php if ($releated_video_cards_style == "2") {
                           $class = "iq-card-wrapper";
                           wp_enqueue_style("cards-general", STREAMIT_EXTENSION_PLUGIN_URL . 'includes/Elementor/assets/css/cards-general.css');
                        } else {
                           $class = "favorites-contens iq-smovie-slider";
                        } ?>

                        <div class="<?php echo esc_attr($class); ?>">
                           <ul class="inner-slider list-inline row p-0 mb-0">
                              <?php
                              $col                 = '';
                              $is_grid                   = false;
                              $settings['play_now_text'] = $play_btn_text;
                              $settings['image_style']   = "portrait";

                              foreach ($post_ids as $post_id) {
                                 if ($releated_video_cards_style == "2")
                                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Cards/template.php';
                                 else
                                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Slider/template.php';
                              } ?>
                           </ul>
                        </div>
                     </div>
                  </div>
                  <?php if (!is_page_template('streamit-full-width.php')) echo '</div>'; ?>
               </div>
      <?php
            endif;
            wp_reset_postdata();
         endif;
      }

      //==========================UPCOMING MOVIES=====================
      streamit()->streamit_display_upcoming('movie');

      //==========================RELEATED PRODUCTS===================== 
      ?>
      <div class="container-fluid">
         <?php
         streamit()->streamit_related_product(
            get_queried_object_id(),
            $streamit_options['streamit_display_related_product'],
            $streamit_options['streamit_display_related_product_title'],
            $streamit_options['streamit_show_related']
         ); // Function Call To Get Select Related Product 
         ?>
      </div>
   </main>
</div>

<?php
streamit()->streamit_more_content_js();
get_footer();
