<?php

/**
 * The Template for displaying all single tv shows
 *
 * This template can be overridden by copying it to yourtheme/masvideos/single-tv-show.php.
 *
 * HOWEVER, on occasion MasVideos will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @package MasVideos/Templates
 * @version 1.0.0
 */

namespace Streamit\Utility;

defined('ABSPATH') || exit;

get_header();

global $episode, $streamit_options;

$post_id       = get_the_ID();
$tab_uniqid    = 'tab-' . uniqid();
$meta          = get_post_meta($post_id);
$season_id     = $meta['_tv_show_season_id'][0];
$episod_data   = get_post_meta($post_id, '_tv_show_id');
$season_data   = get_post_meta($episod_data[0], '_seasons');
$is_restricted = streamit()->streamit_is_post_restricted($post_id);
$season_data   = !empty($season_data[0][$season_id]) ? $season_data[0][$season_id] : 0;

$display_rating          = isset($streamit_options['streamit_episode_display_rating']) && $streamit_options['streamit_episode_display_rating'] == 'yes';
$display_latest_episodes = isset($streamit_options['streamit_display_latest_episode']) && $streamit_options['streamit_display_latest_episode'] == 'yes' && !empty($season_data['episodes']);

function_exists('user_post_view_count') && user_post_view_count($episod_data); ?>

<div id="primary" class="content-area">
   <main id="main" class="site-main">
      <?php if (!is_page_template('streamit-full-width.php')) echo '<div class="container-fluid">'; ?>

      <div class="w-100">
         <div class="video-container iq-main-slider">
            <?php if (have_posts()) :
               while (have_posts()) : the_post();
                  if (isset($streamit_options['streamit_restriction_priority']) && $streamit_options['streamit_restriction_priority'] == "pms") {
                     remove_filter('the_content', 'pmpro_membership_content_filter', 15);
                     if (function_exists('pms_is_post_restricted') && pms_is_post_restricted($post_id))
                        echo the_content();
                  }
                  streamit()->get_masvideo_content('content', 'single-' . get_post_type());
               endwhile;
            endif;
            wp_reset_postdata(); ?>
         </div>
      </div>

      <div class="main-content pt-5">
         <section class="p-0">
            <div class="row">
               <div class="col-lg-12">
                  <div class="trending-info season-info pt-0 pb-4 mt-0">
                     <?php while (have_posts()) : the_post(); ?>
                        <div class="row">
                           <div class="col-md-9 col-12 mb-auto">
                              <div class="d-sm-flex single-details align-items-center">
                                 <h3 class="trending-text big-title text-uppercase mt-0 mr-sm-2">
                                    <?php echo get_the_title(); ?>
                                 </h3>
                                 <?php streamit()->streamit_display_imdb_rating($post_id); ?>
                              </div>

                              <div class="d-flex flex-wrap align-items-center text-detail episode-name mb-4 mt-3 flex-wrap">
                                 <span><?php echo esc_html($meta['_episode_number'][0]); ?></span>
                                 <span class="trending-year"><?php the_title(); ?></span>
                                 <?php streamit()->streamit_show_counter(); ?>
                              </div>

                              <?php streamit()->streamit_get_icons_list($post_id); ?>
                           </div>

                           <?php get_template_part('template-parts/global/trailer', 'button'); ?>
                        </div>
                     <?php
                     endwhile;
                     wp_reset_postdata(); ?>
                  </div>

                  <div class="streamit-content-details trending-info g-border">
                     <ul class="trending-pills-header d-flex nav nav-pills align-items-center text-center s-margin mb-3 mb-md-5 justify-content-center" role="tablist">
                        <?php if (!empty(get_the_content())) { ?>
                           <li class="nav-item">
                              <a class="nav-link active show" data-toggle="pill" href="#<?php echo esc_attr($tab_uniqid); ?>description" role="tab" aria-selected="true"><?php echo esc_html__('Description', 'streamit'); ?></a>
                           </li>
                        <?php } ?>

                        <?php if ($display_rating) { ?>
                           <li class="nav-item">
                              <a class="nav-link" data-toggle="pill" href="#<?php echo esc_attr($tab_uniqid); ?>review" role="tab" aria-selected="false"><?php echo esc_html__('Rate & Review', 'streamit'); ?></a>
                           </li>
                        <?php }

                        if (!$is_restricted && $episode->get_sources() || !$episode) { ?>
                           <li class="nav-item">
                              <a class="nav-link" data-toggle="pill" href="#<?php echo esc_attr($tab_uniqid); ?>sources" role="tab" aria-selected="false"><?php echo esc_html__('Sources', 'streamit'); ?></a>
                           </li>
                        <?php } ?>
                     </ul>

                     <div class="tab-content">
                        <?php if (!empty(get_the_content())) { ?>
                           <div id="<?php echo esc_attr($tab_uniqid); ?>description" class="tab-pane animated fadeIn active show" role="tabpanel">
                              <div class="description-content hideContent">
                                 <?php streamit()->streamit_content_description(); ?>
                              </div>
                              <div class="show-more">
                                 <a href="javascript:void(0);" data-showmore="<?php echo esc_attr__('More...', 'streamit'); ?>" data-showless="<?php echo esc_attr__('Less...', 'streamit'); ?>"><?php echo esc_html__('More...', 'streamit'); ?></a>
                              </div>
                           </div>
                        <?php } ?>

                        <?php if ($display_rating) { ?>
                           <div id="<?php echo esc_attr($tab_uniqid); ?>review" class="tab-pane animated fadeIn" role="tabpanel">
                              <?php
                              if (comments_open() || get_comments_number()) :
                                 comments_template();
                              endif; ?>
                           </div>
                        <?php } ?>

                        <?php
                        if (!$is_restricted && $episode->get_sources() || !$episode) { ?>
                           <div id="<?php echo esc_attr($tab_uniqid); ?>sources" class="tab-pane fade" role="tabpanel">
                              <?php masvideos_get_template_part('single-episode-sources'); ?>
                           </div>
                        <?php } ?>
                     </div>
                  </div>
               </div>
            </div>
         </section>

         <?php
         //========================LATEST EPISODES==========================
         if ($display_latest_episodes) {
            $posts_per_page = isset($streamit_options['streamit_episode_per_page']) && !empty($streamit_options['streamit_episode_per_page']) ? $streamit_options['streamit_episode_per_page'] : 12 ?>

            <section id="iq-latest-episodes" class="iq-favorites">
               <div class="block-space single-episode-space">
                  <div class="row">
                     <div class="col-sm-12 overflow-hidden">
                        <div class="iq-main-header d-flex align-items-center justify-content-between">
                           <h4 class="main-title">
                              <?php if (!empty($streamit_options['streamit_latest_episodes_title'])) {
                                 echo esc_attr($streamit_options['streamit_latest_episodes_title'], 'streamit');
                              } else {
                                 echo esc_html__('Latest Episodes', 'streamit');
                              } ?>
                           </h4>
                        </div>
                     </div>
                  </div>

                  <div class="row">
                     <?php
                     $args = array(
                        'post_type'      => 'episode',
                        'post_status'    => 'publish',
                        'posts_per_page' => $posts_per_page,
                        'post__in'       => $season_data['episodes'],
                        'paged'          => (get_query_var('paged')) ? get_query_var('paged') : 1,
                     );

                     $episode_query = new \WP_Query($args);
                     if ($episode_query->have_posts()) {

                        while ($episode_query->have_posts()) {
                           $episode_query->the_post();

                           $loop_id              = get_the_ID();
                           $episode_number       = get_post_meta($loop_id, '_episode_number', true);
                           $episode_run_time     = get_post_meta($loop_id, '_episode_run_time', true);
                           $thumbnail_id         = get_post_meta($loop_id, '_thumbnail_id', true);
                           $episode_release_date = get_post_meta($loop_id, '_episode_release_date', true);

                           if ($episode_release_date)
                              $episode_release_date = date_i18n(get_option('date_format'), $episode_release_date);

                           $url = ($thumbnail_id) ? wp_get_attachment_url($thumbnail_id) : ''; ?>

                           <div class="col-lg-3 col-md-6 col-sm-6 iq-mb-30">
                              <div class="epi-box">
                                 <?php do_action('streamit_before_episode_template', get_the_ID()); ?>
                                 <div class="epi-img position-relative">
                                    <img src="<?php echo esc_url($url); ?>" class="img-fluid img-zoom" alt="<?php esc_attr_e('streamit', 'streamit'); ?>">
                                    <div class="episode-number"> <?php echo esc_html($episode_number); ?></div>
                                    <div class="episode-play-info">
                                       <div class="episode-play">
                                          <a href="<?php echo get_the_permalink($loop_id); ?>">
                                             <i class="fas fa-play"></i>
                                          </a>
                                       </div>
                                    </div>
                                 </div>

                                 <div class="epi-desc p-3">
                                    <div class="d-flex align-items-center justify-content-between mb-3">
                                       <span class="rel-date"><?php echo esc_html($episode_release_date); ?></span>
                                       <span class="text-primary run-time"><?php echo esc_html($episode_run_time); ?></span>
                                    </div>
                                    <a href="<?php echo get_the_permalink($loop_id); ?>">
                                       <h6 class="epi-name mb-0">
                                          <?php echo esc_html(get_the_title()); ?>
                                       </h6>
                                    </a>
                                 </div>
                              </div>
                           </div>
                     <?php }
                     } ?>
                  </div>

                  <?php
                  if (isset($streamit_options['streamit_display_pagination'])) {
                     $options = $streamit_options['streamit_display_pagination'];
                     if ($options == "load_more" && $episode_query->max_num_pages > 1) {
                        echo '<a class="ml-3 streamit_loadmore_btn_episode btn btn-hover iq-button" data-loadmore-page-no="1" data-max-number-page="' . $page . '" data-episode-query-args=\'' . json_encode($args) . '\' tabindex="0" data-loading-text="' . $streamit_options['streamit_display_blog_loadmore_text_2'] . '"><span>' . $streamit_options['streamit_display_blog_loadmore_text'] . '</span></a>';
                     } else {
                        get_template_part('template-parts/content/pagination', '', array('wp_query' => $episode_query));
                     }
                  } else {
                     get_template_part('template-parts/content/pagination', '', array('wp_query' => $episode_query));
                  }
                  wp_reset_postdata(); ?>
               </div>
            </section>
         <?php }

         streamit()->streamit_related_product(
            get_queried_object_id(),
            $streamit_options['streamit_display_related_product'],
            $streamit_options['streamit_display_related_product_title'],
            $streamit_options['streamit_show_related']
         ); // Function Call To Get Select Related Product 
         ?>
      </div>

      <?php if (!is_page_template('streamit-full-width.php')) echo '</div>'; ?>
   </main>
</div>
<?php
streamit()->streamit_more_content_js();

get_footer();
