<?php

/**
 * Sources Template
 *
 * @package WordPress
 * @subpackage streamit
 * @since 1.0
 * @version 1.0
 */

defined('ABSPATH') || exit;

global $episode;

if (!$episode || !($episode->has_sources())) return;

$post_id                        = get_the_ID();
$post_type                      = get_post_type();
$post_url                       = get_permalink($post_id);
$sources                        = $episode->get_sources();
$live_streaming_plugin_active   = is_plugin_active('live-streaming/live-streamit.php');
$content_choice                 = get_post_meta($post_id, '_' . $post_type . '_choice', true);
$live_streaming_option_enable   = ($content_choice == $post_type . '_live_stream'); ?>

<div class="source-list-content">
    <table class="episode-sources sources-table">
        <thead class="trending-pills">
            <tr>
                <th><?php echo esc_html__('Links', 'streamit') ?></th>
                <th><?php echo esc_html__('Quality', 'streamit') ?></th>
                <th><?php echo esc_html__('Language', 'streamit') ?></th>
                <th><?php echo esc_html__('Player', 'streamit') ?></th>
                <th><?php echo esc_html__('Date Added', 'streamit') ?></th>
                <th><?php echo esc_html__('Download', 'streamit') ?></th>
            </tr>
        </thead>

        <tbody class="trending-pills">
            <?php if (isset($_GET['source']) && !empty($_GET['source'])) { ?>
                <tr>
                    <td>
                        <a href="<?php echo esc_url(remove_query_arg('source', $post_url)); ?>" class="play-source  btn-hover iq-button"><i class="fas fa-play mr-2" aria-hidden="true"></i>
                            <?php echo apply_filters('masvideos_movie_play_source_text', esc_html__('Play Now', 'streamit')); ?>
                        </a>
                    </td>
                    <td>
                        <?php esc_html_e('Original', 'streamit'); ?>
                    </td>
                    <td>
                        <?php esc_html_e('Original', 'streamit'); ?>
                    </td>
                    <td>
                        <?php esc_html_e('Original', 'streamit'); ?>
                    </td>
                    <td>
                        <?php echo !empty($date = get_post_meta($post_id, '_' . $post_type . '_release_date', true)) ? date('Y-m-d', $date) : ''; ?>
                    </td>
                </tr>
            <?php
            }

            foreach ($sources as $key => $source) : ?>
                <?php if (empty($source['embed_content']) && empty($source['link'])) continue; ?>
                <tr>
                    <td>
                        <?php $source_content = ($source['choice'] == 'episode_url') ? $source['link'] : $source['embed_content'];

                        if (isset($source['is_affiliate']) && $source['is_affiliate'] && !empty($source_content)) { ?>
                            <a href="<?php echo esc_url($source_content); ?>" class="play-source episode-affiliate-play-source btn-hover iq-button" target="_blank"><i class="fas fa-play mr-2" aria-hidden="true"></i>
                                <?php echo apply_filters('masvideos_episode_play_source_text', esc_html__('Play Now', 'streamit')); ?>
                            </a>
                            <?php
                        } else {
                            if ($live_streaming_option_enable && $live_streaming_plugin_active) {
                                $redirect_page_url = add_query_arg('source', $source['name'], $post_url); ?>
                                <a href="<?php echo esc_url($redirect_page_url); ?>" class="play-source  btn-hover iq-button"><i class="fas fa-play mr-2" aria-hidden="true"></i>
                                    <span> <?php echo apply_filters('masvideos_movie_play_source_text', esc_html__('Play Now', 'streamit')); ?></span>
                                </a>
                            <?php } else {
                                $source_content = apply_filters('the_content', $source_content); ?>
                                <a href="#" class="play-source episode-play-source btn-hover iq-button" data-content="<?php echo esc_attr(htmlspecialchars($source_content)); ?>"><i class="fas fa-play mr-2" aria-hidden="true"></i>
                                    <span><?php echo apply_filters('masvideos_episode_play_source_text', esc_html__('Play Now', 'streamit')); ?></span>
                                </a>
                        <?php
                            }
                        } ?>
                    </td>

                    <td>
                        <?php if (!empty($source['quality'])) {
                            echo wp_kses_post($source['quality']);
                        } ?>
                    </td>
                    <td>
                        <?php if (!empty($source['language'])) {
                            echo wp_kses_post($source['language']);
                        } ?>
                    </td>
                    <td>
                        <?php if (!empty($source['player'])) {
                            echo wp_kses_post($source['player']);
                        } ?>
                    </td>
                    <td>
                        <?php if (!empty($source['date_added'])) {
                            echo wp_kses_post($source['date_added']);
                        } ?>
                    </td>

                    <td>
                        <?php if (!empty($source['download_content'])) {
                            $url = $source['download_content'];
                            $filename = basename($url); ?>
                            <button type="submit" class="download_source_link btn-hover iq-button px-3" data-url="<?php echo esc_url($url) ?>" data-filename="<?php echo esc_attr($filename) ?>">
                                <i class="fas fa-download m-0"></i>
                            </button>
                        <?php } ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>