<?php

/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package streamit
 */

namespace Streamit\Utility;

get_header();

global $streamit_options, $wp_query;

$options_streamit_load 	= '';
$post_section 				= streamit()->post_style();
$is_sidebar 				= streamit()->is_primary_sidebar_active();
$is_ajax_search 			= isset($_GET['ajax_search']) && $_GET['ajax_search'] == 'true' ? true : false;

$is_ajax_enable      		= true;
$lazy_load           		= $is_ajax_enable ? " iqonic-lazy-load-images" : '';

if (isset($streamit_options['streamit_blog']))
	$streamit_layout = $streamit_options['streamit_blog'];

if (isset($streamit_options['streamit_display_pagination']))
	$options_streamit_load = $streamit_options['streamit_display_pagination'];

$options_streamit_load = isset($streamit_options['streamit_display_pagination']) ? $streamit_options['streamit_display_pagination'] : '';
$archive_cards_style     = isset($streamit_options['streamit_archive_cards_style']) && !empty($streamit_options['streamit_archive_cards_style']) ? $streamit_options['streamit_archive_cards_style'] : '1';

if ($archive_cards_style == "2") {
	wp_enqueue_style("cards-general", STREAMIT_EXTENSION_PLUGIN_URL . 'includes/Elementor/assets/css/cards-general.css');
	$main_class = "iq-card-wrapper";
} else {
	$main_class = "watchlist-contens";
}

$main_class .= $lazy_load; ?>

<div class="site-content-contain">
	<div id="content" class="site-content">
		<div id="primary" class="content-area search-page">
			<main id="main" class="site-main <?php esc_attr($is_ajax_search) ? esc_attr_e('streamit_datapass', 'streamit')  : esc_attr_e('streamit_datapass_blog', 'streamit') ?> " data-options="<?php echo esc_attr($options_streamit_load); ?>">
				<div class="<?php echo (class_exists('MasVideos') && $is_ajax_search) ? esc_attr("container-fluid") : esc_attr("container")   ?>">
					<div class="row <?php echo esc_attr($main_class) ?>">
						<?php if ($is_ajax_search) {
							if (have_posts()) {
								$query = new \WP_Query($wp_query->query_vars);
								while ($query->have_posts()) {
									$query->the_post();
									get_template_part('template-parts/content/entry_search', $query->get_post_type());
								}
							} else {
								get_template_part('template-parts/content/error');
							}
						} else {
							if (have_posts()) {
								if ($is_sidebar) {

									echo '<div class="col-xl-8 col-sm-12 streamit-blog-main-list">';
								} else if ($streamit_layout != '4' && $streamit_layout != '5') {
									echo '<div class="col-lg-12 col-sm-12 streamit-blog-main-list">';
								}
								while (have_posts()) {
									the_post();
									get_template_part('template-parts/content/entry', get_post_type(), ['entry_item_class' => $post_section['post']]);
								}
								if ($is_sidebar || $streamit_layout != '4' && $streamit_layout != '5') {
									echo '</div>';
									get_sidebar();
								}
							} else {
								get_template_part('template-parts/content/error');
							}
						} ?>
					</div>

					<?php if (isset($streamit_options['streamit_display_pagination'])) {
						$options = $streamit_options['streamit_display_pagination'];
						if ($options == "load_more") {
							if ($wp_query->max_num_pages > 1)
								echo '<a class="streamit_search_loadmore_btn btn btn-hover iq-button" tabindex="0"  data-loading-text="' . $streamit_options['streamit_display_blog_loadmore_text_2'] . '"  data-max_pages="' . esc_attr($query->max_num_pages) . '"><span data-parallax="scroll">' . $streamit_options['streamit_display_blog_loadmore_text'] . '</span></a>';
						} elseif ($options == "infinite_scroll") {

							echo '<div class="loader-wheel-container"></div>';
						} else {
							get_template_part('template-parts/content/pagination');
						}
					} else {
						get_template_part('template-parts/content/pagination');
					} ?>
				</div>

				<?php if (class_exists('MasVideos') && isset($streamit_options['streamit_display_upcoming']) && $streamit_options['streamit_display_upcoming'] == 'yes') {
					streamit()->streamit_display_upcoming('movie');
				} ?>
			</main><!-- #primary -->
		</div>
	</div>
</div>

<?php get_footer();
