<?php

/**
 * Template: Member Profile Edit
 *
 * See documentation for how to override the PMPro templates.
 * @link https://www.paidmembershipspro.com/documentation/templates/
 *
 * @version 2.0
 *
 * @author Paid Memberships Pro
 */
// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

global $current_user, $pmpro_msg, $pmpro_msgt; ?>

<div class="streamit-pmpro-edit-profile">
	<?php
	echo do_shortcode('[iqonic_edit_user_avatar]');

	//=========================PROFILE DETAILS========================
	if (!is_user_logged_in()) {
		echo '<div class="' . pmpro_get_element_class('pmpro_message pmpro_alert', 'pmpro_alert') . '">
				<a href="' . esc_url(pmpro_login_url()) . '">' . esc_html__('Log in to edit your profile.', 'streamit') . '</a>
			</div>';
		return;
	}

	// Saving profile updates.
	if (isset($_POST['action']) && $_POST['action'] == 'update-profile' && $current_user->ID == $_POST['user_id'] && wp_verify_nonce(sanitize_key($_POST['update_user_nonce']), 'update-user_' . $current_user->ID)) {
		$update           = true;
		$user     		  = new stdClass;
		$user->ID         = intval($_POST['user_id']);
		do_action('pmpro_personal_options_update', $user->ID);
	} else {
		$update = false;
	}

	if ($update) {

		$errors = array();

		// Get all values from the $_POST, sanitize them, and build the $user object.
		if (isset($_POST['user_email'])) {
			$user->user_email = sanitize_text_field(wp_unslash($_POST['user_email']));
		}
		if (isset($_POST['first_name'])) {
			$user->first_name = sanitize_text_field($_POST['first_name']);
		}
		if (isset($_POST['last_name'])) {
			$user->last_name = sanitize_text_field($_POST['last_name']);
		}
		if (isset($_POST['display_name'])) {
			$user->display_name = sanitize_text_field($_POST['display_name']);
			$user->nickname = $user->display_name;
		}

		// Validate display name.
		if (empty($user->display_name)) {
			$errors[] = __('Please enter a display name.', 'streamit');
		}

		// Don't allow admins to change their email address.
		if (current_user_can('manage_options')) {
			$user->user_email = $current_user->user_email;
		}

		// Validate email address.
		if (empty($user->user_email)) {
			$errors[] = __('Please enter an email address.', 'streamit');
		} elseif (!is_email($user->user_email)) {
			$errors[] = __('The email address isn&#8217;t correct.', 'streamit');
		} else {
			$owner_id = email_exists($user->user_email);
			if ($owner_id && (!$update || ($owner_id != $user->ID))) {
				$errors[] = __('This email is already registered, please choose another one.', 'streamit');
			}
		}

		/**
		 * Fires before member profile update errors are returned.
		 *
		 * @param $errors WP_Error object (passed by reference).
		 * @param $update Whether this is a user update.
		 * @param $user   User object (passed by reference).
		 */
		do_action_ref_array('pmpro_user_profile_update_errors', array(&$errors, $update, &$user));

		// Show error messages.
		if (!empty($errors)) { ?>
			<div class="<?php echo pmpro_get_element_class('pmpro_message pmpro_error', 'pmpro_error'); ?>">
				<?php
				foreach ($errors as $key => $value) {
					echo '<p>' . $value . '</p>';
				} ?>
			</div>
		<?php } else {
			// Save updated profile fields.
			wp_update_user($user); ?>
			<div class="<?php echo pmpro_get_element_class('pmpro_message pmpro_success', 'pmpro_success'); ?>">
				<?php _e('Your profile has been updated.', 'streamit'); ?>
			</div>
	<?php }
	} else {
		// Doing this so fields are set to new values after being submitted.
		$user = $current_user;
	} ?>

	<div class="<?php echo pmpro_get_element_class('pmpro_member_profile_edit_wrap'); ?>">
		<h2 class=""> <?php esc_html_e("Profile Details", "streamit"); ?> </h2>
		<form id="member-profile-edit" class="<?php echo pmpro_get_element_class('pmpro_form'); ?>" action="" method="post" <?php do_action('pmpro_member_profile_edit_form_tag'); ?>>
			<?php wp_nonce_field('update-user_' . $current_user->ID, 'update_user_nonce');

			$user_fields = apply_filters(
				'pmpro_member_profile_edit_user_object_fields',
				array(
					'first_name'	=> __('First Name', 'streamit'),
					'last_name'		=> __('Last Name', 'streamit'),
					'display_name'	=> __('Display name publicly as', 'streamit'),
					'user_email'	=> __('Email', 'streamit'),
				)
			); ?>

			<div class="<?php echo pmpro_get_element_class('pmpro_checkout_box-user'); ?>">
				<div class="<?php echo pmpro_get_element_class('pmpro_member_profile_edit-fields'); ?>">
					<?php foreach ($user_fields as $field_key => $label) { ?>
						<div class="<?php echo pmpro_get_element_class('pmpro_member_profile_edit-field pmpro_member_profile_edit-field- ' . $field_key, 'pmpro_member_profile_edit-field- ' . $field_key); ?>">
							<label for="<?php echo esc_attr($field_key); ?>"><?php echo esc_html($label); ?></label>
							<?php if (current_user_can('manage_options') && $field_key === 'user_email') { ?>
								<input type="text" readonly="readonly" name="user_email" id="user_email" value="<?php echo esc_attr($user->user_email); ?>" class="<?php echo pmpro_get_element_class('input', 'user_email'); ?>" />
								<p class="<?php echo pmpro_get_element_class('lite'); ?>"><?php esc_html_e('Site administrators must use the WordPress dashboard to update their email address.', 'streamit'); ?></p>
							<?php } else { ?>
								<input type="text" name="<?php echo esc_attr($field_key); ?>" id="<?php echo esc_attr($field_key); ?>" value="<?php echo esc_attr(stripslashes($user->{$field_key})); ?>" class="<?php echo pmpro_get_element_class('input', $field_key); ?>" />
							<?php } ?>
						</div>
					<?php } ?>
				</div> <!-- end pmpro_member_profile_edit-fields -->
			</div> <!-- end pmpro_checkout_box-user -->

			<?php
			/**
			 * Fires after the default Your Member Profile fields.
			 *
			 * @since 2.3
			 *
			 * @param WP_User $current_user The current WP_User object.
			 */
			do_action('pmpro_show_user_profile', $current_user); ?>

			<input type="hidden" name="action" value="update-profile" />
			<input type="hidden" name="user_id" value="<?php echo esc_attr($current_user->ID); ?>" />
			<div class="<?php echo pmpro_get_element_class('pmpro_submit'); ?>">
				<button name="submit" class="<?php echo pmpro_get_element_class('btn btn-hover iq-button pmpro_btn-submit', 'pmpro_btn-submit'); ?>">
					<?php esc_attr_e('Update Profile', 'streamit'); ?>
				</button>
				<input type="button" name="cancel" class="<?php echo pmpro_get_element_class('btn btn-hover iq-button pmpro_btn pmpro_btn-cancel', 'pmpro_btn-cancel'); ?>" value="<?php esc_attr_e('Cancel', 'streamit'); ?>" onclick="location.href='<?php echo pmpro_url('account'); ?>';" />
			</div>
		</form>
	</div> <!-- end pmpro_member_profile_edit_wrap -->


	<?php //=========================CHANGE PASSWORD========================  
	?>

	<div class="streamit-pmpro-change_password">
		<h2><?php esc_html_e('Change Password', 'streamit'); ?></h2>

		<div class="<?php echo pmpro_get_element_class('pmpro_change_password_wrap'); ?>">
			<?php if (!empty($pmpro_msg)) { ?>
				<div class="<?php echo pmpro_get_element_class('pmpro_message ' . $pmpro_msgt, $pmpro_msgt); ?>">
					<?php echo esc_html($pmpro_msg); ?>
				</div>
			<?php } ?>

			<form id="change-password" class="<?php echo pmpro_get_element_class('pmpro_form', 'change-password'); ?>" action="" method="post">

				<?php wp_nonce_field('change-password-user_' . $current_user->ID, 'change_password_user_nonce'); ?>

				<div class="<?php echo pmpro_get_element_class('pmpro_checkout_box-password'); ?>">
					<div class="<?php echo pmpro_get_element_class('pmpro_change_password-fields'); ?>">
						<div class="<?php echo pmpro_get_element_class('pmpro_change_password-field pmpro_change_password-field-password_current', 'pmpro_change_password-field-password_current'); ?>">
							<label for="password_current"><?php esc_html_e('Current Password', 'streamit'); ?></label></th>
							<input type="password" name="password_current" id="password_current" value="" class="<?php echo pmpro_get_element_class('input', 'password_current'); ?>" />
							<span class="<?php echo pmpro_get_element_class('pmpro_asterisk'); ?>"> <abbr title="<?php _e('Required Field', 'streamit'); ?>">*</abbr></span>
						</div> <!-- end pmpro_change_password-field-password_current -->

						<div class="<?php echo pmpro_get_element_class('pmpro_change_password-field pmpro_change_password-field-pass1', 'pmpro_change_password-field-pass1'); ?>">
							<label for="pass1"><?php esc_html_e('New Password', 'streamit'); ?></label></th>
							<input type="password" name="pass1" id="pass1" value="" class="<?php echo pmpro_get_element_class('input pass1', 'pass1'); ?>" autocomplete="off" />
							<span class="<?php echo pmpro_get_element_class('pmpro_asterisk'); ?>"> <abbr title="<?php _e('Required Field', 'streamit'); ?>">*</abbr></span>
							<div id="pass-strength-result" class="hide-if-no-js" aria-live="polite"><?php esc_html_e('Strength Indicator', 'streamit'); ?></div>
						</div> <!-- end pmpro_change_password-field-pass1 -->

						<p class="<?php echo pmpro_get_element_class('lite pass-text'); ?>"><?php echo wp_get_password_hint(); ?></p>

						<div class="<?php echo pmpro_get_element_class('pmpro_change_password-field pmpro_change_password-field-pass2', 'pmpro_change_password-field-pass2'); ?>">
							<label for="pass2"><?php esc_html_e('Confirm New Password', 'streamit'); ?></label></th>
							<input type="password" name="pass2" id="pass2" value="" class="<?php echo pmpro_get_element_class('input', 'pass2'); ?>" autocomplete="off" />
							<span class="<?php echo pmpro_get_element_class('pmpro_asterisk'); ?>"> <abbr title="<?php _e('Required Field', 'streamit'); ?>">*</abbr></span>
						</div> <!-- end pmpro_change_password-field-pass2 -->
					</div> <!-- end pmpro_change_password-fields -->
				</div> <!-- end pmpro_checkout_box-password -->

				<input type="hidden" name="action" value="change-password" />
				<input type="hidden" name="user_id" value="<?php echo esc_attr($current_user->ID); ?>" />
				<div class="<?php echo pmpro_get_element_class('pmpro_submit'); ?>">
					<button name="submit" class="<?php echo pmpro_get_element_class('btn btn-hover iq-button pmpro_btn-submit', 'pmpro_btn-submit'); ?>">
						<?php esc_attr_e('Change Password', 'streamit'); ?>
					</button>
					<input type="button" name="cancel" class="<?php echo pmpro_get_element_class('btn btn-hover iq-button pmpro_btn pmpro_btn-cancel', 'pmpro_btn-cancel'); ?>" value="<?php esc_attr_e('Cancel', 'streamit'); ?>" onclick="location.href='<?php echo esc_url(pmpro_url('account')); ?>';" />
				</div>
			</form>
		</div> <!-- end pmpro_change_password_wrap -->
	</div>
</div>