<?php

/**
 * Template: Invoice
 *
 * See documentation for how to override the PMPro templates.
 * @link https://www.paidmembershipspro.com/documentation/templates/
 *
 * @version 2.0
 *
 * @author Paid Memberships Pro
 */
global $wpdb, $current_user, $pmpro_invoice, $pmpro_msg, $pmpro_msgt; ?>

<div class="<?php echo esc_attr(pmpro_get_element_class('streamit-pmpro-invoice pmpro_invoice_wrap')); ?>" id="<?php echo esc_attr(pmpro_get_element_class('pmpro_confirmation_wrap')); ?>">
	<?php if ($pmpro_invoice) {
		if ($pmpro_msg) { ?>
			<div class="<?php echo esc_attr(pmpro_get_element_class('pmpro_message ' . $pmpro_msgt, $pmpro_msgt)); ?>"><?php echo wp_kses_post($pmpro_msg); ?></div>
		<?php
		}

		if (!empty($pmpro_invoice) && !empty($pmpro_invoice->id)) {
			$pmpro_invoice->getUser();
			$pmpro_invoice->getMembershipLevel(); ?>

			<div class="invoice-header-wrap">
				<div class="wrap-invoice-title">
					<h3> <?php echo esc_html__('Invoice', 'streamit'); ?> </h3>
					<span class="invoice-details"> <?php echo esc_html(sprintf(__('ID #%s on %s', 'streamit'), $pmpro_invoice->code, date_i18n(get_option('date_format'), $pmpro_invoice->getTimestamp()))); ?></span>
				</div>

				<ul class="mt-0">
					<?php do_action("pmpro_invoice_bullets_top", $pmpro_invoice); ?>

					<li>
						<span><strong><?php esc_html_e('Account Holder Name', 'streamit'); ?>:</strong></span>
						<span><?php echo esc_html($current_user->display_name); ?></span>
					</li>

					<li>
						<span><strong><?php esc_html_e('Membership Level', 'streamit'); ?>:</strong></span>
						<span><?php echo esc_html($pmpro_invoice->membership_level->name);
						if (in_array($pmpro_invoice->status, array('pending', 'token'))) {
							echo ' (' . esc_html__('Pending', 'streamit') . ')';
						} ?></span>
					</li>

					<?php if (!empty($current_user->membership_level->enddate) && !in_array($pmpro_invoice->status, array('pending', 'token'))) { ?>
						<li>
						<span><strong><?php esc_html_e('Membership Expires', 'streamit'); ?>:</strong></span>
						<span><?php echo esc_html(date_i18n(get_option('date_format'), $current_user->membership_level->enddate)) ?></span>
						</li>
					<?php }

					if (!empty($pmpro_invoice->status)) { ?>
						<li><strong><?php esc_html_e('Status', 'streamit'); ?>:</strong>
							<?php
							if (in_array($pmpro_invoice->status, array('', 'success', 'cancelled'))) {
								$display_status = __('Paid', 'streamit');
							} else {
								$display_status = ucwords($pmpro_invoice->status);
							}
							echo esc_html($display_status); ?>
						</li>
					<?php }

					if ($pmpro_invoice->getDiscountCode()) { ?>
						<li>
							<strong><?php esc_html_e('Discount Code', 'streamit'); ?>:</strong>
							<?php echo esc_html($pmpro_invoice->discount_code->code); ?>
						</li>
					<?php }

					do_action("pmpro_invoice_bullets_bottom", $pmpro_invoice); ?>
				</ul>
			</div>

			<div class="<?php echo esc_attr(pmpro_get_element_class('pmpro_invoice_details pmpro_invoice-info')); ?>">
				<?php if (!empty($pmpro_invoice->billing->street)) { ?>
					<div class="<?php echo esc_attr(pmpro_get_element_class('pmpro_invoice-billing-address')); ?>">
						<strong><?php esc_html_e('Billing Address', 'streamit'); ?></strong>
						<p>
							<span class="<?php echo esc_attr(pmpro_get_element_class('pmpro_invoice-field-billing_name')); ?>"><?php echo esc_html($pmpro_invoice->billing->name); ?></span>
							<span class="<?php echo esc_attr(pmpro_get_element_class('pmpro_invoice-field-billing_street')); ?>"><?php echo esc_html($pmpro_invoice->billing->street); ?></span>
							<?php if ($pmpro_invoice->billing->city && $pmpro_invoice->billing->state) { ?>
								<span class="<?php echo esc_attr(pmpro_get_element_class('pmpro_invoice-field-billing_city')); ?>"><?php echo esc_html($pmpro_invoice->billing->city); ?></span>
								<span class="<?php echo esc_attr(pmpro_get_element_class('pmpro_invoice-field-billing_state')); ?>"><?php echo esc_html($pmpro_invoice->billing->state); ?></span>
								<span class="<?php echo esc_attr(pmpro_get_element_class('pmpro_invoice-field-billing_zip')); ?>"><?php echo esc_html($pmpro_invoice->billing->zip); ?></span>
								<span class="<?php echo esc_attr(pmpro_get_element_class('pmpro_invoice-field-billing_country')); ?>"><?php echo esc_html($pmpro_invoice->billing->country); ?></span>
							<?php } ?>
							<span class="<?php echo esc_attr(pmpro_get_element_class('pmpro_invoice-field-billing_phone')); ?>"><?php echo esc_html(formatPhone($pmpro_invoice->billing->phone)); ?></span>
						</p>
					</div> <!-- end pmpro_invoice-billing-address -->
				<?php } ?>

				<?php if (!empty($pmpro_invoice->accountnumber) || !empty($pmpro_invoice->payment_type)) { ?>
					<div class="<?php echo esc_attr(pmpro_get_element_class('pmpro_invoice-payment-method')); ?>">
						<strong><?php esc_html_e('Payment Method', 'streamit'); ?></strong>
						<?php if ($pmpro_invoice->accountnumber) { ?>
							<p><?php echo esc_html(ucwords($pmpro_invoice->cardtype)); ?> <?php _e('ending in', 'streamit'); ?> <?php echo esc_html(last4($pmpro_invoice->accountnumber)); ?>
								<br />
								<?php _e('Expiration', 'streamit'); ?>: <?php echo esc_html($pmpro_invoice->expirationmonth); ?>/<?php echo esc_html($pmpro_invoice->expirationyear); ?>
							</p>
						<?php } else { ?>
							<p><?php echo esc_html($pmpro_invoice->payment_type); ?></p>
						<?php } ?>
					</div> <!-- end pmpro_invoice-payment-method -->
				<?php } ?>

				<div class="<?php echo esc_attr(pmpro_get_element_class('pmpro_invoice-total')); ?>">
					<strong><?php esc_html_e('Total Billed', 'streamit'); ?></strong>
					<p>
						<?php
						if ((float)$pmpro_invoice->total > 0) {
							//phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							echo pmpro_escape_price(pmpro_get_price_parts($pmpro_invoice, 'span'));
						} else {
							//phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							echo pmpro_escape_price(pmpro_formatPrice(0));
						} ?>
					</p>
				</div> <!-- end pmpro_invoice-total -->
			</div> <!-- end pmpro_invoice -->

			<div class="d-block clearfix">
				<div class="wrap-btn-invoice">
					<span class="streamit-print-invoice">
						<a class="<?php echo esc_attr(pmpro_get_element_class('pmpro_a-prints')); ?>" href="javascript:window.print()"><i class="fas fa-print mr-2"></i><?php esc_html_e('Invoice Print', 'streamit'); ?></a>
					</span>

					<span class="streamit-download-invoice">
						<a class="<?php echo esc_attr(pmpro_get_element_class('pmpro_a-pdf')); ?>" href="javascript:window.print()"><i class="far fa-file-pdf mr-2"></i><?php esc_html_e('Download Invoice PDF', 'streamit'); ?></a>
					</span>
				</div>
			</div>
		<?php
		} else {
			$confirmation_message .= "<p>" . sprintf(__('Below are details about your membership account. A welcome email has been sent to %s.', 'streamit'), $current_user->user_email) . "</p>";

			/**
			 * All devs to filter the confirmation message.
			 * Documented above.
			 * We also have a function in includes/filters.php that applies the the_content filters to this message.
			 */
			$confirmation_message = apply_filters("pmpro_confirmation_message", $confirmation_message, false);

			echo wp_kses_post($confirmation_message); ?>
			<ul>
				<li><strong><?php esc_html_e('Account', 'streamit'); ?>:</strong> <?php echo esc_html($current_user->display_name); ?> (<?php echo esc_html($current_user->user_email); ?>)</li>
				<li><strong><?php esc_html_e('Membership Level', 'streamit'); ?>:</strong>
					<?php if (!empty($current_user->membership_level)) echo esc_html($current_user->membership_level->name);
					else esc_html_e("Pending", 'streamit'); ?></li>
				<?php if (!empty($current_user->membership_level->expiration_period) && $current_user->membership_level->expiration_period == 'Hour' && apply_filters('pmpro_confirmation_display_hour_expiration', true, $current_user)) { ?>
					<li><strong><?php esc_html_e('Expires In', 'streamit'); ?>:</strong> <?php echo esc_html($current_user->membership_level->expiration_number . ' ' . pmpro_translate_billing_period($current_user->membership_level->expiration_period, $current_user->membership_level->expiration_number)); ?></li>
				<?php }
				?>
			</ul>
		<?php
		} ?>

		<p class="<?php echo esc_attr(pmpro_get_element_class('pmpro_actions_nav action-btn')); ?>">
			<?php if (!empty($current_user->membership_level)) { ?>
				<a class="btn btn-hover iq-button" href="<?php echo esc_url(pmpro_url('account')); ?>"><?php esc_html_e('View Your Membership Account', 'streamit'); ?></a>
			<?php } else { ?>
				<?php _e('If your account is not activated within a few minutes, please contact the site owner.', 'streamit'); ?>
			<?php } ?>
		</p> <!-- end pmpro_actions_nav -->

		<?php } else {

		//Show all invoices for user if no invoice ID is passed
		$invoices = $wpdb->get_results("SELECT o.*, UNIX_TIMESTAMP(CONVERT_TZ(o.timestamp, '+00:00', @@global.time_zone)) as timestamp, l.name as membership_level_name FROM $wpdb->pmpro_membership_orders o LEFT JOIN $wpdb->pmpro_membership_levels l ON o.membership_id = l.id WHERE o.user_id = '$current_user->ID' AND o.status NOT IN('review', 'token', 'error') ORDER BY timestamp DESC");
		if ($invoices) { ?>
			<h3> <?php echo esc_html__("Past Invoices", "streamit") ?> </h3>

			<table id="pmpro_invoices_table" class="<?php echo esc_attr(pmpro_get_element_class('pmpro_table pmpro_invoice', 'pmpro_invoices_table')); ?> table-responsive-sm" width="100%" cellpadding="0" cellspacing="0" border="0">
				<thead>
					<tr>
						<th><?php esc_html_e('Invoice ID', 'streamit'); ?></th>
						<th><?php esc_html_e('Level', 'streamit'); ?></th>
						<th><?php esc_html_e('Date', 'streamit'); ?></th>
						<th><?php esc_html_e('Payment', 'streamit'); ?></th>
						<th><?php esc_html_e('Status', 'streamit'); ?></th>
					</tr>
				</thead>

				<tbody>
					<?php
					foreach ($invoices as $invoice) { ?>
						<tr>
							<td><a href="<?php echo esc_url(pmpro_url("invoice", "?invoice=" . $invoice->code)) ?>"><?php echo esc_html($invoice->code); ?></a></td>
							<td><?php echo esc_html($invoice->membership_level_name); ?></td>
							<td><a href="<?php echo esc_url(pmpro_url("invoice", "?invoice=" . $invoice->code)) ?>"><?php echo esc_html(date_i18n(get_option("date_format"), strtotime(get_date_from_gmt(date('Y-m-d H:i:s', $invoice->timestamp))))) ?></a></td>
							<td><?php echo esc_html(pmpro_formatPrice($invoice->total)); ?></td>
							<?php
							if (in_array($invoice->status, array('', 'success', 'cancelled'))) {
								$display_status = esc_html__('Paid', 'streamit');
							} elseif ($invoice->status == 'pending') {
								// Some Add Ons set status to pending.
								$display_status = esc_html__('Pending', 'streamit');
							} elseif ($invoice->status == 'refunded') {
								$display_status = esc_html__('Refunded', 'streamit');
							} ?>
							<td>
								<span class="pmpro_invoice_status">
									<?php echo esc_html($display_status); ?>
								</span>
							</td>
						</tr>
					<?php
					} ?>
				</tbody>
			</table>
		<?php
		} else { ?>
			<p><?php esc_html_e('No invoices found.', 'streamit'); ?></p>
		<?php
		} ?>
		<p class="<?php echo esc_attr(pmpro_get_element_class('pmpro_actions_nav')); ?>">
			<span class="<?php echo esc_attr(pmpro_get_element_class('pmpro_actions_nav')); ?>"><a class="btn btn-hover iq-button" href="<?php echo esc_url(pmpro_url("account")) ?>"><?php esc_html_e('View Your Membership Account', 'streamit'); ?></a></span>
			<?php if ($pmpro_invoice) { ?>
				<span class="<?php echo esc_attr(pmpro_get_element_class('pmpro_actions_nav')); ?>"><a class="btn btn-hover iq-button" href="<?php echo esc_url(pmpro_url("invoice")) ?>"><?php esc_html_e('View All Invoices', 'streamit'); ?></a></span>
			<?php } ?>
		</p> <!-- end pmpro_actions_nav -->
	<?php
	} ?>
</div> <!-- end pmpro_invoice_wrap -->