<?php

/**
 * Manage Playlists
 *
 * This template can be overridden by copying it to yourtheme/masvideos/myaccount/manage-playlists.php.
 *
 * HOWEVER, on occasion MasVideos will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @package MasVideos/Templates
 * @version 1.0.0
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (!isset($post_type)) {
    return;
}

if (empty($playlists)) {
    return;
}

$section_title = !empty($manage_section_title) ? $manage_section_title : esc_html__('Manage Playlists', 'streamit');

do_action('masvideos_before_manage_playlists'); ?>

<div class="masvideos-manage-playlists">
    <div class="masvideos-manage-playlists__inner">
        <div class="iq-main-header d-flex align-items-center justify-content-between">
            <h4 class="main-title"><?php echo esc_html($section_title); ?></h4>
        </div>
        <table class="masvideos-table">
            <thead>
                <tr>
                    <td><?php echo esc_html__('Title', 'streamit') ?></td>
                    <td><?php echo esc_html__('Actions', 'streamit') ?></td>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($playlists as $key => $obj) :
                    $post_type = str_replace('_playlist', '', $obj->post_type); ?>
                    <tr>
                        <td>
                            <h6><?php echo get_the_title($obj->ID); ?></h6>
                        </td>
                        <td>
                            <?php
                            $actions = masvideos_get_account_playlists_actions($obj);
                            if (!empty($actions)) {
                                foreach ($actions as $key => $action) {
                                    $action['url'] = $key == 'edit' ? add_query_arg('playlistof', $post_type, $action['url']) : $action['url'];
                                    add_query_arg('playlistof', $post_type, $action['url']);
                                    echo '<a href="' . esc_url($action['url']) . '" class="masvideos-button ' . sanitize_html_class($key) . '">' . esc_html($action['name']) . '</a>';
                                }
                            }
                            ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

    </div>
</div>

<?php do_action('masvideos_after_manage_playlists'); ?>