<?php

/**
 * The template for displaying movie playlist content in the single-movie-playlist.php template
 *
 * This template can be overridden by copying it to yourtheme/masvideos/content-single-movie-playlist.php.
 *
 * HOWEVER, on occasion MasVideos will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @package MasVideos/Templates
 * @version 1.0.0
 */

global $streamit_options;

defined('ABSPATH') || exit;

/**
 * Hook: masvideos_before_single_movie_playlist.
 *
 * @hooked wc_print_notices - 10
 */
do_action('masvideos_before_single_movie_playlist');

if (post_password_required()) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}

$main_class = " watchlist-contens ";
$archive_cards_style = isset($streamit_options['streamit_archive_cards_style']) && !empty($streamit_options['streamit_archive_cards_style']) ? $streamit_options['streamit_archive_cards_style'] : '1';
if ($archive_cards_style == 2) {
    $main_class = " iq-card-wrapper ";
    wp_enqueue_style("cards-general", STREAMIT_EXTENSION_PLUGIN_URL . 'includes/Elementor/assets/css/cards-general.css');
}

$main_class .= " iqonic-lazy-load-images " ?>

<div id="primary" class="content-area">
    <main id="main" class="site-main">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 col-sm-12">
                    <div id="movie-playlist-<?php the_ID(); ?>" <?php masvideos_movie_playlist_class($main_class); ?>>
                        <?php
                        /**
                         * Hook: masvideos_before_single_movie_playlist_summary.
                         *
                         * @hooked masvideos_show_movie_playlist_sale_flash - 10
                         * @hooked masvideos_show_movie_playlist_images - 20
                         */
                        do_action('masvideos_before_single_movie_playlist_summary');
                        ?>
                        <?php
                        /**
                         * Hook: masvideos_single_movie_playlist_summary.
                         *
                         * @hooked masvideos_template_single_title - 5
                         * @hooked masvideos_template_single_rating - 10
                         * @hooked masvideos_template_single_price - 10
                         * @hooked masvideos_template_single_excerpt - 20
                         * @hooked masvideos_template_single_add_to_cart - 30
                         * @hooked masvideos_template_single_meta - 40
                         * @hooked masvideos_template_single_sharing - 50
                         * @hooked WC_Structured_Data::generate_movie_playlist_data() - 60
                         */
                        do_action('masvideos_single_movie_playlist_summary');
                        ?>
                        <?php
                        /**
                         * Hook: masvideos_after_single_movie_playlist_summary.
                         *
                         * @hooked masvideos_output_movie_playlist_data_tabs - 10
                         * @hooked masvideos_upsell_display - 15
                         * @hooked masvideos_output_related_movie_playlists - 20
                         */
                        do_action('masvideos_after_single_movie_playlist_summary');
                        ?>
                    </div>

                </div>
            </div>
        </div><!-- #primary -->
    </main><!-- #main -->
</div><!-- .container -->
<?php do_action('masvideos_after_single_movie_playlist'); ?>