<?php

Redux::set_section($this->opt_name, array(
    'title'         => esc_html__('Upcoming', STREAMIT_TEXT_DOMAIN),
    'id'            => 'single-custom-post-upcomming-options',
    'icon'          => 'custom-Upcoming',
    'subsection'    => true,
    'fields'        => array(

        array(
            'id'        => 'streamit_display_upcoming',
            'type'      => 'button_set',
            'title'     => esc_html__('Show Upcoming', STREAMIT_TEXT_DOMAIN),
            'subtitle'  => esc_html__('Turn on to display the Upcoming ', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                'yes'   => esc_html__('On', STREAMIT_TEXT_DOMAIN),
                'no'    => esc_html__('Off', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => esc_html__('yes', STREAMIT_TEXT_DOMAIN)
        ),
        array(
            'id'        => 'streamit_upcoming_movie_cards_style',
            'type'      => 'button_set',
            'title'     => esc_html__('Select Cards Style', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                '1'     => esc_html__('Style 1', STREAMIT_TEXT_DOMAIN),
                '2'     => esc_html__('Style 2', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => '1',
            "class"     => "streamit-sub-fields",
            'required'  => array('streamit_display_upcoming', '=', 'yes'),
        ),
        array(
            'id'        => 'streamit_upcoming_movie_enable_premium_badges',
            'type'      => 'button_set',
            'title'     => esc_html__('Enable Premium Badges', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                'yes'   => esc_html__('Yes', STREAMIT_TEXT_DOMAIN),
                'no'    => esc_html__('No', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => 'no',
            "class"     => "streamit-sub-fields",
            'required'  => array('streamit_display_upcoming', '=', 'yes'),
        ),
        array(
            'id'        => 'streamit_upcoming_movie_enable_title',
            'type'      => 'button_set',
            'title'     => esc_html__('Enable Title', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                'yes'   => esc_html__('Yes', STREAMIT_TEXT_DOMAIN),
                'no'    => esc_html__('No', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => 'yes',
            "class"     => "streamit-sub-fields",
            'required'  => array('streamit_display_upcoming', '=', 'yes'),
        ),
        array(
            'id'        => 'streamit_upcoming_title',
            'type'      => 'text',
            'required'  => array('streamit_display_upcoming', '=', 'yes'),
            'title'     => esc_html__('Upcomming button title', STREAMIT_TEXT_DOMAIN),
            'default'   => 'Upcomming',
        ),
        array(
            'id'       => 'streamit_upcoming_multi_select',
            'type'     => 'select',
            'multi'    => true,
            'title'    => __('Select Post Type', STREAMIT_TEXT_DOMAIN),
            'subtitle' => __('Select specific Post to display upcomming List', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                'movie' => 'Movie',
                'video' => 'Video'
            ),
            'default'  => array('movie', 'video'),
            'required' => array('streamit_display_upcoming', '=', 'yes'),
        ),
        array(
            'id'        => 'streamit_upcoming_movies_all',
            'type'      => 'select',
            'title'     => esc_html__('Show All Upcomming Movies', STREAMIT_TEXT_DOMAIN),
            'required'  => array(
                array('streamit_display_upcoming', 'equals', 'yes'),
                array('streamit_upcoming_multi_select', 'equals', 'movie'),
            ),
            'options'   => array(
                'all'       => esc_html__('All', STREAMIT_TEXT_DOMAIN),
                'selected'  => esc_html__('Selected', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => 'all'
        ),
        array(
            'id'        => 'streamit_upcoming_movies_selected',
            'type'      => 'select',
            'data'      => 'posts',
            'multi'     => true,
            'title'     => esc_html__('Select Movies For Upcomming List', STREAMIT_TEXT_DOMAIN),
            'desc'      =>  esc_html__('Use upcomming movies on a page which you selected.(Note:If the movie is not selected then all the movies will appear)', STREAMIT_TEXT_DOMAIN),
            'args'      => array(
                'post_type'         => 'movie',
                'post_status'       => 'publish',
                'posts_per_page'    => '-1',
                'fields'            => 'ids'
            ),
            'required'  => array(
                array('streamit_display_upcoming', 'equals', 'yes'),
                array('streamit_upcoming_movies_all', 'equals', 'selected'),
            ),
        ),
        array(
            'id'        => 'streamit_upcoming_videos_all',
            'type'      => 'select',
            'title'     => esc_html__('Show All Upcomming Videos', STREAMIT_TEXT_DOMAIN),
            'required'  => array(
                array('streamit_display_upcoming', 'equals', 'yes'),
                array('streamit_upcoming_multi_select', 'equals', 'video'),
            ),
            'options'   => array(
                'all'       => esc_html__('All', STREAMIT_TEXT_DOMAIN),
                'selected'  => esc_html__('Selected', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => 'all'
        ),
        array(
            'id'        => 'streamit_upcoming_videos_selected',
            'type'      => 'select',
            'data'      => 'posts',
            'multi'     => true,
            'title'     => esc_html__('Select Videos For Upcomming List', STREAMIT_TEXT_DOMAIN),
            'desc'      =>  esc_html__('Use upcomming videos on a page which you selected.(Note:If the video is not selected then all the videos will appear)', STREAMIT_TEXT_DOMAIN),
            'args'      => array(
                'post_type'      => 'video',
                'post_status'    => 'publish',
                'posts_per_page' => '-1',
                'fields'         => 'ids'
            ),
            'required'  => array(
                array('streamit_display_upcoming', 'equals', 'yes'),
                array('streamit_upcoming_videos_all', 'equals', 'selected'),
            ),
        ),
    )
));
