<?php

Redux::set_section($this->opt_name, array(
    'title'         => esc_html__('Trailer Link', STREAMIT_TEXT_DOMAIN),
    'id'            => 'single-custom-post-trailer-options',
    'icon'          => 'custom-link',
    'subsection'    => true,
    'fields'        => array(
        array(
            'id'        => 'streamit_display_trailer_link',
            'type'      => 'button_set',
            'title'     => esc_html__('Show Trailer Link', STREAMIT_TEXT_DOMAIN),
            'subtitle'  => esc_html__('Turn on to display the trailer link details page', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                'yes'   => esc_html__('On', STREAMIT_TEXT_DOMAIN),
                'no'    => esc_html__('Off', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => esc_html__('no', STREAMIT_TEXT_DOMAIN)
        ),

        array(
            'id'        => 'streamit_display_trailer_link_btn',
            'type'      => 'button_set',
            'options'   => array(
                'yes'   => esc_html__('Default', STREAMIT_TEXT_DOMAIN),
                'no'    => esc_html__('Thumbnail', STREAMIT_TEXT_DOMAIN)
            ),
            'title'     => esc_html__('Select Style', STREAMIT_TEXT_DOMAIN),
            'default'   => 'yes',
            'required'  => array('streamit_display_trailer_link', '=', 'yes'),
        ),

        array(
            'id'       => 'streamit_opt_multi_select',
            'type'     => 'select',
            'multi'    => true,
            'title'    => __('Select Post Type', STREAMIT_TEXT_DOMAIN),
            'subtitle' => __('Select specific Post to display the trailer link', STREAMIT_TEXT_DOMAIN),
            'options'  => array(
                'movie'     => 'Movie',
                'tv_show'   => 'Tv Show',
                'video'     => 'Video',
                'episode'   => 'Episode'
            ),
            'default'   => array('movie', 'tv_show', 'video', 'episode'),
            'required'  => array('streamit_display_trailer_link', '=', 'yes'),
        ),

        array(
            'id'       => 'streamit_trailer_link_icon',
            'type'     => 'select',
            'select2'  => array('containerCssClass' => 'fa'),
            'title'    => esc_html__('Trailer Link button Icon', STREAMIT_TEXT_DOMAIN),
            'width'    => '100%',
            'class'    => 'font-icons',
            'options'  => $iconArray,
            'default'   => 'fas fa-play',
            'required'  => array('streamit_display_trailer_link', '=', 'yes'),
        ),

        array(
            'id'        => 'streamit_trailer_link_text',
            'type'      => 'text',
            'title'     => esc_html__('Trailer Link Text', STREAMIT_TEXT_DOMAIN),
            'default'   => 'Trailer Link',
            'required'  => array('streamit_display_trailer_link', '=', 'yes'),
        ),
    )
));
