<?php

Redux::set_section($this->opt_name, array(
    'title'         => esc_html__('Big Heading Texture', STREAMIT_TEXT_DOMAIN),
    'id'            => 'custom-text-bigheading-options',
    'icon'          => 'custom-texture',
    'subsection'    => true,
    'fields'        => array(
        array(
            'id'       => 'streamit_big_heading_title_bg_type',
            'type'     => 'button_set',
            'title'    => esc_html__('Set Heading Texture Background Type', STREAMIT_TEXT_DOMAIN),
            'options'  => array(
                '1'    => 'Color',
                '2'    => 'Image',
            ),
            'default'  => '2'
        ),

        array(
            'id'        => 'streamit_big_heading_title_banner_image',
            'type'      => 'media',
            'url'       => false,
            'title'     => esc_html__('Set Heading Texture Image', STREAMIT_TEXT_DOMAIN),
            'read-only' => false,
            'class'     => 'streamit-sub-fields',
            'required'  => array('streamit_big_heading_title_bg_type', '=', '2'),
            'subtitle'  => esc_html__('Upload Image for your heading texture background.', STREAMIT_TEXT_DOMAIN),
            'default'   => array('url' => get_template_directory_uri() . '/assets/images/redux/texture.jpg'),
        ),

        array(
            'id'            => 'streamit_big_heading_title_bg_color',
            'type'          => 'color',
            'class'         => 'streamit-sub-fields',
            'title'         => esc_html__('Set Heading Texture Color', STREAMIT_TEXT_DOMAIN),
            'required'      => array('streamit_big_heading_title_bg_type', '=', '1'),
            'mode'          => 'background',
            'transparent'   => false,
            'default'       => '#fff'
        ),
    )
));
