<?php

Redux::set_section($this->opt_name, array(
    'title'         => esc_html__('Related Product', STREAMIT_TEXT_DOMAIN),
    'id'            => 'single-custom-post-related-product-options',
    'icon'          => 'custom-Product',
    'subsection'    => true,
    'fields'        => array(
        array(
            'id'        => 'streamit_display_related_product',
            'type'      => 'button_set',
            'title'     => esc_html__('Show Related Products', STREAMIT_TEXT_DOMAIN),
            'subtitle'  => esc_html__('Turn on to display the Related Products', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                'yes'   => esc_html__('On', STREAMIT_TEXT_DOMAIN),
                'no'    => esc_html__('Off', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => esc_html__('yes', STREAMIT_TEXT_DOMAIN)
        ),
        array(
            'id'        => 'streamit_display_related_product_title',
            'type'      => 'text',
            'required'  => array('streamit_display_related_product', '=', 'yes'),
            'title'     => esc_html__('Related Product Heading', STREAMIT_TEXT_DOMAIN),
            'class'     => 'streamit-sub-fields',
            'default'   => 'Related products',
        ),

        array(
            'id'        => 'streamit_show_related',
            'type'      => 'select',
            'multi'     => true,
            'title'     => __('Select Post Type', STREAMIT_TEXT_DOMAIN),
            'subtitle'  => __('Select specific Post to display upcomming List', STREAMIT_TEXT_DOMAIN),
            'class'     => 'streamit-sub-fields',
            'options'   => array(
                'movie'     => 'Movie',
                'video'     => 'Video',
                'tv_show'   => 'Tv Show',
                'episode'   => 'Episode',
            ),
            'default'   => array('movie', 'video'),
            'required'  => array('streamit_display_related_product', '=', 'yes'),
        ),
    )
));
