<?php

Redux::set_section($this->opt_name, array(
    'title'         => esc_html__('Related Movies', STREAMIT_TEXT_DOMAIN),
    'id'            => 'single-custom-post-related-movie-options',
    'icon'          => 'custom-Related-Movies',
    'subsection'    => true,
    'fields'        => array(
        array(
            'id'        => 'streamit_display_related_movie',
            'type'      => 'button_set',
            'title'     => esc_html__('Show Related Movies', STREAMIT_TEXT_DOMAIN),
            'subtitle'  => esc_html__('Turn on to display the Related Movies', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                'yes'   => esc_html__('On', STREAMIT_TEXT_DOMAIN),
                'no'    => esc_html__('Off', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => esc_html__('yes', STREAMIT_TEXT_DOMAIN)
        ),
        array(
            'id'        => 'streamit_releated_movie_cards_style',
            'type'      => 'button_set',
            'title'     => esc_html__('Select Cards Style', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                '1'     => esc_html__('Style 1', STREAMIT_TEXT_DOMAIN),
                '2'     => esc_html__('Style 2', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => '1',
            "class"     => "streamit-sub-fields",
            'required'  => array('streamit_display_related_movie', '=', 'yes'),
        ),
        array(
            'id'        => 'streamit_releated_movie_enable_premium_badges',
            'type'      => 'button_set',
            'title'     => esc_html__('Enable Premium Badges', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                'yes'   => esc_html__('Yes', STREAMIT_TEXT_DOMAIN),
                'no'    => esc_html__('No', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => 'no',
            "class"     => "streamit-sub-fields",
            'required'  => array('streamit_display_related_movie', '=', 'yes'),
        ),
        array(
            'id'        => 'streamit_releated_movie_enable_title',
            'type'      => 'button_set',
            'title'     => esc_html__('Enable Title', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                'yes'   => esc_html__('Yes', STREAMIT_TEXT_DOMAIN),
                'no'    => esc_html__('No', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => 'yes',
            "class"     => "streamit-sub-fields",
            'required'  => array('streamit_display_related_movie', '=', 'yes'),
        ),
        array(
            'id'        => 'streamit_display_related_movie_title',
            'type'      => 'text',
            'required'  => array('streamit_display_related_movie', '=', 'yes'),
            'title'     => esc_html__('Related button title', STREAMIT_TEXT_DOMAIN),
            'class'     => 'streamit-sub-fields',
            'default'   => 'Related Movies',
        ),
        array(
            'id'        => 'streamit_related_movies_all',
            'type'      => 'select',
            'title'     => esc_html__('Show All Related Movies', STREAMIT_TEXT_DOMAIN),
            'required'  => array(
                array('streamit_display_related_movie', 'equals', 'yes'),
            ),
            'class'     => 'streamit-sub-fields',
            'options'   => array(
                'all'       => esc_html__('All', STREAMIT_TEXT_DOMAIN),
                'selected'  => esc_html__('Selected', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => 'all'
        ),
        array(
            'id'        => 'streamit_related_movies_selected',
            'type'      => 'select',
            'data'      => 'posts',
            'multi'     => true,
            'title'     => esc_html__('Select Movies For Related List', STREAMIT_TEXT_DOMAIN),
            'desc'      =>  esc_html__('Use Related movies on a page which you selected.(Note:If the movie is not selected then all the movies will appear)', STREAMIT_TEXT_DOMAIN),
            'class'     => 'streamit-sub-fields',
            'args'      => array(
                'post_type'      => 'movie',
                'post_status'    => 'publish',
                'posts_per_page' => '-1',
                'fields'         => 'ids'
            ),
            'required'  => array(
                array('streamit_display_related_movie', '=', 'yes'),
                array('streamit_related_movies_all', '=', 'selected'),
            ),
        ),
    )
));
