<?php

Redux::set_section($this->opt_name, array(
    'title'         => esc_html__(' Rating / Play Button', STREAMIT_TEXT_DOMAIN),
    'id'            => 'custom-text-options',
    'icon'          => 'custom-Rating',
    'subsection'    => true,
    'fields'        => array(
        array(
            'id'        => 'streamit_imdb_display_rating',
            'type'      => 'button_set',
            'title'     => esc_html__('Display IMDB Rating Out Of 10', STREAMIT_TEXT_DOMAIN),
            'subtitle'  => esc_html__('Turn on to display IMDB rating Out of 10 ', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                'yes'   => esc_html__('On', STREAMIT_TEXT_DOMAIN),
                'no'    => esc_html__('Off', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => esc_html__('no', STREAMIT_TEXT_DOMAIN)
        ),
        array(
            'id'        => 'streamit_imdb_display_logo',
            'type'      => 'button_set',
            'title'     => esc_html__('Display IMDB Logo', STREAMIT_TEXT_DOMAIN),
            'subtitle'  => esc_html__('Turn on to display IMDB Logo', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                'yes'   => esc_html__('Yes', STREAMIT_TEXT_DOMAIN),
                'no'    => esc_html__('No', STREAMIT_TEXT_DOMAIN)
            ),
            'default'   => esc_html__('yes', STREAMIT_TEXT_DOMAIN)
        ),
        array(
            'id'        => 'streamit_imdb_logo',
            'type'      => 'media',
            'url'       => false,
            'read-only' => false,
            'title'     => esc_html__('Set IMDB logo', STREAMIT_TEXT_DOMAIN),
            'class'     => 'streamit-sub-fields',
            'required'  => array('streamit_imdb_display_logo', '=', 'yes'),
            'default'   => array('url' => get_template_directory_uri() . '/assets/images/redux/IMDB_Logo.svg'),
        ),
        array(
            'id'        => 'streamit_display_single_star',
            'type'      => 'button_set',
            'title'     => esc_html__('Display Single Star', STREAMIT_TEXT_DOMAIN),
            'subtitle'  => esc_html__('Turn on to display single star', STREAMIT_TEXT_DOMAIN),
            'options'   => array(
                'yes'   => esc_html__('On', STREAMIT_TEXT_DOMAIN),
                'no'    => esc_html__('Off', STREAMIT_TEXT_DOMAIN)
            ),
            'class'     => 'streamit-sub-fields',
            'default'   => esc_html__('yes', STREAMIT_TEXT_DOMAIN),
            'required'  => array('streamit_imdb_display_rating', '=', 'yes'),
        ),
        array(
            'id'        => 'streamit_play_btn_text',
            'type'      => 'text',
            'class'     => 'streamit-sub-fields',
            'title'     => esc_html__('Play Button Text', STREAMIT_TEXT_DOMAIN),
            'subtitle'  => esc_html__('Enter Text For Changing Button Text In Inner Page  ', STREAMIT_TEXT_DOMAIN),
            'default'   => __('Play Now', STREAMIT_TEXT_DOMAIN),
        ),
    )
));
