<?php

/**
 * Streamit\Utility\Redux_Framework\Options\Pms class
 *
 * @package streamit
 */

namespace Streamit\Utility\Redux_Framework\Options;

use Redux;
use Streamit\Utility\Redux_Framework\Component;

class PMP extends Component
{

    public function __construct()
    {
        $this->set_widget_option();
    }

    protected function set_widget_option()
    {

        Redux::set_section($this->opt_name, array(
            'title' => esc_html__('PMP Restriction Settings', 'streamit'),
            'id'    => 'restriction_priority',
            'icon'  => 'custom-Breadcrumb',
            'fields' => array(
                array(
                    'id'        => 'restrict_non_logged_in',
                    'title'     => esc_html__('Restrict Non Logged In Users?', 'streamit'),
                    'description' => esc_html__('Restrict the content for the non logged in members. Non Members will be redirected to the selected page', 'streamit'),
                    'type'      => 'button_set',
                    'options' => [
                        'yes' => esc_html__('Yes', 'streamit'),
                        'no' => esc_html__('No', 'streamit'),
                    ],
                    'default' => 'no',
                ),
                array(
                    'id'        => 'streamit_redirect_page_for_non_login',
                    'type'      =>  'select',
                    'multi'     =>  false,
                    'data'      =>  'pages',
                    'title'     => esc_html__('Select Redirect Page For Non Logged In Users', 'streamit'),
                    'class'     => 'streamit-sub-fields',
                    'required'  => array(
                        'restrict_non_logged_in', '=', 'yes'
                    ),
                ),
                array(
                    'id'        => 'streamit_noredirect_page_for_non_login',
                    'type'      =>  'select',
                    'multi'     =>  true,
                    'data'      =>  'pages',
                    'title'     => esc_html__('Selected Pages Will Not Be Redirected, like Contact us, About us, FAQ, privacy policy, coming soon pages', 'streamit'),
                    'class'     => 'streamit-sub-fields',
                    'required'  => array(
                        'restrict_non_logged_in', '=', 'yes'
                    ),
                ),
                array(
                    'id'        => 'checkout_success_redirect',
                    'title'     => esc_html__('Select Page to Redirect After Successfully Checkout.', 'streamit'),
                    'description' => esc_html__('Default is PMP Invoice Page. Only Change If Necessary.', 'streamit'),
                    'type'      => 'button_set',
                    'options' => [
                        'yes' => esc_html__('Yes', 'streamit'),
                        'no' => esc_html__('No', 'streamit'),
                    ],
                    'default' => 'no',
                ),
                array(
                    'id'        => 'checkout_success_redirect_url',
                    'type'      =>  'select',
                    'multi'     =>  false,
                    'data'      =>  'pages',
                    'title'     => esc_html__('Select the Redirect Page When Checkout is Sucessful.', 'streamit'),
                    'class'     => 'streamit-sub-fields',
                    'required'  => array(
                        'checkout_success_redirect', '=', 'yes'
                    ),
                ),
            ),
        ));

        Redux::set_section($this->opt_name, array(
            'title' => esc_html__('Additional Discount', 'streamit'),
            'id'    => 'pmp_additional_discount',
            'icon'  => 'custom-import-export',
            'subsection' => true,
            'fields' => array(
                array(
                    'id'        => 'show_additional_discount',
                    'title'     => esc_html__('Apply Additional Discount?', 'streamit'),
                    'description' => esc_html__('Restrict the content for the non logged in members. Non Members will be redirected to the selected page', 'streamit'),
                    'type'      => 'button_set',
                    'options' => [
                        'yes' => esc_html__('Yes', 'streamit'),
                        'no' => esc_html__('No', 'streamit'),
                    ],
                    'default' => 'no',
                ),
                array(
                    'id' => 'additional_discount_price',
                    'type' => 'text',
                    'title' =>  esc_html__('Enter Additional Discount Price', 'streamit'),
                    'subtitle' =>  esc_html__('Enter Amount in Number. Dont use the curreny symbol, just input the number', 'streamit'),
                    'required' => array('show_additional_discount', '=', 'yes')
                ),
                array(
                    'id' => 'additional_discount_price_start_date',
                    'type' => 'date',
                    'title' =>  esc_html__('Select Start Date', 'streamit'),
                    'required' => array('show_additional_discount', '=', 'yes')
                ),
                array(
                    'id' => 'additional_discount_price_end_date',
                    'type' => 'date',
                    'title' =>  esc_html__('Select End Date', 'streamit'),
                    'required' => array('show_additional_discount', '=', 'yes')
                ),
            )
        ));

        if (class_exists('Paid_Member_Subscriptions') && is_plugin_active('paid-memberships-pro/paid-memberships-pro.php')) {
            Redux::set_section($this->opt_name, array(
                'title' => esc_html__('PMS Import Settings', 'streamit'),
                'id'    => 'pms_import_settings',
                'icon'  => 'custom-import-export',
                'subsection' => true,
                'fields' => array(
                    array(
                        'id'        => 'streamit_restriction_priority',
                        'type'      => 'radio',
                        'title'     => esc_html__('Select Priority', 'streamit'),
                        'options'   => array(
                            'pmp'   => esc_html__('Paid Membership Pro (PMP)', 'streamit'),
                            'pms'   => esc_html__('Paid Membership Subscription (PMS)', 'streamit'),
                        ),
                        'default' => 'pms'
                    ),
                )
            ));
        }
    }
}
