<?php

/**
 * Streamit\Utility\Redux_Framework\Options\Dashboard class
 *
 * @package streamit
 */

namespace Streamit\Utility\Redux_Framework\Options;

use Redux;
use Streamit\Utility\Redux_Framework\Component;

class Dashboard extends Component
{

	public function __construct()
	{
		$this->set_widget_option();
	}

	protected function set_widget_option()
	{
		Redux::set_section($this->opt_name, array(
			'title' => esc_html__('Dashboard', 'streamit'),
			'id'    => 'redux-dashboard',
			'has_group_title' => __("Get Started", "streamit"),
			'icon'  => 'custom-Dashboard',
			'fields' => array(

				array(
					'id'           	=> 'dashboard-raw',
					'type'         	=> 'raw',
					'full_width' 	=> true,
                    'content_path' 	=>  dirname( __DIR__ ) . '/templates/dashboard-html.php'
				)

			),
		));
	}
}
