<?php

/**
 * Streamit\Utility\Masvideo\Component class
 *
 * @package streamit
 */

namespace Streamit\Utility\Masvideo;

use Streamit\Utility\Component_Interface;
use Streamit\Utility\Templating_Component_Interface;

use Exception;
use MasVideos_Movie_Factory;
use MasVideos_Episode_Factory;

/**
 * Class for managing Masvideo.
 */

class Component implements Component_Interface, Templating_Component_Interface
{

	private $is_wpml_active;
	/**
	 * Constructor.
	 */

	public function __construct()
	{
		if (function_exists('is_plugin_active')) {
			$this->is_wpml_active = is_plugin_active('sitepress-multilingual-cms/sitepress.php');
		}

		// Add Option Into Masvideo default Option;
		add_action('masvideos_movie_import_inserted_movie_object', array($this, 'streamit_add_custom_meta_on_impoter'), 10, 2);
		add_filter('masvideos_csv_movie_import_mapping_options', array($this, 'streamit_add_csv_mapping_options'), 10, 2);
		add_action('masvideos_episode_options_general_episode_data', array($this, 'streamit_tv_show_episode_label'));
		add_action('masvideos_admin_process_episode_object', array($this, 'streamit_episode_label'));

		add_filter('masvideos_json_search_limit', array($this, 'streamit_add_search_limit'));

		add_filter('masvideos_json_search_found_episodes', array($this, 'streamit_search_found_episode'));
		add_filter('masvideos_structured_data_context', array($this, 'streamit_remove_movie_url'), 10, 3);

		// if (function_exists('is_plugin_active')) {
		// 	if (is_plugin_active('live-streaming/live-streamit.php')) return;
		// }

		add_action('masvideos_before_single_episode_summary', array($this, 'streamit_single_content_summary'), 40);
		add_action('masvideos_before_single_video_summary', array($this, 'streamit_single_content_summary'), 40);
		add_action('masvideos_before_single_movie_summary', array($this, 'streamit_single_content_summary'), 40);
		
		//registers download source link
		add_action('masvideos_after_movie_source_settings', [$this, 'streamit_sources_download_link'], 10, 2);
		add_action('masvideos_after_episode_source_settings', [$this, 'streamit_sources_download_link'], 10, 2);

		//remove masvideos save sources ajax event
		remove_action('wp_ajax_masvideos_save_sources_movie', ['MasVideos_AJAX', 'save_sources_movie']);
		remove_action('wp_ajax_masvideos_save_sources_episode', ['MasVideos_AJAX', 'save_sources_episode']);

		//add our custom function to save sources
		add_action('wp_ajax_masvideos_save_sources_movie', [$this, 'streamit_save_movie_source_download_link']);
		add_action('wp_ajax_masvideos_save_sources_episode', [$this, 'streamit_save_episode_source_download_link']);
	}

	public function template_tags(): array
	{
		return array(
			'get_masvideo_content' 	=> array($this, 'get_masvideo_content'),
		);
	}
	/**
	 * Gets the unique identifier for the theme component.
	 *
	 * @return string Component slug.
	 */

	public function get_slug(): string
	{
		return 'mas-video';
	}

	/**
	 * Adds the action and filter hooks to integrate with WordPress.
	 */

	public function initialize()
	{
	}

	public function get_masvideo_content($content, $page)
	{
		masvideos_get_template_part($content, $page);
	}

	public function streamit_add_search_limit($limit)
	{
		return 50;
	}

	public function streamit_search_found_episode($episodes)
	{
		if (!$this->is_wpml_active) return $episodes;
		foreach ($episodes as $id => $episode) {
			$episodes[$id] = $episode . " - " . apply_filters('wpml_post_language_details', NULL, $id)['display_name'] ?? '';
		}
		return $episodes;
	}

	function streamit_remove_movie_url($data, $type, $value)
	{
		if (!isset($type['videoobject'])) return $data;

		$type = $type['videoobject'];
		foreach ($type as $key => $value) {
			if ($key == "contentUrl") {
				$type['contentUrl'] = '';
			} else {
				$type[$key] = $value;
			}
		}
		return $type;
	}

	public function streamit_save_movie_source_download_link()
	{
		check_ajax_referer('save-sources-movie', 'security');

		if (!current_user_can('edit_movies')) {
			wp_die(-1);
		}

		try {
			parse_str($_POST['data'], $data);

			$sources      = $this->prepare_sources($data); //save sources data including download_content value
			$movie_id     = absint($_POST['post_id']);
			$classname    = MasVideos_Movie_Factory::get_movie_classname($movie_id);
			$movie        = new $classname($movie_id);

			$movie->set_sources($sources);
			$movie->save();

			$response = array();

			ob_start();
			$sources    = $movie->get_sources('edit');
			$i          = -1;

			foreach ($data['source_names'] as $source_name) {
				$source = isset($sources[sanitize_title($source_name)]) ? $sources[sanitize_title($source_name)] : false;
				if (!$source) {
					continue;
				}
				$i++;
				$metabox_class = array();

				include('admin/meta-boxes/views/html-movie-source.php');
			}

			$response['html'] = ob_get_clean();

			wp_send_json_success($response);
		} catch (Exception $e) {
			wp_send_json_error(array('error' => $e->getMessage()));
		}
		wp_die();
	}

	public function streamit_save_episode_source_download_link()
	{
		check_ajax_referer('save-sources-episode', 'security');

		if (!current_user_can('edit_episodes')) {
			wp_die(-1);
		}

		try {
			parse_str($_POST['data'], $data);

			$sources      = $this->prepare_sources($data); //save sources data including download_content value
			$episode_id   = absint($_POST['post_id']);
			$classname    = MasVideos_Episode_Factory::get_episode_classname($episode_id);
			$episode      = new $classname($episode_id);

			$episode->set_sources($sources);
			$episode->save();

			$response = array();

			ob_start();
			$sources    = $episode->get_sources('edit');
			$i          = -1;

			foreach ($data['source_names'] as $source_name) {
				$source = isset($sources[sanitize_title($source_name)]) ? $sources[sanitize_title($source_name)] : false;
				if (!$source) {
					continue;
				}
				$i++;
				$metabox_class = array();

				include('admin/meta-boxes/views/html-episode-source.php');
			}

			$response['html'] = ob_get_clean();

			wp_send_json_success($response);
		} catch (Exception $e) {
			wp_send_json_error(array('error' => $e->getMessage()));
		}
		wp_die();
	}

	public function prepare_sources($data = false)
	{
		$sources = array();

		if (!$data) {
			$data = $_POST;
		}

		if (isset($data['source_names'], $data['source_embed_content'])) {
			$source_names         = $data['source_names'];
			$source_choice        = isset($data['source_choice']) ? $data['source_choice'] : array();
			$source_embed_content = $data['source_embed_content'];
			$source_link          = isset($data['source_link']) ? $data['source_link'] : array();
			$source_is_affiliate  = isset($data['source_is_affiliate']) ? $data['source_is_affiliate'] : array();
			$source_quality       = isset($data['source_quality']) ? $data['source_quality'] : array();
			$source_language      = isset($data['source_language']) ? $data['source_language'] : array();
			$source_player        = isset($data['source_player']) ? $data['source_player'] : array();
			$source_date_added    = isset($data['source_date_added']) ? $data['source_date_added'] : array();
			$source_position      = isset($data['source_position']) ? $data['source_position'] : array();
			$source_download_content = isset($data['source_download_content']) ? $data['source_download_content'] : array();

			$source_names_max_key = max(array_keys($source_names));

			for ($i = 0; $i <= $source_names_max_key; $i++) {
				if (empty($source_names[$i])) {
					continue;
				}

				$source = array(
					'name'          => isset($source_names[$i]) ? masvideos_clean($source_names[$i]) : '',
					'choice'        => isset($source_choice[$i]) ? masvideos_clean($source_choice[$i]) : '',
					'embed_content' => isset($source_embed_content[$i]) ? masvideos_sanitize_textarea_iframe(stripslashes($source_embed_content[$i])) : '',
					'link'          => isset($source_link[$i]) ? masvideos_sanitize_textarea_iframe(stripslashes($source_link[$i])) : '',
					'is_affiliate'  => isset($source_is_affiliate[$i]),
					'quality'       => isset($source_quality[$i]) ? masvideos_clean($source_quality[$i]) : '',
					'language'      => isset($source_language[$i]) ? masvideos_clean($source_language[$i]) : '',
					'player'        => isset($source_player[$i]) ? masvideos_clean($source_player[$i]) : '',
					'date_added'    => isset($source_date_added[$i]) ? masvideos_clean($source_date_added[$i]) : '',
					'position'      => isset($source_position[$i]) ? absint($source_position[$i]) : 0,
					'download_content' => isset($source_download_content[$i]) ? masvideos_sanitize_textarea_iframe(stripslashes($source_download_content[$i])) : '',
				);
				$sources[] = $source;
			}
		}

		return $sources;
	}

	public function streamit_sources_download_link($sources, $i)
	{ 
		?>
		<tr>
			<td>
				<?php masvideos_wp_textarea_input(
					[
						'id'            => 'source_download_content[' . $i . ']',
						'value'         => isset($sources['download_content']) ? ($sources['download_content']) :  '',
						'label'         => __('Download URL', 'streamit'),
						'description'   => __('Enter the download link', 'streamit'),
					]
				); ?>
			</td>
		</tr>
		<?php
	}

	/**
	 * It removes the wpautop filter, applies the_content filter to the content, and then adds the wpautop
	 * filter back
	 */

	public function streamit_single_content_summary()
	{
		global $post;

		$post_type = get_post_type();
		$isElementorHasFronendInstance = isset(\Elementor\Plugin::$instance->frontend);
		$isActionIsMasVideoSingleSummary =  current_action() == "masvideos_before_single_{$post_type}_summary";
		$excerpt = $post->post_excerpt;

		remove_filter('the_content', 'wpautop');
		if ($isElementorHasFronendInstance && $isActionIsMasVideoSingleSummary) {
			remove_filter('the_content', [\Elementor\Plugin::$instance->frontend, 'apply_builder_in_content'], 9);
			$post->post_excerpt = ' ';
		}

		echo apply_filters('the_content', $this->streamit_single_content());

		add_filter('the_content', 'wpautop');
		if ($isElementorHasFronendInstance && $isActionIsMasVideoSingleSummary) {
			add_filter('the_content', [\Elementor\Plugin::$instance->frontend, 'apply_builder_in_content'], 9);
			$post->post_excerpt = $excerpt;
		}
	}

	public function streamit_single_content($content = null)
	{
		$post_type = get_post_type();
		global $$post_type, $post, $streamit_options;
		$content = $$post_type;

		if (class_exists('Paid_Member_Subscriptions') && is_plugin_active('paid-memberships-pro/paid-memberships-pro.php')) {
			if (isset($streamit_options['streamit_restriction_priority']) && $streamit_options['streamit_restriction_priority'] == "pmp") {
				if (function_exists('pms_is_member') && !pms_is_member() && function_exists('pms_is_post_restricted') && pms_is_post_restricted($post->ID)) {
					remove_filter('the_content', 'pms_filter_content', 11);
				}
			} else if (isset($streamit_options['streamit_restriction_priority']) && $streamit_options['streamit_restriction_priority'] == "pms") {
				remove_filter('the_content', 'pmpro_membership_content_filter', 15);
			}
		}

		if (is_null($content) && !empty($GLOBALS[$post_type])) {
			// Content was null so pull from global.
			$content = $GLOBALS[$post_type];
		}

		if ($content && !is_a($content, 'MasVideos_' . ucfirst($post_type))) {
			// Make sure we have a valid movie, or set to false.
			$content = call_user_func('masvideos_get_' . $post_type, $content);
		}

		$content_src = '';
		$content_choice = call_user_func(array($content, 'get_' . $post_type . '_choice'));

		// Get Thumbnail and Poster Of the Content
		$poster = wp_get_attachment_url(get_post_meta(get_the_ID(), '_thumbnail_id', true));
		if ($content_choice == $post_type . '_file') {
			$content_src =  wp_get_attachment_url(call_user_func(array($content, 'get_' . $post_type . '_attachment_id')));
			return do_shortcode('[video src="' . $content_src . '" poster="' . $poster . '" ] ');
		} elseif ($content_choice ==  $post_type . '_embed') {
			$content_src =  call_user_func(array($content, 'get_' . $post_type . '_embed_content'));
			return $content_src;
		} elseif ($content_choice == $post_type . '_url') {
			$content_src =  call_user_func(array($content, 'get_' . $post_type . '_url_link'));

			if ('movie' == $post_type &&  call_user_func(array($content, 'get_' . $post_type . '_is_affiliate_link'))) {
				ob_start(); ?>
				<a href="<?php echo esc_url($content_src); ?>" class="<?php echo esc_attr($post_type) ?>-affiliate-link" target="_blank">
					<?php echo call_user_func('masvideos_get_' . $post_type . '_thumbnail', 'full'); ?>
				</a><?php
					$content_src = ob_get_clean();
					return $content_src;
				}
				return  do_shortcode('[video src="' . $content_src . '" poster="' . $poster . '"] ');
			}
		}

		public function streamit_add_custom_meta_on_impoter($object, $data)
		{
			if (isset($data['movie_trailer_link'])) {
				update_post_meta($object->get_id(), 'name_trailer_link', $data['movie_trailer_link']);
			}
			if ($data['movie_rating']) {
				update_post_meta($object->get_id(), 'name_custom_imdb_rating', $data['movie_rating']);
			}
		}

		public function streamit_add_csv_mapping_options($options, $item)
		{
			$options['movie_trailer_link'] = __('Movie Trailer Link', 'streamit');
			$options['movie_rating'] = __('Movie Rating', 'streamit');
			return $options;
		}

		public function streamit_tv_show_episode_label()
		{
			masvideos_wp_text_input(
				array(
					'id'            => '_episode_label',
					'value'         => get_post_meta(get_the_ID(), '_episode_label', true),
					'label'         => __('Episode Label', 'streamit'),
					'description'   => __('Enter the episode label.', 'streamit'),
				)
			);
		}

		public function streamit_episode_label()
		{
			update_post_meta(get_the_ID(), '_episode_label', $_POST['_episode_label'] ?? '');
		}
	}
