<?php

/**
 * Streamit\Utility\Actions\Component class
 *
 * @package streamit
 */

namespace Streamit\Utility\Layouts;

use Elementor\Plugin;
use Streamit\Utility\Component_Interface;
use Streamit\Utility\Templating_Component_Interface;

/**
 * Class for managing comments UI.
 *
 * Exposes template tags:
 * * `streamit()->the_comments( array $args = array() )`
 *
 * @link https://wordpress.org/plugins/amp/
 */

class Component implements Component_Interface, Templating_Component_Interface
{
	/**
	 * Gets the unique identifier for the theme component.
	 *
	 * @return string Component slug.
	 */

	public function get_slug(): string
	{
		return 'layouts';
	}

	public function initialize()
	{
		add_action('manage_posts_extra_tablenav', array($this, 'add_layout_navigation'));
	}

	/**
	 * Gets template tags to expose as methods on the Template_Tags class instance, accessible through `streamit()`.
	 *
	 * @return array Associative array of $method_name => $callback_info pairs. Each $callback_info must either be
	 *               a callable or an array with key 'callable'. This approach is used to reserve the possibility of
	 *               adding support for further arguments in the future.
	 */

	public function template_tags(): array
	{
		return array(
			'streamit_get_layout_content' => array($this, 'streamit_get_layout_content'),
		);
	}

	/**
	 * It returns the content of a layout with changable layout dropdown on edit with elementor 
	 * 
	 * @param id The ID of the layout you want to get the content for.
	 * 
	 * @return The content of the layout.
	 */

	public function streamit_get_layout_content($id)
	{
		if (!class_exists("Elementor\Plugin"))
			return false;

		$content = Plugin::instance()->frontend->get_builder_content_for_display($id);

		if (!isset($_REQUEST['elementor-preview']))
			return $content;

		ob_start(); ?>

		<div class="layout-editor-wrapper">
			<?php echo $content;
			do_action('iqonic_hf_layout/editor/layout_content_after', $id); ?>
		</div>
		<?php return ob_get_clean();
	}

	//layout admin navigation
	function add_layout_navigation($where)
	{
		global $post, $post_type_object;

		if ($post_type_object->name === 'iqonic_hf_layout' && $where == "top" && $post) { ?>
			<div class="alignleft action">
				<a target="_blank" href="<?php echo esc_url(admin_url("admin.php?page=_streamit_options&tab=6")); ?> " class="button">
					<?php echo esc_html__("Setup header layout", "streamit"); ?>
				</a>
				<a target="_blank" href="<?php echo esc_url(admin_url("admin.php?page=_streamit_options&tab=13")); ?> " class="button">
					<?php echo esc_html__("Setup footer layout", "streamit"); ?>
				</a>
				<a target="_blank" href="<?php echo esc_url(admin_url('nav-menus.php')); ?>'" class="button">
					<?php echo esc_html__("Setup menu layout", "streamit"); ?>
				</a>
				<a target="_blank" href="<?php echo esc_url(admin_url("admin.php?page=_streamit_options&tab=41")); ?> " class="button">
					<?php echo esc_html__("Setup 404 page layout", "streamit"); ?>
				</a>
			</div>
<?php
		}
	}
}
