<?php

/**
 * Streamit\Utility\Custom_Helper\Helpers\Common class
 *
 * @package streamit
 */

namespace Streamit\Utility\Helper\Options;

use function add_action;
use function Streamit\Utility\streamit;
use Streamit\Utility\Helper\Component;

class Notification extends Component
{
    public function __construct()
    {
        add_action('transition_post_status', [$this, 'streamit_notification_module'], 10, 3);

        add_action('wp_ajax_streamit_notification_data', [$this, 'streamit_notification_data']);
        add_action('wp_ajax_nopriv_streamit_notification_data', [$this, 'streamit_notification_data']);

        add_action("user_register", [$this, 'streamit_add_notification_for_new_user']);
    }

    public function streamit_notification_module($new_status, $old_status, $post)
    {
        $post_id    = $post->ID;
        $post_type  = $post->post_type;
        $users      = get_users(array('fields' => array('ID')));
        
        if (!in_array(get_post_type($post), ['movie', 'tv_show', 'video', 'episode'])) return;

        if ($new_status == 'publish' && $old_status != 'publish') {

            $new_notification_data = [
                'post_id'   => $post_id,
                'post_type' => $post_type,
                'is_seen'   => false,
            ];

            foreach ($users as $key => $user) {
                $user_id                    = $user->id;
                $stored_notification_data   = get_user_meta($user_id, '_streamit_notification', true);

                if (is_array(($stored_notification_data)) && !empty($stored_notification_data['_streamit_newly_added'])) {
                    if ($post_id !== $stored_notification_data['_streamit_newly_added'][$key]['post_id']) {
                        array_push($stored_notification_data['_streamit_newly_added'], $new_notification_data);
                        update_user_meta($user_id, '_streamit_notification', $stored_notification_data);
                    }
                } else {  //when meta_key _streamit_notification does not exists, than creates it
                    update_user_meta($user_id, '_streamit_notification', array(
                        '_streamit_newly_added' => [
                            $new_notification_data
                        ]
                    ));
                }
            }
        }
    }

    public function streamit_notification_data()
    {
        global $streamit_options;

        $count                      = 1;
        $guest_user_notification    = $streamit_options['enable_guest_user_notification'] == "yes";

        if (!is_user_logged_in() && $guest_user_notification) {
            $admin_user = get_users(['role' => "administrator"]);
            $user_id    = ($admin_user) ? $admin_user[0]->ID : false;
        } else {
            $user_id = get_current_user_id();
        }

        $notifications  = get_user_meta($user_id, '_streamit_notification', true);
        $post_types     = apply_filters('streamit_notification_post_type', array('movie', 'tv_show', 'video', 'episode'));

        if ($notifications) {
            $newly_added_post_ids = array();
            foreach ($notifications['_streamit_newly_added'] as $key => $value) {
                if (isset($value['is_seen']) && $value['is_seen'] === false)
                    $newly_added_post_ids[] = $value['post_id'];
            }

            if (!empty($newly_added_post_ids)) {
                $args = array(
                    'post_type'         => $post_types,
                    'post_status'       => 'publish',
                    'posts_per_page'    => -1,
                    'post__in'          => $newly_added_post_ids,
                    'order'             => 'DESC',
                    'date_query'        => array(
                        array(
                            'after'     => '15 days ago', // Show posts published after the last 15 days
                            'inclusive' => true,          // Include the posts published on the 15th day ago
                        ),
                    )
                );

                $wp_query = new \WP_Query($args);

                $notification_count = $wp_query->post_count;
                $notification_count = ($notification_count > 10) ? "9+" : $notification_count;

                if ($wp_query->have_posts()) { ?>
                    <div class="streamit_notification_wrapper notification-close" data-notification_count=<?php echo esc_attr($notification_count); ?>>
                        <h5 class="title">
                            <?php echo esc_html($streamit_options['notification_label']); ?>
                        </h5>

                        <div class="notifications_meta_data">
                            <?php while ($wp_query->have_posts()) {
                                $wp_query->the_post();

                                if (!empty($streamit_options['notification_page']))
                                    if ($count > 5) break;

                                $post_id        = get_the_ID();
                                $post_type      = get_post_type();

                                $thumbnail_id   = get_post_meta($post_id, '_thumbnail_id', true);
                                $run_time       = get_post_meta($post_id, '_' . $post_type . '_run_time', true);

                                $src = $thumbnail_id ? wp_get_attachment_url($thumbnail_id) : get_lazy_load_image(); ?>

                                <div class="notification_post_details">
                                    <div class="img-box">
                                        <a href="<?php echo get_the_permalink() ?>">
                                            <img src="<?php echo esc_attr($src) ?>" alt="<?php echo esc_attr__("img", "streamit") ?>">
                                        </a>
                                    </div>

                                    <div class="meta_data">
                                        <div class="post-name">
                                            <a href="<?php echo get_the_permalink() ?>">
                                                <?php echo get_the_title() ?>
                                            </a>
                                        </div>

                                        <div class="run_time"><?php echo esc_html($run_time) ?></div>

                                        <div class="imdb_rating">
                                            <?php streamit()->streamit_display_imdb_rating($post_id, false) ?>
                                        </div>
                                    </div>
                                </div>
                            <?php if (!empty($streamit_options['notification_page']))
                                    $count++;
                            } ?>
                        </div>

                        <?php if ($count > 5 && isset($streamit_options['notification_page']) && !empty($streamit_options['notification_page'])) { ?>
                            <a class="view-more" href="<?php echo esc_url(get_page_link($streamit_options['notification_page'])) ?>" target="_blank">
                                <button type="submit" class="hover-buttons btn w-100">
                                    <?php echo esc_html__("View All", "streamit") ?>
                                </button>
                            </a>
                        <?php } ?>
                    </div>
<?php
                } else {
                    $this->streamit_notification_not_found();
                }
            }
        } else {
            $this->streamit_notification_not_found();
        }
        wp_reset_postdata();
        die;
    }


    function streamit_notification_not_found()
    {
        echo
        '<div class="streamit_notification_wrapper notification-close">
            <span class="no_notification"> ' . esc_html__("No Notifications Found", "streamit") . ' </span>
        </div>';
    }

    function streamit_add_notification_for_new_user($user_id)
    {
        $count            = 0;
        $notifications  = get_user_meta(1, '_streamit_notification', true);
        $post_types     = apply_filters('streamit_notification_post_type', array('movie', 'tv_show', 'video', 'episode'));

        if ($notifications) {
            $newly_added_post_ids = array();
            foreach ($notifications['_streamit_newly_added'] as $key => $value) {
                $newly_added_post_ids[] = $value['post_id'];
            }

            if (!empty($newly_added_post_ids)) {
                $args = array(
                    'post_type'     => $post_types,
                    'post_status'   => 'publish',
                    'post__in'      => $newly_added_post_ids,
                    'order'         => 'DESC',
                    'date_query'    => array(
                        array(
                            'after'     => '15 days ago', // Show posts published after the last 15 days
                            'inclusive' => true,          // Include the posts published on the 15th day ago
                        ),
                    )
                );

                $wp_query = new \WP_Query($args);

                if ($wp_query->have_posts()) {
                    while ($wp_query->have_posts()) {
                        $wp_query->the_post();

                        $post_id     = get_the_ID();
                        $post_type   = get_post_type();

                        $new_notification_data = [
                            'post_id'   => $post_id,
                            'post_type' => $post_type,
                            'is_seen'   => false,
                        ];

                        $stored_notification_data = get_user_meta($user_id, '_streamit_notification', true);

                        if (is_array(($stored_notification_data)) && !empty($stored_notification_data['_streamit_newly_added'])) {
                            if ($post_id !== $stored_notification_data['_streamit_newly_added'][$count]['post_id']) {
                                array_push($stored_notification_data['_streamit_newly_added'], $new_notification_data);
                                update_user_meta($user_id, '_streamit_notification', $stored_notification_data);
                            }
                        } else {  //when meta_key _streamit_notification does not exists, than creates it
                            update_user_meta($user_id, '_streamit_notification', array(
                                '_streamit_newly_added' => [
                                    $new_notification_data
                                ]
                            ));
                        }

                        $count++;
                    }
                }
            }
        }
    }
}
