<?php

/**
 * Streamit\Utility\Custom_Helper\Helpers\Common class
 *
 * @package streamit
 */

namespace Streamit\Utility\Helper\Options;

use Streamit\Utility\Helper\Component;
use function add_action;
use function Streamit\Utility\streamit;

class ContinueWatching extends Component
{

    public function __construct()
    {

        add_action('wp_enqueue_scripts', [$this, 'streamit_enqueue_styles'], 999);

        add_action('wp_ajax_streamit_update_watched', [$this, 'streamit_continue_watch_handler']);
        add_action('wp_ajax_nopriv_streamit_update_watched', [$this, 'streamit_continue_watch_handler']);

        // streamit_delete_watched
        add_action('wp_ajax_streamit_delete_watched', [$this, 'streamit_delete_watched_handler']);
        add_action('wp_ajax_nopriv_streamit_delete_watched', [$this, 'streamit_delete_watched_handler']);

        is_user_logged_in() && add_action('iqonic_extension_start_inner_content', function ($postID, $runTime) {
            $watchedTime = get_user_meta(get_current_user_id(), '_watch_content', true);
            $watchedTimeStyleVar = $watchedTime ? "--complated-video:" . $watchedTime . "%" : ''; ?>
            <span class="continue-watch" style="<?php echo esc_attr($watchedTimeStyleVar) ?>"> </span>
        <?php
        }, 10, 2);

        add_action('wp', [$this, 'streamit_episode_seasons_data']);

        add_shortcode('streamit_continue_watching_slider', [$this, 'streamit_continue_watching_slider'], 10, 2);

        add_action('streamit_before_episode_template', function ($contentID) {
            if (!is_user_logged_in() || empty(get_user_meta(get_current_user_id(), '_user_watched_episode_' . $contentID, true))) {
                return;
            } ?>
            <span class="streamit-watched-episode"><?php esc_html_e('watched', 'streamit'); ?></span>
<?php
        });
    }

    function streamit_enqueue_styles()
    {
        if (is_user_logged_in() && is_singular(apply_filters('streamit-continue_watch_post_type', array('movie', 'episode', 'video')))) {

            wp_register_script('streamit-continue-watch', get_template_directory_uri() . '/assets/js/continue-watch.min.js',  array('jquery', 'wp-i18n'), streamit()->get_version(), true);
            $watchedMeta = (array) json_decode(get_user_meta(get_current_user_id(), '_watch_content', true));

            $translation_array = array(
                'ID' => get_the_ID(),
                'nonce' => wp_create_nonce('ajax-nonce'),
                "resume_btn" => __("Resume", 'streamit'),
                "cancle_btn" => __("No Thanks", 'streamit'),
                'desc' => __("Resume from where you left off?", 'streamit')
            );
            if (isset($watchedMeta[get_the_ID()])) {
                $translation_array['watchedTime'] = $watchedMeta[get_the_ID()];
            }
            wp_localize_script('streamit-continue-watch', 'streamit_continue_watch', $translation_array);
            wp_enqueue_script('streamit-continue-watch');
        }
        wp_enqueue_script('streamit-customization', get_template_directory_uri() . '/assets/js/customization.min.js',  array('jquery'), streamit()->get_version(), true);
    }

    function streamit_continue_watch_handler()
    {
        if (!wp_verify_nonce($_GET['nonce'], 'ajax-nonce')) {
            die('Busted!');
        }
        $postID                 = $_GET['postID'];
        $watchedTime            = $_GET['watchedTime'];
        $watchedTotalTime       = $_GET['watchedTotalTime'];
        $watchedTimePercentage  = $_GET['watchedTimePercentage'];

        $watchedMeta = (array) json_decode(get_user_meta(get_current_user_id(), '_watch_content', true));

        $watchedMeta[$postID] = array('watchedTime' => $watchedTime, 'watchedTotalTime' => $watchedTotalTime, 'watchedTimePercentage' => $watchedTimePercentage);

        // Swap To First
        $temp = $watchedMeta[$postID];
        unset($watchedMeta[$postID]);
        $watchedMeta[$postID] = $temp;

        update_user_meta(get_current_user_id(), '_watch_content', json_encode($watchedMeta));
        die;
    }

    function streamit_delete_watched_handler()
    {
        if (!wp_verify_nonce($_GET['nonce'], 'ajax-nonce')) {
            die('Busted!');
        }
        $postID = $_GET['postID'];

        $watchedMeta = (array) json_decode(get_user_meta(get_current_user_id(), '_watch_content', true));
        unset($watchedMeta[$postID]);

        add_user_meta(get_current_user_id(), '_user_watched_episode_' . $postID, true);

        update_user_meta(get_current_user_id(), '_watch_content', json_encode($watchedMeta));
        die;
    }

    function streamit_episode_seasons_data()
    {
        if (!is_singular('episode'))
            return;

        $id = get_queried_object_id();

        $tvShowID = get_post_meta($id, '_tv_show_id', true);
        $season_data = get_post_meta($tvShowID, '_seasons', true);

        if (!is_array($season_data)) {
            return;
        }

        $seasons = array_map(function ($episode_season) {
            return array_map(function ($episode) {
                return $episode;
            }, $episode_season['episodes']);
        }, $season_data);

        $nextEpisode = false;
        foreach ($seasons as $key => $episodes) {
            // if (!empty($episodes)) {
            if (!empty($episodes[array_search((int)$id, $episodes)+1])) {
                $nextEpisode = array_search((int)$id, $episodes);
                if (isset($episodes[$nextEpisode + 1])) {
                    $nextEpisode =    $episodes[$nextEpisode + 1];
                    break;
                }
            }
        }
        if ($nextEpisode === false)
            return;
        wp_register_script('streamit-upcoming-episode', get_template_directory_uri() . '/assets/js/single-episode.min.js',  array('jquery'), streamit()->get_version(), true);

        $translation_array = array(
            'nextEpisodeID' => $nextEpisode,
            'nextEpisodeLink' => get_permalink($nextEpisode),
            'nextEpisodeThumbnail' => get_the_post_thumbnail_url($nextEpisode, 'thumbnail'),
            'nextEpisodeName' => get_the_title($nextEpisode),
        );

        wp_localize_script('streamit-upcoming-episode', 'streamit_upcoming_episode', $translation_array);
        wp_enqueue_script('streamit-upcoming-episode');
    }

    function streamit_continue_watching_slider($attr, $children)
    {
        $arr = shortcode_atts(
            array(
                'style'     => '1',
                'lazy_load' => ''
            ),
            $attr
        );

        $watchedMeta = (array) json_decode(get_user_meta(get_current_user_id(), '_watch_content', true));
        if (!is_user_logged_in() || empty($watchedMeta))
            return;
        $post_ids = array_reverse(array_keys($watchedMeta));
        foreach ($post_ids as $post_id) {
            get_template_part('template-parts/continue_watching/slider_content', '', array('contentID' => $post_id, 'Watchmeta' => $watchedMeta[$post_id], 'style' => $arr['style'], 'lazy_load' => $arr['lazy_load']));
        }
    }
}
