<?php

/**
 * Streamit\Utility\Helper\Component class
 *
 * @package streamit
 */

namespace Streamit\Utility\Helper\Masvideo_Helper;

use MasVideos_Movie;
use MasVideos_Video;
use MasVideos_TV_Show;

use function Streamit\Utility\streamit;
use Streamit\Utility\Component_Interface;
use Streamit\Utility\Templating_Component_Interface;

class Component implements Component_Interface, Templating_Component_Interface
{
    public function get_slug(): string
    {
        return 'masvideo';
    }

    public function initialize()
    {
    }

    public function template_tags(): array
    {
        return array(
            'streamit_display_ulike' => array($this, 'streamit_display_ulike'),
            'streamit_display_social_icons'   => array($this, 'streamit_display_social_icons'),
            'streamit_display_watchlist'      => array($this, 'streamit_display_watchlist'),
            'streamit_show_counter'           => array($this, 'streamit_show_counter'),
            'streamit_display_imdb_rating'    => array($this, 'streamit_display_imdb_rating'),
            'streamit_display_upcoming'       => array($this, 'streamit_display_upcoming'),
            'streamit_get_icons_list'         => array($this, 'streamit_get_icons_list'),
            'streamit_display_genre'          => array($this, 'streamit_display_genre'),
            'streamit_display_tags'           => array($this, 'streamit_display_tags'),
            'streamit_is_post_restricted'     => array($this, 'streamit_is_post_restricted'),
            'streamit_cast_and_crew'          => array($this, 'streamit_cast_and_crew'),
            'streamit_related_product'        => array($this, 'streamit_related_product'),
            'streamit_video_playbtn'          => array($this, 'streamit_video_playbtn'),
            'streamit_gallery'                => array($this, 'streamit_gallery'),
        );
    }

    public function streamit_is_post_restricted($post_id)
    {
        global $streamit_options;

        if (isset($streamit_options['streamit_restriction_priority']) && $streamit_options['streamit_restriction_priority'] == "pmp") {
            $is_restricted = function_exists('pmpro_has_membership_access') && pmpro_has_membership_access($post_id) === false ? true : false;
        } else {
            $is_restricted = (function_exists('pms_is_post_restricted') && pms_is_post_restricted($post_id));
        }

        return $is_restricted;
    }

    public function streamit_display_ulike($post_id)
    {
        global $streamit_options;

        $streamit_display_like = class_exists('WpUlikeInit') && isset($streamit_options['streamit_display_like']) && $streamit_options['streamit_display_like'] == 'yes' ? true : false;
        if (!$streamit_display_like) return;

        echo '<li>';
        echo '<div class="iq-like-btn">';
        echo do_shortcode('[wp_ulike for="movie" id="' . esc_attr($post_id) . '" style="wpulike-heart"]');
        echo '</div>';
        echo '</li>';
    }

    public function streamit_display_social_icons($post_id)
    {
        global $streamit_options;

        $streamit_display_social_icons = isset($streamit_options['streamit_display_social_icons']) && $streamit_options['streamit_display_social_icons'] == 'yes' ? true : false;
        if (!$streamit_display_social_icons) return;

        $permalink = get_post_permalink($post_id);
        $title = get_the_title($post_id); ?>

        <li class="share">
            <span><i class="fas fa-share-alt"></i></span>

            <div class="share-wrapper">
                <div class="share-box">
                    <svg width="15" height="40" viewBox="0 0 15 40" class="share-shape" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.8842 40C6.82983 37.2868 1 29.3582 1 20C1 10.6418 6.82983 2.71323 14.8842 0H0V40H14.8842Z" fill="#191919" />
                    </svg>

                    <div class="d-flex align-items-center justify-content-center">
                        <a href="https://www.facebook.com/sharer?u=<?php echo esc_url($permalink); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="fab fa-facebook-f"></i></a>
                        <a href="http://twitter.com/intent/tweet?text=<?php echo esc_html($title); ?>&url=<?php echo esc_url($permalink); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="fab fa-twitter"></i></a>
                        <a href="#" data-link='<?php echo esc_url($permalink); ?>' class="share-ico iq-copy-link"><i class="fas fa-link"></i></a>
                    </div>
                </div>
            </div>
        </li>
    <?php
    }

    public function streamit_display_watchlist($post_id)
    {
        global $streamit_options;

        $streamit_display_watchlist = array_key_exists('streamit_display_watchlist', $streamit_options) && $streamit_options['streamit_display_watchlist'] == "yes";
        if (!$streamit_display_watchlist) return; ?>

        <li>
            <?php if (!is_user_logged_in()) {
                if (array_key_exists('streamit_signin_link', $streamit_options)) {
                    $streamit_signin_link = get_page_link($streamit_options['streamit_signin_link']); ?>
                    <a class="watch-list-not" href="<?php echo esc_url($streamit_signin_link) ?>">
                        <span><i class="fas fa-plus"></i></span>
                    </a>
                <?php }
            } else { ?>
                <a class="watch-list" rel="<?php echo esc_attr($post_id); ?>">
                    <?php if (function_exists('add_to_watchlist')) echo add_to_watchlist($post_id); ?>
                </a>
            <?php
            } ?>
        </li>
    <?php
    }

    public function streamit_show_counter($class = 'trending-year single-view-count')
    {
        global $streamit_options;

        $show_counter = (array_key_exists('streamit_show_viewcounter', $streamit_options) && $streamit_options['streamit_show_viewcounter'] == 'yes');
        if (!$show_counter) return; ?>

        <span class="<?php echo esc_attr($class) ?>">
            <?php
            if (function_exists('set_post_view')) {
                echo '<i class="fas fa-eye"></i>';
                if (get_post_view() == 0)
                    echo esc_html__('0 views', 'streamit');
                else
                    echo get_post_view();
            } ?>
        </span>
        <?php
    }

    public function streamit_display_imdb_rating($post_id, $display_star = true)
    {
        global $streamit_options;

        $post_imdb_rating = get_post_meta($post_id, 'name_custom_imdb_rating', true);
        if (!$post_imdb_rating) return;

        $display_rating = isset($streamit_options['streamit_imdb_display_rating']) && $streamit_options['streamit_imdb_display_rating'] == 'yes' ? true : false;

        if (isset($post_imdb_rating) && $display_rating) {
            if (isset($streamit_options['streamit_display_single_star']) && !empty($streamit_options['streamit_display_single_star'])) {
                $imdb_rating = $post_imdb_rating;
            }
        } else {
            $imdb_rating = floatval($post_imdb_rating) / 2;
        }

        if (isset($imdb_rating) && !empty($imdb_rating)) { ?>
            <div class="slider-ratting d-flex align-items-center ml-0 mt-0">
                <?php if ($display_star) { ?>
                    <ul class="ratting-start p-0 m-0 list-inline text-primary d-flex align-items-center justify-content-left">
                        <?php
                        if ($display_rating && $streamit_options['streamit_display_single_star'] == 'yes') { ?>
                            <li><i class="fas fa-star" aria-hidden="true"></i></li>
                            <?php
                        } else {
                            for ($i = 1; $i <= ceil($imdb_rating); $i++) {
                                if (($imdb_rating - floor($imdb_rating)) > 0 && $i == ceil($imdb_rating)) { ?>
                                    <li><i class="fas fa-star-half" aria-hidden="true"></i></li>
                                <?php continue;
                                } ?>
                                <li><i class="fas fa-star" aria-hidden="true"></i></li>
                        <?php
                            }
                        } ?>
                    </ul>
                <?php } ?>

                <span class="rating-text ml-2">
                    <?php echo esc_html(round($imdb_rating, 1)); ?>
                </span>

                <?php
                if (isset($streamit_options['streamit_imdb_display_logo']) && $streamit_options['streamit_imdb_display_logo'] == "yes" && !empty($streamit_options['streamit_imdb_logo']['url'])) {
                    $imdb_logo = $streamit_options['streamit_imdb_logo']['url']; ?>
                    <span class="imdb-logo ml-2">
                        <img src="<?php echo esc_url($imdb_logo); ?>" alt="<?php esc_attr_e('imdb_logo', 'streamit') ?>">
                    </span>
                <?php
                } else { ?>
                    <span class="imdb-text">
                        <?php echo esc_html__(" (Imdb)", "streamit"); ?>
                    </span>
                <?php
                } ?>
            </div>
        <?php }
    }

    public function streamit_display_upcoming($post_type)
    {
        global $streamit_options;

        $is_ajax_enable                     = true;
        $lazy_load                          = $is_ajax_enable ? " iqonic-lazy-load-images" : '';
        $streamit_upcoming_multi_select     = in_array($post_type, $streamit_options['streamit_upcoming_multi_select']) ? true : false;
        $streamit_display_upcoming_movies   = isset($streamit_options['streamit_display_upcoming']) && $streamit_options['streamit_display_upcoming'] == 'yes' ? true : false;
        $show_title                         = isset($streamit_options['streamit_upcoming_movie_enable_title']) && $streamit_options['streamit_upcoming_movie_enable_title'] == "yes" ? true : false;
        $is_badges_enable                   = isset($streamit_options['streamit_upcoming_movie_enable_premium_badges']) && $streamit_options['streamit_upcoming_movie_enable_premium_badges'] == "yes" ? true : false;
        $upcoming_movie_cards_style         = isset($streamit_options['streamit_upcoming_movie_cards_style']) && !empty($streamit_options['streamit_upcoming_movie_cards_style']) ? $streamit_options['streamit_upcoming_movie_cards_style'] : '1';

        if (!$streamit_display_upcoming_movies || !$streamit_upcoming_multi_select) return;

        if ($post_type == "movie") {
            $upcoming_type          = "streamit_upcoming_movies_all";
            $upcomig_selected_type  = 'streamit_upcoming_movies_selected';
        } else {
            $upcoming_type          = "streamit_upcoming_videos_all";
            $upcomig_selected_type  = 'streamit_upcoming_videos_selected';
        }

        $streamit_upcoming_type = $streamit_options[$upcoming_type];
        $play_btn_text = isset($streamit_options['streamit_play_btn_text']) && !empty($streamit_options['streamit_play_btn_text']) ? $streamit_options['streamit_play_btn_text'] : 'Play Now';

        $upcoming_title = $streamit_options['streamit_upcoming_title'];

        $args = array(
            'post_type'     => $post_type,
            'post_status'   => 'publish',
            'fields'        => 'ids'
        );

        if ($streamit_upcoming_type == 'selected') {
            $selected_upcoming_movies = isset($streamit_options[$upcomig_selected_type]) ? $streamit_options[$upcomig_selected_type] : array();
            $args['post__in'] = $selected_upcoming_movies;
        }

        if ($streamit_upcoming_type == 'all') {
            $args['posts_per_page'] = -1;
            $args['meta_query'] = array(
                array(
                    'key'     => 'name_upcoming',
                    'value'   => '"yes"',
                    'compare' => 'LIKE'
                )
            );
        }

        $upcoming_movie = new \WP_Query($args);
        $post_ids       = $upcoming_movie->posts;

        $is_rtl = $upcoming_movie->post_count > 4 ? esc_attr__('iq-rtl-direction ', 'streamit') : '';

        if ($upcoming_movie->have_posts()) { ?>
            <div id="iq-upcoming-movie" class="<?php esc_attr($is_rtl); ?> <?php echo esc_attr($lazy_load); ?>">

                <?php if (!is_page_template('streamit-full-width.php')) echo '<div class="container-fluid">'; ?>

                <div class="row m-0">
                    <div class="col-sm-12 overflow-hidden p-0">
                        <div class="iq-main-header d-flex align-items-center justify-content-between iq-ltr-direction">
                            <h4 class="main-title">
                                <?php
                                if (!empty($upcoming_title))
                                    echo esc_html($upcoming_title);
                                else
                                    echo esc_html__('Upcoming Movies', 'streamit'); ?>
                            </h4>
                        </div>

                        <?php if ($upcoming_movie_cards_style == "2") {
                            $class = "iq-card-wrapper";
                            wp_enqueue_style("cards-general", STREAMIT_EXTENSION_PLUGIN_URL . 'includes/Elementor/assets/css/cards-general.css');
                        } else {
                            $class = "upcoming-contens";
                        } ?>

                        <div class="iq-rtl-direction <?php echo esc_attr($class); ?>">
                            <ul class="inner-slider list-inline row p-0 mb-0">
                                <?php $col = '';
                                $is_grid = false;
                                $settings['play_now_text'] = $play_btn_text;
                                $settings['image_style']   = "portrait";

                                foreach ($post_ids as $post_id) {
                                    if ($post_type == "movie") :
                                        if ($upcoming_movie_cards_style == "2")
                                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Cards/template.php';
                                        else
                                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Slider/template.php';
                                    endif;

                                    if ($post_type == "video") :
                                        if ($upcoming_movie_cards_style == "2")
                                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Cards/template.php';
                                        else
                                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Slider/template.php';
                                    endif;
                                } ?>
                            </ul>
                        </div>
                    </div>
                </div>

                <?php if (!is_page_template('streamit-full-width.php')) echo '</div>'; ?>
            </div>
        <?php
        }
        wp_reset_postdata();
    }

    public function streamit_get_icons_list($post_id)
    {
        global $streamit_options;

        $is_restricted              = (function_exists('pmpro_has_membership_access') && pmpro_has_membership_access($post_id) === false) ? true : false;
        $streamit_display_playlist  = array_key_exists('streamit_display_playlist', $streamit_options) && $streamit_options['streamit_display_playlist'] == "yes";

        if ($is_restricted === false) {
            $is_restricted = (function_exists('pms_is_post_restricted') && pms_is_post_restricted($post_id));
        } ?>

        <ul class="list-inline p-0 m-0 share-icons music-play-lists single-share-icon">
            <?php
            streamit()->streamit_display_social_icons($post_id); //Display social media icons for sharing

            streamit()->streamit_display_ulike($post_id); //Display Like Button

            streamit()->streamit_display_watchlist($post_id); //Display Watchlist Button

            // hide/show download button
            if (get_post_type() != "tv_show") {
                $download_btn = get_post_meta($post_id, 'download_btn', true);

                $display_download           = isset($streamit_options['streamit_display_download']) && $streamit_options['streamit_display_download'] == 'yes';
                $display_download_on_item   = isset($streamit_options['streamit_display_download_on_item']) && in_array(get_post_type(), $streamit_options['streamit_display_download_on_item']);
                $show_download_btn          = ($download_btn == 'link' && !empty(get_post_meta($post_id, 'dwn_link', true))) || $download_btn == 'upload' && !empty(get_post_meta($post_id, 'upload_item', true));

                if ($show_download_btn && $display_download && $display_download_on_item) { ?>
                    <li class="download-icon">
                        <?php if ($is_restricted) { ?>
                            <div class="restrict-box">
                                <p> <?php streamit()->streamit_get_restricted_content($post_id); ?> </p>
                            </div>

                            <button type="submit" class="iq-like-btn"><i class="fas fa-download"></i></button>
                        <?php } else { ?>
                            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')) ?>">
                                <input type="hidden" name="action" value="streamit_download">
                                <input type="hidden" name="download" value="<?php echo base64_encode($post_id) ?>">
                                <button type="submit" class="iq-like-btn">
                                    <i class="fas fa-download"></i>
                                </button>
                            </form>
                        <?php } ?>
                    </li>
                <?php
                }
            }

            if ($streamit_display_playlist && get_post_type() != "episode") { ?>
                <li class="streamit-playlist-wrapper">
                    <?php do_shortcode('[iqonic_playlist]'); ?>
                </li>
            <?php }

            do_action('streamit_content_button_at_last', $post_id); ?>
        </ul>
        <?php
    }

    public function streamit_display_genre($post_id, $term_name)
    {
        echo '<ul class="p-0 mt-2 list-inline d-flex flex-wrap align-items-center movie-content movie-space-action">';
        $wp_object = wp_get_post_terms($post_id, $term_name);
        if (!empty($wp_object)) {
            foreach ($wp_object as $val) {
                if ($val->parent == 0) { ?>
                    <li class="text-primary">
                        <a href="<?php echo get_tag_link($val->term_id) ?>">
                            <?php echo esc_html($val->name) ?>
                        </a>
                    </li>
            <?php
                }
            }
        }
        echo '</ul>';
    }

    public function streamit_display_tags($post_id, $tag_name)
    {
        global $streamit_options;

        $tags = wp_get_post_terms($post_id, $tag_name);
        if ($streamit_options['streamit_display_tag'] == 'yes' && isset($tags)) { ?>
            <ul class="p-0 list-inline d-flex flex-wrap align-items-center movie-content movie-space-action iq_tag-list">
                <?php if (!empty($tags)) { ?>
                    <li class="text-primary text-lable"><i class="fas fa-tags" aria-hidden="true"></i><?php esc_html_e('Tags:', 'streamit'); ?></li>
                    <?php foreach ($tags as $val) { ?>
                        <li>
                            <a href="<?php echo get_tag_link($val->term_id) ?>">
                                <?php echo esc_html($val->name) ?>
                            </a>
                        </li>
                <?php
                    }
                } ?>
            </ul>
        <?php
        }
    }

    public function streamit_cast_and_crew($section_classes = 'container-fluid')
    {
        global $post, $streamit_options;
        $post_type = $post->post_type;

        if ($post_type == "tv_show") {
            $content = new MasVideos_TV_Show($post->ID);
        } elseif ($post_type == "video") {
            $content = new MasVideos_Video($post->ID);
        } else {
            $content = new MasVideos_Movie($post->ID);
        }

        if (!is_object($content)) return;

        $tabs = array();

        // Cast tab - shows movie content.
        if ($content && !empty($content->get_cast())) {
            $tabs['cast'] = array(
                'title'     => isset($streamit_options['streamit_cast_title']) && !empty($streamit_options['streamit_cast_title']) ? $streamit_options['streamit_cast_title'] : esc_html__('Cast', 'streamit'),
                'callback'  => array($this, 'streamit_single_movie_cast_tab'),
                'priority'  => 10
            );
        }
        // Crew tab - shows movie content.
        if ($content && !empty($content->get_crew())) {
            $tabs['crew'] = array(
                'title'     => isset($streamit_options['streamit_crew_title']) && !empty($streamit_options['streamit_crew_title']) ? $streamit_options['streamit_crew_title'] : esc_html__('Crew', 'streamit'),
                'callback'  => array($this, 'streamit_single_movie_crew_tab'),
                'priority'  => 20
            );
        }
        if (!empty($tabs)) {
            get_template_part('template-parts/global/tabs', '', array('tabs' => $tabs, 'class' => $section_classes));
        }
    }

    public function streamit_single_movie_cast_tab($a, $b)
    {
        global $post, $streamit_options;
        $post_type = $post->post_type;

        if ($post_type == "tv_show") {
            $content = new MasVideos_TV_Show($post->ID);
        } elseif ($post_type == "video") {
            $content = new MasVideos_Video($post->ID);
        } else {
            $content = new MasVideos_Movie($post->ID);
        }

        if (!is_object($content)) return;

        $casts = $content->get_cast();

        if (!empty($casts)) { ?>
            <div id="iq-movie-cast" class="iq-favorites s-margin detail-cast-list iq-card-wrapper">
                <div class="row m-0">
                    <div class="col-sm-12 overflow-hidden p-0">
                        <div class="favorites-contens  iq-smovie-slider ">
                            <ul class="inner-slider list-inline row p-0 mb-0 ">
                                <?php foreach ($casts as $cast) { ?>
                                    <li class="slide-item ">
                                        <?php get_template_part('template-parts/cast_crew/cast', '', array('cast' => $cast)); ?>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        }
    }

    public function streamit_single_movie_crew_tab($a, $b)
    {
        global $post, $streamit_options;
        $post_type = $post->post_type;

        if ($post_type == "tv_show") {
            $content = new MasVideos_TV_Show($post->ID);
        } elseif ($post_type == "video") {
            $content = new MasVideos_Video($post->ID);
        } else {
            $content = new MasVideos_Movie($post->ID);
        }

        if (!is_object($content)) return;

        $casts = $content->get_crew();

        if (!empty($casts)) { ?>
            <div id="iq-movie-crew" class="iq-favorites s-margin detail-cast-list ">
                <div class="row m-0">
                    <div class="col-sm-12 overflow-hidden p-0">

                        <div class="favorites-contens  iq-smovie-slider ">
                            <ul class="inner-slider list-inline row p-0 mb-0 ">
                                <?php foreach ($casts as $cast) { ?>
                                    <li class="slide-item  ">
                                        <?php get_template_part('template-parts/cast_crew/crew', '', array('cast' => $cast)); ?>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        <?php  }
    }

    public function streamit_related_product($post_id, $show_related_product, $title, $post_type_to_show_related_product)
    {
        if (!class_exists("WooCommerce")) return;

        $products = get_post_meta($post_id, 'related_product', true);
        if (empty($products) ||  $show_related_product != 'yes' || !in_array(get_post_type(), $post_type_to_show_related_product)) {
            return;
        }

        $array = array();

        foreach ($products as $item) {
            $array[] = wc_get_product($item);
        }
        $args['related_products'] = $array;
        $args['name'] = $title; ?>

        <div class="woocommerce streamit-related-product">
            <?php
            wc_set_loop_prop('columns', 4);
            wc_get_template('single-product/related.php', $args); ?>
        </div>
    <?php
    }

    public function streamit_video_playbtn($streamit_options, $trailer_link, $trailer_img)
    {
        if (empty($trailer_link)) return null;

        $display_trailer_link_btn = $streamit_options['streamit_display_trailer_link_btn'] == 'no' ? true : false;
        $thumbnali_class = $display_trailer_link_btn ? 'playbtn_thumbnail' : ''; ?>

        <a href="<?php echo esc_url($trailer_link); ?>" class="video-open playbtn block-images position-relative <?php echo esc_attr($thumbnali_class); ?>">
            <?php if ($display_trailer_link_btn) {
                if (!empty($trailer_img)) {
                    echo wp_get_attachment_image($trailer_img, 'medium');
                } else {
                    if (has_post_thumbnail()) {
                        the_post_thumbnail('medium-large');
                    }
                }
            } ?>

            <span class="content btn btn-transparant iq-button">
                <?php
                if (isset($streamit_options['streamit_trailer_link_icon'])) {
                    $streamit_trailer_link_icon = $streamit_options['streamit_trailer_link_icon'];
                } ?>

                <i class="<?php echo esc_attr($streamit_trailer_link_icon); ?> mr-2"></i>
                <?php if (isset($streamit_options['streamit_trailer_link_text'])) { ?>
                    <span><?php echo esc_html($streamit_options['streamit_trailer_link_text']) ?></span>
                <?php } ?>
            </span>
        </a>
    <?php
    }

    public function streamit_gallery($gallery_ids)
    {
        $gallery_ids = explode(',', $gallery_ids); ?>

        <div class="streamit-screenshot">
            <div class="container-fluid">
                <div class="row m-0">
                    <div class="col-sm-12 overflow-hidden p-0">
                        <div class="iq-main-header d-flex align-items-center justify-content-between iq-ltr-direction">
                            <h4 class="main-title">
                                <?php echo esc_html__('Screenshot', 'streamit'); ?>
                            </h4>
                        </div>

                        <div class="streamit-swiper streamit iq-rtl-direction">
                            <div class="swiper-wrapper">
                                <?php foreach ($gallery_ids as $gallery_id) {
                                    $attachement_url = wp_get_attachment_image_url($gallery_id, 'full'); ?>
                                    <div class="swiper-slide">
                                        <div class="img-box block-images position-relative">
                                            <img src="<?php echo esc_url($attachement_url) ?>" class="img-fluid" alt="<?php esc_attr_e('streamit', 'streamit') ?>" loading="lazy">
                                            <div class="swiper-lazy-preloader"></div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>

                            <div class="swiper-button-next">
                                <button class="NextArrow-two slick-arrow"><i class="fas fa-angle-right"></i></button>
                            </div>

                            <div class="swiper-button-prev">
                                <button class="PreArrow-two slick-arrow"><i class="fas fa-angle-left"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<?php
    }
}
