<?php

/**
 * Streamit\Utility\Helper\Component class
 *
 * @package streamit
 */

namespace Streamit\Utility\Helper;

use function Streamit\Utility\streamit;
use Streamit\Utility\Component_Interface;

/**
 * Class for managing comments UI.
 *
 * Exposes template tags:
 * * `streamit()->the_comments( array $args = array() )`
 *
 * @link https://wordpress.org/plugins/amp/
 */
class Component implements Component_Interface
{
	/**
	 * Gets the unique identifier for the theme component.
	 *
	 * @return string Component slug.
	 */

	public $streamit_options;

	public function get_slug(): string
	{
		return 'helper';
	}

	/**
	 * Adds the action and filter hooks to integrate with WordPress.
	 */

	public function initialize()
	{
		// live ajax search
		add_action('wp_ajax_data_fetch', 		array($this, 'data_fetch'));
		add_action('wp_ajax_nopriv_data_fetch', array($this, 'data_fetch'));
		add_action('wp_footer', 				array($this, 'ajax_fetch'), 9999);

		add_action('pre_post_update', 	array($this, 'streamit_save_episode_function'), 10, 2);
		add_action('draft_to_publish', 	array($this, 'streamit_save_episode_function'));

		// ** search load more *//
		if (!function_exists('streamit_loadmore_ajax_handler')) {
			add_action('wp_ajax_loadmore', 			array($this, 'streamit_loadmore_ajax_handler'));
			add_action('wp_ajax_nopriv_loadmore', 	array($this, 'streamit_loadmore_ajax_handler'));
		}

		//** blog load more *//
		if (!function_exists('streamit_loadmore_blog_ajax_handler')) {
			add_action('wp_ajax_loadmore_blog', 		array($this, 'streamit_loadmore_blog_ajax_handler'));
			add_action('wp_ajax_nopriv_loadmore_blog', 	array($this, 'streamit_loadmore_blog_ajax_handler'));
		}

		//** person load more *//
		if (!function_exists('streamit_loadmore_person_ajax_handler')) {
			add_action('wp_ajax_loadmore_person', 			array($this, 'streamit_loadmore_person_ajax_handler'));
			add_action('wp_ajax_nopriv_loadmore_person', 	array($this, 'streamit_loadmore_person_ajax_handler'));
		}

		// Archive Page -> Genres ,Tag, Category
		if (!function_exists('streamit_loadmore_archive_ajax_handle')) {
			add_action('wp_ajax_loadmore_archive', 			array($this, 'streamit_loadmore_archive_ajax_handle'), 10, 2);
			add_action('wp_ajax_nopriv_loadmore_archive', 	array($this, 'streamit_loadmore_archive_ajax_handle'));
		}

		if (!function_exists('streamit_loadmore_person_ajax_handle')) {
			add_action('wp_ajax_loadmore_persons_archive', 			array($this, 'streamit_loadmore_persons_archive_ajax_handle'), 10, 2);
			add_action('wp_ajax_nopriv_loadmore_persons_archive', 	array($this, 'streamit_loadmore_persons_archive_ajax_handle'));
		}

		// ** Product load more *//
		if (!function_exists('streamit_loadmore_product_ajax_handler')) {
			add_action('wp_ajax_loadmore_product', 			array($this, 'streamit_loadmore_product_ajax_handler'));
			add_action('wp_ajax_nopriv_loadmore_product', 	array($this, 'streamit_loadmore_product_ajax_handler'));
		}

		if (!function_exists('streamit_loadmore_episode_ajax_handler')) {
			add_action('wp_ajax_loadmore_episodes', 		array($this, 'streamit_loadmore_episode_ajax_handler'));
			add_action('wp_ajax_nopriv_loadmore_episodes', 	array($this, 'streamit_loadmore_episode_ajax_handler'));
		}

		add_action('wp_ajax_load_skeleton', 		array($this, 'streamit_load_skeleton_ajax_handler'));
		add_action('wp_ajax_nopriv_load_skeleton', 	array($this, 'streamit_load_skeleton_ajax_handler'));

		// Get Woof Ajax Filter Product Query 
		if (!function_exists('streamit_fetch_woof_filter_ajax_query')) {
			add_action('wp_ajax_fetch_woof_filter_ajax_query', array($this, 'streamit_fetch_woof_filter_ajax_query'));
			add_action('wp_ajax_nopriv_fetch_woof_filter_ajax_query', array($this, 'streamit_fetch_woof_filter_ajax_query'));
		}

		if (!function_exists('streamit_download_file')) {
			add_action('admin_post_streamit_download', array($this, 'streamit_download_file'));
			add_action('admin_post_nopriv_streamit_download', array($this, 'streamit_download_file'));
		}

		add_filter('pms_edit_profile_form_submit_text', function ($btn_text) {
			return esc_html__('Save Profile', 'streamit');
		});

		add_filter('pms_member_account_subscriptions_view_row', function ($subscription_row) {
			return '<div class="table-responsive">' . $subscription_row . '</div>';
		});

		// Continue Watching
		add_action('after_setup_theme', array($this, 'action_add_custom_helper'));

		//Notification Module
		add_action('init', array($this, 'streamit_notification'));

		//Download URL For Masvideos Movies/Episodes
		if (!function_exists('streamit_download_file_ajax_handler')) {
			add_action('wp_ajax_download_file', array($this, 'streamit_download_file_ajax_handler'));
			add_action('wp_ajax_nopriv_download_file', array($this, 'streamit_download_file_ajax_handler'));
		}
	}

	public function streamit_download_file_ajax_handler()
	{
		$FileName = $_REQUEST['FileName'];
		$FileUrl = $_REQUEST['FileUrl'];

		// Set headers for file download
		header("Content-Disposition: attachment; filename=\"$FileName\"");
		header("Content-Type: application/octet-stream");

		// Return response
		$response = array(
			'fileName' => $FileName,
			'fileUrl' => $FileUrl
		);

		echo json_encode($response);
		die;
	}

	public function streamit_load_skeleton_ajax_handler()
	{
		global $wp_filesystem;
		if (!isset($wp_filesystem)) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
			WP_Filesystem();
		}

		$skeleton_path = get_template_directory() . '/template-parts/skeleton/';
		try {
			$data = array(
				'skeleton-grid' => $wp_filesystem->get_contents($skeleton_path . 'skeleton-grid.php'),
				'skeleton-list' => $wp_filesystem->get_contents($skeleton_path . 'skeleton-list.php'),
			);
			if ($data['skeleton-grid'] == false || $data['skeleton-list'] == false) {
				throw new \Exception("File not Found");
			}
			wp_send_json_success($data);
		} catch (\Exception $e) {
			wp_send_json_error($e->getMessage(), 404);
		}
	}

	public function streamit_download_file()
	{
		if (isset($_POST["download"]) && !empty($_POST['download'])) {
			$this->streamit_send_download_file();
		}
	}

	public function streamit_send_download_file()
	{
		$id = base64_decode($_POST["download"]);

		if (get_post_meta($id, 'download_btn', true) == 'link') {
			$remoteURL = get_post_meta($id, 'dwn_link', true);
		} elseif (get_post_meta($id, 'download_btn', true) == 'upload') {
			$remoteURL = wp_get_attachment_url(get_post_meta($id, 'upload_item', true));
		}

		if (!post_exists(get_the_title($id)) && !empty($remoteURL))
			return;

		header("Content-type: application/x-file-to-save");
		header("Content-Disposition: attachment; filename=" . basename($remoteURL));
		while (ob_get_level()) {
			ob_end_clean();
		}
		readfile($remoteURL);
		exit();
	}

	public function streamit_fetch_woof_filter_ajax_query()
	{
		session_start();
		$query = new \WP_Query($_SESSION['streamit_woof_query_ajax']);
		echo json_encode(array('query' => json_encode($_SESSION['streamit_woof_query_ajax']), 'max_page' => $query->max_num_pages));
		wp_reset_postdata();
		session_unset();
		die;
	}

	// live ajax search
	public function data_fetch()
	{
		$search_keyword = isset($_POST['keyword']) && !empty($_POST['keyword']) ? $_POST['keyword'] : '';
		if (empty($search_keyword)) die;

		$current_user_id = get_current_user_id();

		$args = array(
			'posts_per_page' => 5,
			's' => esc_attr($search_keyword),
			'post_type' =>  apply_filters('streamit_search_filter_ajax_by_posttype', array('movie', 'tv_show', 'episode', 'video')),
			'post_status' => array('publish'),
		);

		if (isset($_POST['is_include']) && $_POST['is_include'] == 'posts') {
			array_push($args['post_type'], 'post');
		}

		$wp_query = new \WP_Query($args); ?>

		<div class="widget streamit-ajax-custom-search mb-0">
			<div class="list-inline iq-widget-menu">
				<ul class="iq-post">
					<?php if ($wp_query->have_posts()) :

						// STORE SEARCH KEYWORD ONLY WHEN RESULTS ARE FOUND
						$stored_search_results = get_user_meta($current_user_id, '_streamit_search_results', true);
						if (!empty($stored_search_results)) {
							$stored_search_results = array_unique($stored_search_results);

							if (count($stored_search_results) >= 10) {
								$stored_search_results = array_slice($stored_search_results, 0, 9);
							}

							if (!in_array($search_keyword, $stored_search_results)) {
								array_unshift($stored_search_results, $search_keyword);
								update_user_meta($current_user_id, '_streamit_search_results', $stored_search_results);
							}
						} else {
							add_user_meta($current_user_id, '_streamit_search_results', array($search_keyword));
						}

						while ($wp_query->have_posts()) : $wp_query->the_post();
							$post_type = get_post_type();
							$run_time = get_post_meta(get_the_ID(), '_' . $post_type . '_run_time', true);

							$img_url = wp_get_attachment_image_url(get_post_thumbnail_id(get_the_ID()), "medium");
							if (empty($img_url)) {
								$img_url = get_template_directory_uri() . '/assets/images/redux/placeholder.jpg';
							} ?>

							<li class="mr-0 d-block">
								<div class="post-img">
									<div class="post-img-holder">
										<a class="img-height" href="<?php echo esc_url(get_permalink()); ?>">
											<img src='<?php echo esc_url($img_url, 'streamit'); ?>' alt="image" />
										</a>
									</div>

									<div class="post-blog pt-2 pb-2 pr-2">
										<div class="blog-box">
											<a class="new-link" href="<?php echo esc_url(get_permalink()); ?>">
												<h6><?php the_title(); ?></h6>
											</a>

											<ul class="list-inline iq-category-list">
												<li class="list-inline-item"><span><?php echo esc_html(rtrim($run_time, ",")); ?></span></li>
											</ul>

										</div>
									</div>
								</div>
							</li>
						<?php
						endwhile;
						wp_reset_postdata(); ?>
				</ul>
			<?php
					else :
						echo '<p class="no-result pb-2">' . esc_html__('No Results Found', 'streamit') . '</p>';
					endif; ?>
			</div>

			<?php
			$total_pages = $wp_query->max_num_pages;
			if ($total_pages > 1) { ?>
				<button type="submit" class="hover-buttons btn w-100"><?php esc_html_e('More Results', 'streamit'); ?></button>
			<?php } ?>
		</div>
	<?php
		die();
	}

	public function ajax_fetch()
	{ ?>
		<script type="text/javascript">
			var debounce_fn = _.debounce(fetchResults, 500, false);

			function fetchResults(input) {
				let keyword = input.value;
				if (jQuery(input).parents('header').length == 0 || keyword.length < 3) {
					return false;
				}
				let form = jQuery(input).closest("form");
				if (keyword == "") {
					form.find('.datafetch').html('');
				} else {
					jQuery.ajax({
						url: streamit_loadmore_params.ajaxurl,
						type: 'post',
						data: {
							action: 'data_fetch',
							keyword: keyword,
							is_include: 'posts',
						},
						beforeSend: function() {
							form.find('.search_result_history').css("display", "none");
						},
						success: function(data) {
							form.find('.datafetch').html(data);
							form.find('.datafetch').css('display', 'block');
						}
					});
				}
			}
		</script>
		<?php
	}

	// EPisode update feature checkbox
	public function streamit_save_episode_function($post_ID)
	{
		if (get_post_type($post_ID) == 'episode') {

			if (isset($_POST['_featured']) && !empty($_POST['_featured'])) {
				update_post_meta($post_ID, '__featured', 'yes');
				return;
			}

			update_post_meta($post_ID, '__featured', false);
		}
	}

	// ** search load more *//
	public function streamit_loadmore_ajax_handler()
	{
		$args = json_decode(stripslashes($_POST['query']), true);
		$args['paged'] = $_POST['page'] + 1; // we need next page to be loaded
		$args['post_status'] = 'publish';

		query_posts($args);
		if (have_posts()) :
			while (have_posts()) : the_post();
				get_template_part('template-parts/content/entry_search', get_post_type());
			endwhile;

		endif;
		die;
	}

	//** blog load more *//
	public function streamit_loadmore_blog_ajax_handler()
	{
		$args = json_decode(stripslashes($_POST['query']), true);
		$args['paged'] = $_POST['page'] + 1; // we need next page to be loaded
		$args['post_status'] = 'publish';
		$post_section = streamit()->post_style();

		query_posts($args);
		if (have_posts()) :
			while (have_posts()) : the_post();
				get_template_part('template-parts/content/entry', get_post_type(), ['entry_item_class' => $post_section['post']]);
			endwhile;

		endif;
		die;
	}


	//** person load more *//
	public function streamit_loadmore_persons_archive_ajax_handle()
	{
		$args = array(
			'post_type'			=> "person",
			'posts_per_page'    => $_POST['availablepost'] ?? 12,
			'paged'             => $_POST['page'] + 1,
			'post_status'       => 'publish',
			'order'             => 'DESC',
			'suppress_filters'  => 0
		);

		query_posts($args);

		if (have_posts()) :
			while (have_posts()) : the_post();
				$terms = get_the_terms(get_the_ID(), 'person_cat'); ?>

				<article id="post-<?php the_ID(); ?>" class="col-xl-2 col-lg-3 col-md-3 col-sm-4 col-6 iq-persons px-2 ">
					<div class=" position-relative">
						<div class="cast-images position-relative d-flex">
							<?php $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "medium_large"); ?>
							<img src="<?php if ($full_image) {
											echo esc_url($full_image[0]);
										} else {
											echo get_template_directory_uri() . '/assets/images/redux/placeholder_250_630.jpg';
										} ?>" class="img-fluid" alt="image">
						</div>

						<div class="iq-cast-body">
							<div class="iq-person-heading">
								<h6 class="iq-title">
									<a href="<?php the_permalink(get_the_ID()); ?>">
										<?php echo esc_html(the_title(), 'streamit'); ?>
									</a>
								</h6>

								<div class="iq-person-cats">
									<?php
									for ($i = 0; $i < 2 && isset($terms[$i]); $i++) {
										echo "<span class='iq-person-cat-item'>";
										echo esc_html($terms[$i]->name);
										echo "</span>";
									}
									?>
								</div>
							</div>
						</div>
					</div>
				</article>
			<?php
			endwhile;
		endif;
		die;
	}

	//** person load more *//
	public function streamit_loadmore_person_ajax_handler()
	{
		$cast_id = url_to_postid($_POST['href']);
		$post_type = $_POST['post_type'];
		$recommended_person_cast_ids = [];
		$recommended_movie_cast_ids = [];
		$recommended_tv_show_cast_ids = [];
		$recommended_movie_cast_ids = get_post_meta($cast_id, '_movie_cast', true);
		if (is_array($recommended_movie_cast_ids) && !empty($recommended_movie_cast_ids)) {
			$recommended_person_cast_ids = array_merge($recommended_person_cast_ids, $recommended_movie_cast_ids);
		}
		$recommended_tv_show_cast_ids = get_post_meta($cast_id, '_tv_show_cast', true);
		if (is_array($recommended_tv_show_cast_ids) && !empty($recommended_tv_show_cast_ids)) {
			$recommended_person_cast_ids = array_merge($recommended_person_cast_ids, $recommended_tv_show_cast_ids);
		}
		$args = array(
			'posts_per_page'     => 10,
			'paged'                => $_POST['page'] + 1,
			'post_status'       => 'publish',
			'order'             => 'ASC',
			'suppress_filters'  => 0
		);
		if ($post_type == 'all') {
			$args['post_type'] = array('movie', 'tv_show');
			$args['post__in'] = $recommended_person_cast_ids;
			$args['fields'] = 'ids';
		} else if ($post_type == 'tv_show') {
			$args['post_type'] = 'tv_show';
			$args['post__in'] = $recommended_tv_show_cast_ids;
		} else {
			$args['post_type'] = 'movie';
			$args['post__in'] = $recommended_movie_cast_ids;
		}
		$counter = $args['posts_per_page'] + 1;
		query_posts($args);
		if (have_posts()) :
			while (have_posts()) : the_post();
				$r_movie_obj = get_the_ID();
				$meta = get_post_meta($r_movie_obj);
				$movie_cast = get_post_meta($r_movie_obj, '_cast');
				$m_cast = $movie_cast[0];
				$found_key = array_search($cast_id, array_column($m_cast, 'id'));
				if ('tv_show' == get_post_type()) {
					$season_data = unserialize($meta['_seasons'][0]);
					if (!empty($season_data)) {
						$season_years = array_column($season_data, 'year');
						$start = count($season_years) ? min($season_years) : '';
						$end = count($season_years) ? max($season_years) : '';
						$season_count = count($season_data);
						if ($season_count == '1') {
							$release_year = $start;
						} else {
							if (!empty($start) && !empty($end)) {
								$release_year = $start . ' - ' . $end;
							}
						}
						if (is_array($season_data)) {
							$censor_rating = ' (' . count($season_data) . ' Seasons) ';
						}
					}
				} else {
					$release_year = get_post_meta($r_movie_obj, '_movie_release_date');
					if (isset($release_year[0])) {
						$release_year = date('Y', $release_year[0]);
					}
				}
				$attachement_url = wp_get_attachment_image_src(get_post_thumbnail_id($r_movie_obj), 'thumbnail')[0];
				if (isset($attachement_url) && !empty($attachement_url))
					$attachement_url = $attachement_url;
				else
					$attachement_url = ''; ?>
				<tr class="trending-pills">
					<td class="image"><img src="<?php echo esc_url($attachement_url); ?>" class="img-fluid" alt="<?php esc_attr_e('streamit', 'streamit'); ?>"></td>
					<td class="seperator"><?php echo esc_html($counter); ?></td>
					<td class="content">
						<a href="<?php the_permalink(); ?>">
							<?php the_title(); ?>
						</a>
						<span class="ml-2 group"> <?php esc_html_e('as', 'streamit'); ?> <span class="character">
								<?php echo esc_html($m_cast[$found_key]['character']);
								if ('tv_show' == get_post_type()) {
									echo esc_html($censor_rating);
								} ?></span></span>
					</td>
					<td class="year">
						<?php if (!empty($release_year)) {
							echo esc_html($release_year);
						} ?>
					</td>
				</tr>
<?php
				$counter++;
			endwhile;
		endif;
		die;
	}

	public function streamit_loadmore_archive_ajax_handle()
	{
		global $streamit_options;

		$is_ajax_enable             = false;
		$args 						= json_decode(stripslashes($_POST['query']), true);
		$type 						= $_POST['type'] ?? '';
		if ($type == 'infinite_scroll' && $args['post_type'] != 'person' && $args['post_type'] != 'tv_show')
			$args = json_decode(stripslashes($_POST['archive_query']), true);
		$args['paged'] 				= $_POST['page'] + 1;
		$args['posts_per_page'] 	= $_POST['availablepost'];
		$args['fields'] 			= 'ids';
		$archive_cards_style    	= isset($streamit_options['streamit_archive_cards_style']) && !empty($streamit_options['streamit_archive_cards_style']) ? $streamit_options['streamit_archive_cards_style'] : '1';
		$lazy_load          		= $is_ajax_enable ? " iqonic-lazy-load-images" : '';

		$is_grid                    = true;
		$thumbnail_size             = "full";
		$settings['image_style']    = "portrait";
		$col                        = 'list-inline';
		$settings['play_now_text']  = esc_html__("Play Now", "streamit");
		$is_badges_enable    		= isset($streamit_options['streamit_archive_enable_premium_badges']) && $streamit_options['streamit_archive_enable_premium_badges'] == "yes" ? true : false;
		$show_title    				= isset($streamit_options['streamit_archive_enable_title']) && $streamit_options['streamit_archive_enable_title'] == "yes" ? true : false;

		$temp_col = ($archive_cards_style == "2") ? "col-xl-2 col-lg-4 col-md-4 col-sm-6 col-6 wl-child archive-media" : "col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6 wl-child archive-media";

		$wp_query = new \WP_Query($args);
		$post_ids = $wp_query->posts;

		if ($wp_query->have_posts()) {
			if ($args['post_type'] != 'person') {
				foreach ($post_ids as $post_id) {
					$post_type = get_post_type($post_id);

					echo '<article id="post-' . esc_attr($post_id) . '" class="' . esc_attr($temp_col) . '">';

					if ($archive_cards_style == 2) {
						if ($post_type == "movie")
							require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Cards/template.php';
						elseif ($post_type == "tv_show")
							require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Cards/template.php';
						elseif ($post_type == "video")
							require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Cards/template.php';
					} else {
						if ($post_type == "movie")
							require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Slider/template.php';
						elseif ($post_type == "tv_show")
							require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Slider/template.php';
						elseif ($post_type == "video")
							require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Slider/template.php';
					}
					echo '</article>';
				}
				wp_reset_postdata();
			} else {
				foreach ($post_ids as $post_id) {
					get_template_part('template-parts/content/entry_archive', 'person');
				}
			}
		}
		wp_die();
	}

	public function streamit_loadmore_product_ajax_handler()
	{
		$args = json_decode(stripslashes($_POST['query']), true);
		$args['paged'] = $_POST['page'] + 1; // we need next page to be loaded
		$args['post_status'] = 'publish';
		$is_grid = $_POST['is_grid'] != 'true' ? 'listing' : 'grid';
		$is_switch = isset($_POST['is_switch']) && $_POST['is_switch'] == 'true' ? true : false;
		if ($is_switch) {
			for ($args['paged'] = 1; $args['paged'] <= $_POST['page']; $args['paged']++) {
				query_posts($args);
				if (have_posts()) :
					while (have_posts()) : the_post();

						get_template_part('template-parts/wocommerce/entry', $is_grid);

					endwhile;
				endif;
			}
		} else {
			query_posts($args);
			if (have_posts()) :
				while (have_posts()) : the_post();
					get_template_part('template-parts/wocommerce/entry', $is_grid);
				endwhile;
			endif;
		}
		die;
	}

	public function streamit_loadmore_episode_ajax_handler()
	{
		$args = json_decode(stripslashes($_POST['query']), true);
		$args['paged'] = $_POST['page'] + 1; // we need next page to be loaded
		$episode_query = get_posts($args);
		foreach ($episode_query as $epdata) {
			get_template_part('template-parts/global/episode', '', array('id' => $epdata->ID));
			continue;
		}
		die;
	}

	public function action_add_custom_helper()
	{
		if (class_exists('MasVideos')) {
			new Options\ContinueWatching();
		}
	}

	public function streamit_notification()
	{
		global $streamit_options;

		if (isset($streamit_options['enable_notification_module']) && $streamit_options['enable_notification_module'] == "yes") {
			new Options\Notification();
		}
	}
}
