<?php

/**
 * Streamit\Utility\Dynamic_Style\Styles\Layout class
 *
 * @package streamit
 */

namespace Streamit\Utility\Dynamic_Style\Styles;

use function add_action;
use function Streamit\Utility\streamit;
use Streamit\Utility\Dynamic_Style\Component;

class Layout extends Component
{
    public $is_rtl;

    public function __construct()
    {
        $this->streamit_maintenance_mode();

        add_action('wp_head', [$this, 'streamit_layout_add_meta']);

        add_action('init', function () {
            global $streamit_options;

            if (!isset($_COOKIE['theme_scheme_direction']) && empty($_COOKIE['theme_scheme_direction'])) {
                $dir = 'ltr';
                if (isset($streamit_options['streamit_layout_mode_options']) && $streamit_options['streamit_layout_mode_options'] == 2) {
                    $dir = $streamit_options['streamit_layout_mode_options'] == 2 ? 'rtl' : 'ltr';
                }

                setcookie('theme_scheme_direction', $dir, time() + 60 * 60 * 24, '/');
            }
        });
    }

    public function streamit_maintenance_mode()
    {
        $streamit_options = get_option("streamit_options");
        if (isset($streamit_options['streamit_enable_sswitcher']) && $streamit_options['streamit_enable_sswitcher'] == 1) {
            add_action('wp_footer', array($this, 'streamit_style_switcher'));
            add_action('wp_enqueue_scripts', array($this, 'streamit_style_switcher_styles'), 20);
        }
    }

    public function streamit_style_switcher_styles()
    {
        wp_enqueue_style('iq-style-switcher', get_template_directory_uri() . '/assets/css/vendor/layout/iq-style-switcher.css', array(), streamit()->get_version());
        wp_enqueue_script('iq-style-switcher', get_template_directory_uri() . '/assets/js/vendor/layout/iq-style-switcher.js', array(), streamit()->get_version(), true);
    }

    public function streamit_layout_add_meta()
    {
        $version = streamit()->get_version();
        $path = get_template_directory_uri() . '/assets/css/vendor/';
        echo "<meta name='setting_options' data-version='$version' data-path='$path'></meta>";
    }
    public function streamit_style_switcher()
    {
        global $streamit_options;
        $ltr_check = $rtl_check = '';
        if (isset($_COOKIE['theme_scheme_direction'])) {
            $rtl_check = ($_COOKIE['theme_scheme_direction'] == 'rtl') ? 'checked' : '';
            $ltr_check = ($_COOKIE['theme_scheme_direction'] == 'ltr') ? 'checked' : '';
        } else {
            if (class_exists('ReduxFramework') && !empty($streamit_options['streamit_layout_mode_options'])) {
                $rtl_check = ($streamit_options['streamit_layout_mode_options'] == 2) ? 'checked' : '';
                $ltr_check = ($streamit_options['streamit_layout_mode_options'] == 1) ? 'checked' : '';
            }
        }
?>
        <div class="iq-theme-feature hidden-xs hidden-sm hidden-md">
            <div class="iq-switchbuttontoggler"><i class="fas fa-cog"></i></div>
            <ul id="switch-mode" class="switch-mode">
                <li>
                    <input type="radio" value="ltr" class="btn-check" name="theme_scheme_direction" id="theme-scheme-direction-ltr" <?php echo esc_attr($ltr_check); ?>>
                    <label class="btn-box d-block" for="theme-scheme-direction-ltr">
                        <?php esc_html_e("LTR", "streamit"); ?> </label>
                </li>
                <li>
                    <input type="radio" value="rtl" class="btn-check" name="theme_scheme_direction" id="theme-scheme-direction-rtl" <?php echo esc_attr($rtl_check); ?>>
                    <label class="btn-box d-block" for="theme-scheme-direction-rtl">
                        <?php esc_html_e("RTL", "streamit"); ?></label>
                </li>
            </ul>
        </div>
<?php
    }
}
