<?php

/**
 * Streamit\Utility\Dynamic_Style\Styles\Header class
 *
 * @package streamit
 */

namespace Streamit\Utility\Dynamic_Style\Styles;

use Streamit\Utility\Dynamic_Style\Component;
use function add_action;

class Header extends Component
{

    public function __construct()
    {
        add_action('wp_enqueue_scripts', array($this, 'streamit_header_dynamic_style'), 20);
        add_action('wp_enqueue_scripts', array($this, 'streamit_header_background_style'), 20);
        add_action('wp_enqueue_scripts', array($this, 'streamit_menu_color_options'), 20);
        add_action('wp_enqueue_scripts', array($this, 'streamit_sub_menu_color_options'), 20);
        add_action('wp_enqueue_scripts', array($this, 'streamit_responsive_menu_color_options'), 20);
        add_filter('body_class', array($this, 'streamit_add_body_classes'));
    }

    public function is_streamit_header()
	{
		global $streamit_options;

		$is_header = true;
		$page_id = get_queried_object_id();
		$header_page_option = get_post_meta($page_id, "name_header_display", true);
		$header_page_option = !empty($header_page_option) ? $header_page_option : "default";

		if ($header_page_option != 'default') {
			$is_header =  ($header_page_option == 'no') ? false : true;
		}

		if (is_404() && !$streamit_options['header_on_404']) {
			$is_header = false;
		}
		return $is_header;
	}

    public function streamit_header_dynamic_style()
    {
        $page_id = get_queried_object_id();
        $header_css = '';

        if (is_plugin_active('advanced-custom-fields/acf.php')) {
            if (get_post_meta($page_id, 'name_header_display', true) == 'no') {
                $header_css = 'header { 
                        display : none !important;
                    }';
            } else if (get_post_meta($page_id, 'name_header_display', true) == 'yes') {
                $header_css = '.iq-register .elementor-shortcode { 
                        padding-top : 75px !important;
                    }';
            }
        }

        if (!empty($header_css)) {
            wp_add_inline_style('streamit-style', $header_css);
        }
    }

    public function streamit_header_background_style()
    {
        global $streamit_options;
        $dynamic_css = '';

        if (isset($streamit_options['streamit_header_background_type']) && $streamit_options['streamit_header_background_type'] != 'default') {
            $type = $streamit_options['streamit_header_background_type'];
            if ($type == 'color') {
                if (!empty($streamit_options['streamit_header_background_color'])) {
                    $dynamic_css = 'header#main-header{
							background : ' . $streamit_options['streamit_header_background_color'] . '!important;
						}';
                }
            }
            if ($type == 'image') {
                if (!empty($streamit_options['streamit_header_background_image']['url'])) {
                    $dynamic_css = 'header#main-header{
							background : url(' . $streamit_options['streamit_header_background_image']['url'] . ') !important;
						}';
                }
            }
            if ($type == 'transparent') {
                $dynamic_css = 'header#main-header{
						background : transparent !important;
					}';
            }
        }
        if (!empty($dynamic_css)) {
            wp_add_inline_style('streamit-style', $dynamic_css);
        }
    }

    function streamit_menu_color_options()
    {
        global $streamit_options;
        $inline_css = '';

        if (isset($streamit_options['streamit_header_variation'])  && $streamit_options['streamit_header_variation'] != '3') {
            if (isset($streamit_options['header_menu_color_type']) && $streamit_options['header_menu_color_type'] == 'custom') {

                if (isset($streamit_options['streamit_header_menu_color']) && !empty($streamit_options['streamit_header_menu_color'])) {
                    $inline_css .= 'header .navbar ul li a,header .navbar ul li i{
                    color : ' . $streamit_options['streamit_header_menu_color'] . '!important;
                }';
                }

                if (isset($streamit_options['streamit_header_menu_active_color']) && !empty($streamit_options['streamit_header_menu_active_color'])) {
                    $inline_css .= ' header .navbar ul li.current-menu-item a, header .navbar ul li.current-menu-parent > a, header .navbar ul li.current-menu-parent i, header .navbar ul li.current-menu-item i, header .navbar ul li.current-menu-ancestor> a, header .navbar ul li.current-menu-ancestor> i{
                    color : ' . $streamit_options['streamit_header_menu_active_color'] . ' !important;
                }';
                }

                if (isset($streamit_options['streamit_header_menu_hover_color']) && !empty($streamit_options['streamit_header_menu_hover_color'])) {
                    $inline_css .= 'header .navbar ul li:hover > a,header .navbar ul li:hover > i{
                    color : ' . $streamit_options['streamit_header_menu_hover_color'] . ' !important;
                }';
                }
            }
        }
        if (!empty($inline_css)) {
            wp_add_inline_style('streamit-style', $inline_css);
        }
    }
    function streamit_sub_menu_color_options()
    {
        global $streamit_options;
        $inline_css = '';

        if (isset($streamit_options['streamit_header_variation'])  && $streamit_options['streamit_header_variation'] != '3') {
            if (isset($streamit_options['header_submenu_color_type']) && $streamit_options['header_submenu_color_type'] == 'custom') {
                if (isset($streamit_options['streamit_header_submenu_color']) && !empty($streamit_options['streamit_header_submenu_color'])) {
                    $inline_css .= 'header .navbar ul li .sub-menu li a,header .navbar ul li .sub-menu li.current-menu-parent .sub-menu  li a, header .navbar ul li .sub-menu li:hover .sub-menu li a,header .navbar ul li .sub-menu li i,header .navbar ul li .sub-menu li.current-menu-parent .sub-menu  li i, header .navbar ul li .sub-menu li:hover .sub-menu li i,header .navbar ul li .sub-menu li:hover .sub-menu li a,header .navbar ul li .sub-menu li:hover .sub-menu li i{
                   color : ' . $streamit_options['streamit_header_submenu_color'] . ' !important;
               }';
                }

                if (isset($streamit_options['streamit_header_submenu_active_color']) && !empty($streamit_options['streamit_header_submenu_active_color'])) {
                    $inline_css .= 'header .navbar ul li .sub-menu li.current-menu-item a,header .navbar ul li .sub-menu li.current-menu-item i,header .navbar ul li .sub-menu li.current-menu-ancestor a,header .navbar ul li .sub-menu li.current-menu-ancestor i,header .navbar ul li .sub-menu li.current-menu-parent .sub-menu li.current-menu-item  a,header .navbar ul li .sub-menu li.current-menu-parent .sub-menu li.current-menu-item  i
                   {
                       color : ' . $streamit_options['streamit_header_submenu_active_color'] . ' !important;
                   }';
                }

                if (isset($streamit_options['streamit_header_submenu_hover_color']) && !empty($streamit_options['streamit_header_submenu_hover_color'])) {
                    $inline_css .= 'header .navbar ul li .sub-menu li:hover a,header .navbar ul li .sub-menu li:hover i,header .navbar ul li .sub-menu li.current-menu-parent:hover a, header .navbar ul li .sub-menu li.current-menu-parent .sub-menu li:hover a, header .navbar ul li .sub-menu li.current-menu-parent:hover .sub-menu li:hover a,header .navbar ul li .sub-menu li.current-menu-parent:hover i, header .navbar ul li .sub-menu li.current-menu-parent .sub-menu li:hover i, header .navbar ul li .sub-menu li.current-menu-parent:hover .sub-menu li:hover i,header .navbar ul li .sub-menu li:hover .sub-menu li:hover a,header .navbar ul li .sub-menu li:hover .sub-menu li:hover i{
                   color : ' . $streamit_options['streamit_header_submenu_hover_color'] . ' !important;
               }';
                }

                if (isset($streamit_options['streamit_header_submenu_background_color']) && !empty($streamit_options['streamit_header_submenu_background_color'])) {
                    $inline_css .= 'header .navbar ul li .sub-menu li a,header .navbar ul li .sub-menu li.current-menu-parent li a,header .navbar ul li .sub-menu li.current-menu-parent:hover .sub-menu li a,header .navbar ul li .sub-menu li:hover .sub-menu li a,header .navbar ul li .sub-menu li:hover .sub-menu li a {
                   background : ' . $streamit_options['streamit_header_submenu_background_color'] . ' !important;
               }';
                }

                if (isset($streamit_options['header_submenu_background_hover_color']) && !empty($streamit_options['header_submenu_background_hover_color'])) {
                    $inline_css .= 'header .navbar ul li .sub-menu li:hover a,header .navbar ul li .sub-menu li.current-menu-parent:hover a,header .navbar ul li .sub-menu li.current-menu-parent .sub-menu li:hover a,header .navbar ul li .sub-menu li.current-menu-parent:hover .sub-menu li:hover a,header .navbar ul li .sub-menu li:hover .sub-menu li:hover a{
                   background : ' . $streamit_options['header_submenu_background_hover_color'] . ' !important;
               }';
                }

                if (isset($streamit_options['header_submenu_background_active_color']) && !empty($streamit_options['header_submenu_background_active_color'])) {
                    $inline_css .= 'header .navbar ul li .sub-menu li.current-menu-item a,header .navbar ul li .sub-menu li.current-menu-parent a,header .navbar ul li .sub-menu li.current-menu-parent .sub-menu li.current-menu-item  a {
                   background : ' . $streamit_options['header_submenu_background_active_color'] . ' !important;
               }';
                }
            }
        }
        if (!empty($inline_css)) {
            wp_add_inline_style('streamit-style', $inline_css);
        }
    }

    function streamit_responsive_menu_color_options()
    {
        global $streamit_options;

        $inline_css = '';

        if (isset($streamit_options['responsive_menu_button_type']) && $streamit_options['responsive_menu_button_type'] == 'custom') {
            if (isset($streamit_options['responsive_menu_button_color']) && !empty($streamit_options['responsive_menu_button_color'])) {
                $inline_css .= 'header .navbar-light .navbar-toggler{
                    color : ' . $streamit_options['responsive_menu_button_color'] . ' !important;
                }';
                $inline_css .= 'header .menu-btn .line{
                    background-color : ' . $streamit_options['responsive_menu_button_color'] . ' !important;
                }';
                $inline_css .= 'header .navbar-light .navbar-toggler .menu-btn svg rect {
                    fill : ' . $streamit_options['responsive_menu_button_color'] . ' !important;
                }';
            }

            if (isset($streamit_options['responsive_menu_button_background_color']) && !empty($streamit_options['responsive_menu_button_background_color'])) {
                $inline_css .= 'header .navbar-light .navbar-toggler{
                background : ' . $streamit_options['responsive_menu_button_background_color'] . ' !important;
                border-color : ' . $streamit_options['responsive_menu_button_background_color'] . ' !important;
            }';
            }
            if (isset($streamit_options['responsive_menu_color']) && !empty($streamit_options['responsive_menu_color'])) {
                $inline_css .= '@media (max-width: 992px){
                    header .navbar ul li a{
                        color : ' . $streamit_options['responsive_menu_color'] . ' !important;
                    }
                }';

                $inline_css .= '@media (max-width: 992px){
                    .streamit-mobile-menu .navbar-nav>li>a,
                    .streamit-mobile-menu .navbar-nav li .sub-menu li a {
                        color : ' . $streamit_options['responsive_menu_color'] . ' !important;
                    }
                }';
            }
            if (isset($streamit_options['responsive_menu_color']) && !empty($streamit_options['responsive_menu_color'])) {
                $inline_css .= '@media (max-width: 992px){
                    header .navbar ul li a, header .navbar ul li i{
                        color : ' . $streamit_options['responsive_menu_color'] . ' !important;
                    }
                }';
            }

            if (isset($streamit_options['responsive_menu_hover_color']) && !empty($streamit_options['responsive_menu_hover_color'])) {
                $inline_css .= '@media (max-width: 992px){
                    header .navbar ul li:hover a,header .navbar ul li:hover i{
                        color : ' . $streamit_options['responsive_menu_hover_color'] . ' !important;
                    }
                }';
                $inline_css .= '@media (max-width: 992px){
                    .streamit-mobile-menu .navbar-nav>li:hover>a,
                    .streamit-mobile-menu .navbar-nav li.sub-menu li:hover a {
                        color : ' . $streamit_options['responsive_menu_hover_color'] . ' !important;
                    }
                }';
            }
            if (isset($streamit_options['responsive_menu_hover_color']) && !empty($streamit_options['responsive_menu_hover_color'])) {
                $inline_css .= '@media (max-width: 992px){
                header .navbar ul li:hover a,header .navbar ul li:hover i,header .navbar ul li.current-menu-item a, header .navbar ul li.current-menu-parent a, header .navbar ul li.current-menu-parent i, header .navbar ul li.current-menu-item i,header .navbar ul li.current-menu-ancestor a,header .navbar ul li.current-menu-ancestor i{
                    color : ' . $streamit_options['responsive_menu_hover_color'] . ' !important;
                }
            }';
            }

            (isset($streamit_options['responsive_menu_border_color_1']['rgba']) && !empty($streamit_options['responsive_menu_border_color_1']['rgba'])) ? $streamit_rgb_color_1 = $streamit_options['responsive_menu_border_color_1']['rgba'] : $streamit_rgb_color_1 = '';
            (isset($streamit_options['responsive_menu_border_color_2']['rgba']) && !empty($streamit_options['responsive_menu_border_color_2']['rgba'])) ? $streamit_rgb_color_2 = $streamit_options['responsive_menu_border_color_2']['rgba'] : $streamit_rgb_color_2 = '';
            (isset($streamit_options['responsive_menu_border_color_3']['rgba']) && !empty($streamit_options['responsive_menu_border_color_3']['rgba'])) ? $streamit_rgb_color_3 = $streamit_options['responsive_menu_border_color_3']['rgba'] : $streamit_rgb_color_3 = '';

            $inline_css .= '@media (max-width: 992px){
                .streamit-mobile-menu .navbar-nav>li>a,
                .streamit-mobile-menu .navbar-nav li .sub-menu li a {
                    border-image-source: linear-gradient(90deg,' . $streamit_rgb_color_1 . ',' . $streamit_rgb_color_2 . ',' . $streamit_rgb_color_3 . ') !important;
                }
            }';
        }

        if (!empty($inline_css)) {
            wp_add_inline_style('streamit-style', $inline_css);
        }
    }
    public function streamit_add_body_classes($classes)
    {
        global $streamit_options;

        if (is_plugin_active('advanced-custom-fields/acf.php') && get_post_meta(get_queried_object_id(), 'name_header_display', true) == 'yes') {
            switch (get_post_meta(get_queried_object_id(), 'header_position', true)) {
                case 'over':
                    $classes = array_merge($classes, array('iqonic-header-over'));
                    break;
                case 'under':
                    $classes = array_merge($classes, array('iqonic-header-under'));
                    break;
                default:
                    if (isset($streamit_options['header_postion'])) {
                        switch ($streamit_options['header_postion']) {
                            case 'over':
                                $classes = array_merge($classes, array('iqonic-header-over'));
                                break;

                            case 'under':
                                $classes = array_merge($classes, array('iqonic-header-under'));
                                break;
                        }
                    }
                    break;
            }
        } else {
            if (isset($streamit_options['header_postion'])) {

                switch ($streamit_options['header_postion']) {
                    case 'over':
                        $classes = array_merge($classes, array('iqonic-header-over'));
                        break;

                    case 'under':
                        $classes = array_merge($classes, array('iqonic-header-under'));
                        break;
                }
            }
        }
        return $classes;
    }
}
