<?php

/**
 * Streamit\Utility\Dynamic_Style\Styles\Footer class
 *
 * @package streamit
 */

namespace Streamit\Utility\Dynamic_Style\Styles;

use Streamit\Utility\Dynamic_Style\Component;

class Footer extends Component
{
	public function __construct()
	{
		add_action('wp_enqueue_scripts', array($this, 'streamit_footer_dynamic_style'), 20);
	}

	public function is_streamit_footer()
	{
		global $streamit_options;

		$is_footer = true;
		$page_id = get_queried_object_id();
		$footer_page_option = get_post_meta($page_id, "name_footer_display", true);
		$footer_page_option = !empty($footer_page_option) ? $footer_page_option : "default";

		if ($footer_page_option != 'default') {
			$is_footer =  ($footer_page_option == 'no') ? false : true;
		}

		if (is_404() && !$streamit_options['footer_on_404']) {
			$is_footer = false;
		}
		return $is_footer;
	}

	public function streamit_footer_dynamic_style()
	{

		global $streamit_options;

		$page_id = get_queried_object_id();
		$footer_css = '';

		if (is_plugin_active('advanced-custom-fields/acf.php') && get_post_meta($page_id, 'name_footer_display', true) == 'no') {
			$footer_css = 'footer { 
				display : none !important;
			}';
		} else if (is_plugin_active('advanced-custom-fields/acf.php') && get_post_meta($page_id, 'name_footer_display', true) == 'yes') {
			$footer_css = '.iq-register { 
				position : relative !important;
			}';
		} else if (isset($streamit_options['streamit_footer_top']) && $streamit_options['streamit_footer_top'] == 'no') {
			$footer_css = '.footer-top { 
				display : none !important;
			}';
		}

		if (class_exists('ReduxFramework') && isset($streamit_options['change_footer_color'])) {
			if ($streamit_options['change_footer_color'] == '0' && !empty($streamit_options['footer_color'])) {
				$footer_bg_color = $streamit_options['footer_color'];
				$footer_css .= ".footer {
							background-color: $footer_bg_color !important;
						}";
			}
			if (!empty($streamit_options['footer_image']['url']) && $streamit_options['change_footer_color'] == 'image') {
				$footer_bg_image = $streamit_options['footer_image'];
				$footer_css .= ".footer {
							background: url(" . $footer_bg_image['url'] . ") no-repeat !important;
							backgrouns-size: cover !important ;
						}";
			}
		}

		if (!empty($footer_css)) {
			wp_add_inline_style('streamit-style', $footer_css);
		}
	}
}
