<?php

/**
 * Streamit\Utility\Dynamic_Style\Styles\Breadcrumb class
 *
 * @package streamit
 */

namespace Streamit\Utility\Dynamic_Style\Styles;

use Streamit\Utility\Dynamic_Style\Component;
use function add_action;

class Breadcrumb extends Component
{
    public function __construct()
    {
        add_action('wp_enqueue_scripts', array($this, 'streamit_banner_dynamic_style'), 20);
        add_action('wp_enqueue_scripts', array($this, 'streamit_opacity_color'), 20);
        add_action('wp_enqueue_scripts', array($this, 'streamit_featured_hide'), 20);
        add_filter('body_class', array($this, 'streamit_breadcrumb_hide_class'), 20);
    }

    function streamit_breadcrumb_hide_class($classes)
    {
        global $streamit_options;

        $page_id = get_queried_object_id();
        $breadcrumb_page_option = get_post_meta($page_id, 'name_banner_display', true);
        $header_page_option = get_post_meta(get_queried_object_id(), 'name_header_display', true);

        if (($breadcrumb_page_option == 'no') && ($header_page_option == 'no')) {
            $classes[] = 'streamit-header-banner-hide';
        } else if ($breadcrumb_page_option == 'no' || (is_post_type_archive('person') && $streamit_options['display_banner'] == 'no')) {
            $classes[] = 'streamit-banner-hide';
        }
        return $classes;
    }

    public function is_streamit_breadcrumb()
    {
        $is_breadcrumb = true;
        $page_id = get_queried_object_id();
        global $streamit_options;

        $breadcrumb_page_option = get_post_meta($page_id, 'name_banner_display', true);
        $breadcrumb_page_option = (!empty($breadcrumb_page_option)) ? $breadcrumb_page_option : "default";

        if ($breadcrumb_page_option != "default") {
            $is_breadcrumb = ($breadcrumb_page_option == 'no') ? false : true;
        } elseif ($streamit_options['display_banner'] == "no") {
            $is_breadcrumb = false;
        } elseif (class_exists('WooCommerce') && is_product() && $streamit_options['product_display_banner'] == "no") {
            $is_breadcrumb = false;
        }

        return $is_breadcrumb;
    }

    public function streamit_banner_dynamic_style()
    {
        if (!$this->is_streamit_breadcrumb()) {
            return;
        }

        global $streamit_options;
        $dynamic_css = '';

        $dynamic_css .= isset($streamit_options['display_title']) && $streamit_options['display_title'] == 'no' ?  '.iq-breadcrumb-one .title { display: none !important; }' : '';
        $dynamic_css .= isset($streamit_options['display_breadcumb']) && $streamit_options['display_breadcumb'] == 'no' ?  '.iq-breadcrumb-one .breadcrumb { display: none !important; }' : '';

        if (isset($streamit_options['bg_title_color']) && !empty($streamit_options['bg_title_color'])) {
            $dynamic = $streamit_options['bg_title_color'];
            $dynamic_css .= !empty($dynamic) ? '.iq-breadcrumb-one .title { color: ' . $dynamic . ' !important; }' : '';
        }
        if (isset($streamit_options['bg_type'])) {
            $opt = $streamit_options['bg_type'];
            if ($opt == '1') {
                if (isset($streamit_options['bg_color']) && !empty($streamit_options['bg_color'])) {
                    $dynamic = $streamit_options['bg_color'];
                    $dynamic_css .= !empty($dynamic) ? '.iq-breadcrumb-one { background: ' . $dynamic . ' !important; }' : '';
                }
            }
            if ($opt == '2') {
                if (isset($streamit_options['banner_image']['url'])) {
                    $dynamic = $streamit_options['banner_image']['url'];
                    $dynamic_css .= !empty($dynamic) ? '.iq-breadcrumb-one { background-image: url(' . $dynamic . ') !important; }' : '';
                }
            }
        }
        if (!empty($dynamic_css)) {
            wp_add_inline_style('streamit-style', $dynamic_css);
        }
    }
    public function streamit_opacity_color()
    {
        //Set Background Opacity Color
        global $streamit_options;

        if (!empty($streamit_options['bg_opacity']) && $streamit_options['bg_opacity'] == "3") {
            $bg_opacity = $streamit_options['opacity_color']['rgba'];
        }

        if (!empty($streamit_options['bg_opacity']) && $streamit_options['bg_opacity'] == "3") {
            if (!empty($bg_opacity)) {
                $dynamic_css = "
                .breadcrumb-video::before,.breadcrumb-bg::before, .breadcrumb-ui::before {
                    background : $bg_opacity !important;
                }";
                wp_add_inline_style('streamit-style', $dynamic_css);
            }
        }
    }

    public function streamit_featured_hide()
    {
        global $streamit_options, $post;

        if (get_post_type() == 'post' && isset($streamit_options['posts_select']) && !is_404() &&  isset($streamit_options['mainte_mode']) && $streamit_options['mainte_mode'] == 'no') {
            $post_id        = $post->ID;
            $post_format    = get_post_format($post_id);
            $posts_format   = $streamit_options['posts_select'];

            if (in_array($post_format, $posts_format)) {
                $featured_hide = '.streamit-blog-main-list .format-' . $post_format . ' .iq-blog-box .iq-blog-image img { display : none !important }';
                wp_add_inline_style('streamit-style', $featured_hide);
            }
        }
    }
}
