<?php

/**
 * Streamit\Utility\Comments\Component class
 *
 * @package streamit
 */

namespace Streamit\Utility\Breadcrumb;

use Streamit\Utility\Component_Interface;
use Streamit\Utility\Templating_Component_Interface;

/**
 * Class for managing breadcrumb UI.
 *
 * Exposes template tags:
 * * `streamit()->streamit_breadcrumb( )`
 *
 * @link https://wordpress.org/plugins/amp/
 */

class Component implements Component_Interface, Templating_Component_Interface
{
	/**
	 * Gets the unique identifier for the theme component.
	 *
	 * @return string Component slug.
	 */

	public function get_slug(): string
	{
		return 'breadcrumb';
	}

	/**
	 * Adds the action and filter hooks to integrate with WordPress.
	 */

	public function initialize()
	{
	}

	/**
	 * Gets template tags to expose as methods on the Template_Tags class instance, accessible through `streamit()`.
	 *
	 * @return array Associative array of $method_name => $callback_info pairs. Each $callback_info must either be
	 *               a callable or an array with key 'callable'. This approach is used to reserve the possibility of
	 *               adding support for further arguments in the future.
	 */

	public function template_tags(): array
	{
		return [
			'streamit_breadcrumb' 	=> [$this, 'streamit_breadcrumb'],
		];
	}

	public function streamit_breadcrumb()
	{
		$post_id = get_queried_object_id();

		if (get_post_type() == "iqonic_hf_layout") return;

		//removes breadcrumb for PMP pages
		if (function_exists('pmpro_getOption')) {
			if (pmpro_getOption('levels_page_id') == $post_id) return;
			if (pmpro_getOption('checkout_page_id') == $post_id) return;
			if (pmpro_getOption('confirmation_page_id') == $post_id) return;
			if (pmpro_getOption('account_page_id') == $post_id) return;
			if (pmpro_getOption('billing_page_id') == $post_id) return;
			if (pmpro_getOption('cancel_page_id') == $post_id) return;
			if (pmpro_getOption('invoice_page_id') == $post_id) return;
			if (pmpro_getOption('login_page_id') == $post_id) return;
			if (pmpro_getOption('member_profile_edit_page_id') == $post_id) return;
		}

		if (is_404()) return;

		if (class_exists('MasVideos')) {
			if (is_singular('movie')) return;
			if (is_singular('video')) return;
			if (is_singular('tv_show')) return;
			if (is_singular('episode')) return;
			if (is_singular('person')) return;
		} ?>

		<div class="iq-breadcrumb-one">
			<div class="container-fluid">
				<?php if (class_exists('ReduxFramework')) {
					global $streamit_options;
					$breadcrumb_style = !empty($streamit_options['bg_image']) ? $streamit_options['bg_image'] : '';

					if ($breadcrumb_style == '2') { ?>
						<div class="row align-items-center">
							<div class="col-lg-8 col-md-8 text-left align-self-center">
								<nav aria-label="breadcrumb" class="text-left">
									<?php
									$this->streamit_breadcrumb_title();
									if (isset($streamit_options['display_breadcrumbs'])) {
										$display_breadcrumb = $streamit_options['display_breadcrumbs'];
										if ($display_breadcrumb == "yes") { ?>
									<?php $this->streamit_breadcrumb_nav("breadcrumb main-bg");
										}
									} ?>
								</nav>
							</div>
							<div class="col-lg-4 col-md-4 col-sm-12 text-right fadeInRight">
								<?php $this->streamit_breadcrumb_feature_image(); ?>
							</div>
						</div>
					<?php } elseif ($breadcrumb_style == '3') { ?>

						<div class="row align-items-center">
							<div class="col-lg-4 col-md-4 col-sm-12 fadeInLeft">
								<?php $this->streamit_breadcrumb_feature_image(); ?>
							</div>
							<div class="col-lg-8 col-md-8 text-left align-self-center">
								<nav aria-label="breadcrumb" class="text-right streamit-breadcrumb-nav">
									<?php
									$this->streamit_breadcrumb_title();
									if (isset($streamit_options['display_breadcrumbs'])) {
										$display_breadcrumb = $streamit_options['display_breadcrumbs'];
										if ($display_breadcrumb == "yes") {
											$this->streamit_breadcrumb_nav("breadcrumb main-bg justify-content-end");
										}
									} ?>
								</nav>
							</div>
						</div>
					<?php } elseif ($breadcrumb_style == '4') { ?>

						<div class="row align-items-center iq-breadcrumb-three">
							<div class="col-sm-6 mb-3 mb-lg-0 mb-md-0">
								<?php $this->streamit_breadcrumb_title(); ?>
							</div>
							<div class="col-sm-6 ext-lg-right text-md-right text-sm-left">
								<nav aria-label="breadcrumb" class="iq-breadcrumb-two">
									<?php
									if (isset($streamit_options['display_breadcrumbs'])) {
										$display_breadcrumb = $streamit_options['display_breadcrumbs'];
										if ($display_breadcrumb == "yes") {
											$this->streamit_breadcrumb_nav("breadcrumb main-bg justify-content-end");
										}
									} ?>
								</nav>
							</div>
						</div>
					<?php } elseif ($breadcrumb_style == '5') { ?>
						<div class="row align-items-center iq-breadcrumb-three">
							<div class="col-sm-6 mb-3 mb-lg-0 mb-md-0">
								<nav aria-label="breadcrumb" class="text-left iq-breadcrumb-two">
									<?php
									if (isset($streamit_options['display_breadcrumbs'])) {
										$display_breadcrumb = $streamit_options['display_breadcrumbs'];
										if ($display_breadcrumb == "yes") {
											$this->streamit_breadcrumb_nav("breadcrumb main-bg justify-content-start");
										}
									} ?>
								</nav>
							</div>
							<div class="col-sm-6 text-right">
								<?php $this->streamit_breadcrumb_title(); ?>
							</div>
						</div>
					<?php } else { ?>
						<div class="row align-items-center justify-content-center text-center">
							<div class="col-sm-12">
								<nav aria-label="breadcrumb" class="text-center iq-breadcrumb-two">
									<?php
									$this->streamit_breadcrumb_title();
									if (isset($streamit_options['display_breadcrumbs'])) {
										$display_breadcrumb = $streamit_options['display_breadcrumbs'];
										if ($display_breadcrumb == "yes") {
											$this->streamit_breadcrumb_nav("breadcrumb main-bg");
										}
									} ?>
								</nav>
							</div>
						</div>
					<?php }
				} else { ?>
					<div class="row align-items-center">
						<div class="col-sm-12">
							<nav aria-label="breadcrumb" class="text-center">
								<?php $this->streamit_breadcrumb_title();
								$this->streamit_breadcrumb_nav("breadcrumb main-bg"); ?>
							</nav>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
		<?php
	}

	function streamit_breadcrumb_title()
	{
		global $streamit_options;
		$title_tag = 'h2';
		$title = '';
		if (isset($streamit_options['breadcum_title_tag']) && !empty($streamit_options['breadcum_title_tag'])) {
			$title_tag = $streamit_options['breadcum_title_tag'];
		}

		if (is_archive()) {
			$title = get_the_archive_title();
		} elseif (is_search()) {
			$title = esc_html__('Search', 'streamit');
		} elseif (is_404()) {
			if (isset($streamit_options['streamit_fourzerofour_title'])) {
				$title = $streamit_options['streamit_fourzerofour_title'];
			} else {
				$title = __('Oops! That page can not be found.', 'streamit');
			}
		} elseif (is_home()) {
			$title = wp_title('', false);
		} else {
			$title = get_the_title();
		}

		if (!empty(trim($title))) : ?>
			<<?php echo esc_attr($title_tag); ?> class="title">
				<?php echo wp_kses($title, array(['span' => array()])); ?>
			</<?php echo esc_attr($title_tag); ?>>
		<?php
		endif;
	}

	function streamit_breadcrumb_feature_image()
	{
		global $streamit_options;
		$bnurl = '';
		$page_id = get_queried_object_id();

		if (has_post_thumbnail($page_id) && !is_single()) {
			$image_array = wp_get_attachment_image_src(get_post_thumbnail_id($page_id), 'full');
			$bnurl = $image_array[0];
		} elseif (is_404()) {
			if (!empty($streamit_options['streamit_404_banner_image']['url'])) {
				$bnurl = $streamit_options['streamit_404_banner_image']['url'];
			}
		} elseif (is_home()) {
			if (!empty($streamit_options['streamit_blog_banner_image']['url'])) {
				$bnurl = $streamit_options['streamit_blog_banner_image']['url'];
			}
		} else {
			if (!empty($streamit_options['streamit_page_banner_image']['url'])) {
				$bnurl = $streamit_options['streamit_page_banner_image']['url'];
			}
		}

		if (!empty($bnurl)) {
			$img_pos = "";
			if (!empty($streamit_options['bg_image']) && !$streamit_options['bg_image'] == 1) {
				$img_pos = 'float-right';
			} ?>

			<img src="<?php echo esc_url($bnurl); ?>" class="img-fluid <?php echo esc_attr($img_pos) ?>" alt="<?php esc_attr_e('banner', 'streamit'); ?>">
<?php
		}
	}

	function streamit_breadcrumb_nav($class = "")
	{
		$show_on_home = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
		$home = esc_html__('Home', 'streamit'); // text for the 'Home' link
		$show_current = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show

		global $post;
		$home_link = esc_url(home_url());


		//return if nav option is not enable
		$page_id = get_queried_object_id();
		global $streamit_options;
		$page_option = get_post_meta($page_id, 'display_breadcrumb_nav', true);
		if ($page_option == 'no') {
			return;
		} else if (isset($streamit_options['display_breadcrumb_nav']) && $streamit_options['display_breadcrumb_nav'] == 'no') {
			return;
		}

		echo '<ol class="' . esc_attr($class) . '">';

		if (is_front_page()) {
			if ($show_on_home == 1) echo '<li class="breadcrumb-item"><a href="' . $home_link . '">' . $home . '</a></li>';
		} else {
			echo '<li class="breadcrumb-item"><a href="' . $home_link . '">' . $home . '</a></li> ';
			if (is_home()) {
				echo  '<li class="breadcrumb-item active">' . esc_html__('Blogs', 'streamit') . '</li>';
			} elseif (is_category()) {
				$this_cat = get_category(get_query_var('cat'), false);
				if ($this_cat->parent != 0) echo '<li class="breadcrumb-item">' . get_category_parents($this_cat->parent, TRUE, '  ') . '</li>';
				echo  '<li class="breadcrumb-item active">' . esc_html__('Archive by category : ', 'streamit') . ' "' . single_cat_title('', false) . '" </li>';
			} elseif (is_search()) {
				echo  '<li class="breadcrumb-item active">' . esc_html__('Search results for : ', 'streamit') . ' "' . get_search_query() . '"</li>';
			} elseif (is_day()) {
				echo '<li class="breadcrumb-item"><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ';
				echo '<li class="breadcrumb-item"><a href="' . get_month_link(get_the_time('Y'), get_the_time('m')) . '">' . get_the_time('F') . '</a></li>  ';
				echo  '<li class="breadcrumb-item active">' . get_the_time('d') . '</li>';
			} elseif (is_month()) {
				echo '<li class="breadcrumb-item"><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ';
				echo  '<li class="breadcrumb-item active">' . get_the_time('F') . '</li>';
			} elseif (is_year()) {
				echo  '<li class="breadcrumb-item active">' . get_the_time('Y') . '</li>';
			} elseif (is_single() && !is_attachment()) {
				if (get_post_type() != 'post') {
					$post_type = get_post_type_object(get_post_type());
					$slug = $post_type->rewrite;
					if (!empty($slug)) {
						echo '<li class="breadcrumb-item"><a href="' . $home_link . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a></li>';
					}
					if ($show_current == 1) echo '<li class="breadcrumb-item">' . get_the_title() . '</li>';
				} else {
					$cat = get_the_category();
					if (!empty($cat)) {
						$cat = $cat[0];

						if ($show_current == 0) $cat = preg_replace("#^(.+)\s\s$#", "$1", $cat);
						echo '<li class="breadcrumb-item">' . get_category_parents($cat, TRUE, '  ') . '</li>';
						if (!empty(get_the_title())) {
							if ($show_current == 1) echo  '<li class="breadcrumb-item active">' . get_the_title() . '</li>';
						}
					}
				}
			} elseif (!is_single() && !is_page() && get_post_type() != 'post' && !is_404()) {
				$post_type = get_post_type_object(get_post_type());
				if (!empty($post_type->labels->singular_name)) {
					echo  '<li class="breadcrumb-item active">' . $post_type->labels->singular_name . '</li>';
				}
			} elseif (!is_single() && is_attachment()) {
				$parent = get_post($post->post_parent);
				$cat = get_the_category($parent->ID);
				$cat = $cat[0];
				echo '<li class="breadcrumb-item">' . get_category_parents($cat, TRUE, '  ') . '</li>';
				echo '<li class="breadcrumb-item"><a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a></li>';
				if ($show_current == 1) echo '<li class="breadcrumb-item active"> ' .  get_the_title() . '</li>';
			} elseif (is_page() && !$post->post_parent) {
				if ($show_current == 1) echo  '<li class="breadcrumb-item active">' . get_the_title() . '</li>';
			} elseif (is_page() && $post->post_parent) {
				$trail = '';
				// $page_title = '<li class="breadcrumb-item">' . get_the_title($post->ID) . '</li>';
				if ($post->post_parent) {
					$parent_id = $post->post_parent;
					$breadcrumbs = array();
					while ($parent_id) {
						$page = get_post($parent_id);
						$breadcrumbs[] = '<li class="breadcrumb-item"><a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a></li>';
						$parent_id  = $page->post_parent;
					}
					$breadcrumbs = array_reverse($breadcrumbs);
					foreach ($breadcrumbs as $crumb) $trail .= $crumb;
				}

				echo wp_kses($trail, ["li" => ["class" => true], "a" => ["href" => true]]);
				if ($show_current == 1) echo '<li class="breadcrumb-item active"> ' .  get_the_title() . '</li>';
			} elseif (is_tag()) {
				echo  '<li class="breadcrumb-item active">' . esc_html__('Posts tagged', 'streamit') . ' "' . single_tag_title('', false) . '"</li>';
			} elseif (is_author()) {
				global $author;
				$userdata = get_userdata($author);
				echo  '<li class="breadcrumb-item active">' . esc_html__('Articles posted by : ', 'streamit') . ' ' . $userdata->display_name . '</li>';
			} elseif (is_404()) {
				echo  '<li class="breadcrumb-item active">' . esc_html__('Error 404', 'streamit') . '</li>';
			}

			if (get_query_var('paged')) {
				echo '<li class="breadcrumb-item active">' . esc_html__('Page', 'streamit') . ' ' . get_query_var('paged') . '</li>';
			}
		}
		echo '</ol>';
	}
}
